/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.item.bauble.enderPocket;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.Global;
import com.github.yimeng261.maidspell.item.MaidSpellItems;
import com.github.yimeng261.maidspell.spell.manager.BaubleStateManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class EnderPocketService {
    public static List<EnderPocketMaidInfo> getPlayerEnderPocketMaids(ServerPlayer player) {
        return EnderPocketService.getPlayerEnderPocketMaids(player.m_20148_());
    }

    public static List<EnderPocketMaidInfo> getPlayerEnderPocketMaids(UUID playerUUID) {
        Map<UUID, EntityMaid> maids = Global.getOrCreatePlayerMaidMap(playerUUID);
        if (maids == null || maids.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<EnderPocketMaidInfo> enderPocketMaids = new ArrayList<EnderPocketMaidInfo>();
        for (EntityMaid maid : maids.values()) {
            if (!BaubleStateManager.hasBauble(maid, MaidSpellItems.ENDER_POCKET)) continue;
            enderPocketMaids.add(new EnderPocketMaidInfo(maid.m_20148_(), maid.m_7755_().getString(), maid.m_19879_()));
        }
        return enderPocketMaids;
    }

    public static boolean openMaidInventory(ServerPlayer player, int maidEntityId) {
        Entity entity = player.m_9236_().m_6815_(maidEntityId);
        if (!(entity instanceof EntityMaid)) {
            return false;
        }
        EntityMaid maid = (EntityMaid)entity;
        if (!maid.m_21830_((LivingEntity)player) || maid.m_5803_() || !maid.m_6084_()) {
            return false;
        }
        maid.openMaidGui((Player)player, 0);
        return true;
    }

    public record EnderPocketMaidInfo(UUID maidUUID, String maidName, int maidEntityId) {
    }
}

