/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.dimension;

import com.github.yimeng261.maidspell.MaidSpellMod;
import com.github.yimeng261.maidspell.dimension.PlayerRetreatManager;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="touhou_little_maid_spell")
public class TheRetreatDimension {
    public static ResourceKey<Level> getPlayerRetreatDimension(UUID playerUUID) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("touhou_little_maid_spell", "the_retreat_" + playerUUID.toString().replace("-", "_")));
    }

    public static void teleportToRetreat(ServerPlayer player) {
        MinecraftServer server = player.m_20194_();
        if (server == null) {
            return;
        }
        ServerLevel retreatLevel = PlayerRetreatManager.getOrCreatePlayerRetreat(server, player.m_20148_());
        if (retreatLevel == null) {
            MaidSpellMod.LOGGER.error("Failed to get or create retreat dimension for player: {}", (Object)player.m_7755_().getString());
            return;
        }
        BlockPos safePos = TheRetreatDimension.findSafePosition(retreatLevel, player.m_20183_());
        player.changeDimension(retreatLevel, (ITeleporter)new RetreatTeleporter(safePos));
        player.m_9158_(retreatLevel.m_46472_(), safePos, 0.0f, true, false);
        MaidSpellMod.LOGGER.info("Teleported player {} to retreat dimension at {} and set respawn point", (Object)player.m_7755_().getString(), (Object)safePos);
    }

    public static void teleportFromRetreat(ServerPlayer player) {
        MinecraftServer server = player.m_20194_();
        if (server == null) {
            return;
        }
        ServerLevel overworld = server.m_129880_(Level.f_46428_);
        if (overworld == null) {
            return;
        }
        BlockPos safePos = TheRetreatDimension.findSafePosition(overworld, player.m_20183_());
        player.changeDimension(overworld, (ITeleporter)new RetreatTeleporter(safePos));
        MaidSpellMod.LOGGER.info("Teleported player {} from retreat dimension to overworld at {}", (Object)player.m_7755_().getString(), (Object)safePos);
    }

    public static boolean isInRetreat(Entity entity) {
        ResourceLocation dimensionLocation = entity.m_9236_().m_46472_().m_135782_();
        return dimensionLocation.m_135827_().equals("touhou_little_maid_spell") && dimensionLocation.m_135815_().startsWith("the_retreat");
    }

    public static boolean isInOwnRetreat(ServerPlayer player) {
        ResourceKey<Level> playerRetreat = TheRetreatDimension.getPlayerRetreatDimension(player.m_20148_());
        return player.m_9236_().m_46472_().equals(playerRetreat);
    }

    private static BlockPos findSafePosition(ServerLevel level, BlockPos targetPos) {
        for (int y = level.m_151558_(); y >= level.m_141937_(); --y) {
            BlockPos pos = new BlockPos(targetPos.m_123341_(), y, targetPos.m_123343_());
            if (!level.m_8055_(pos).m_280296_()) continue;
            return pos.m_7494_();
        }
        return TheRetreatDimension.createSafePlatform(level, targetPos.m_6630_(2));
    }

    private static BlockPos createSafePlatform(ServerLevel level, BlockPos pos) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos platformPos = pos.m_7918_(x, -1, z);
                level.m_7731_(platformPos, Blocks.f_50069_.m_49966_(), 3);
            }
        }
        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        level.m_7731_(pos.m_7494_(), Blocks.f_50016_.m_49966_(), 3);
        return pos;
    }

    @SubscribeEvent
    public static void onLevelUnload(LevelEvent.Unload event) {
        ServerLevel serverLevel;
        ResourceLocation dimensionLocation;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (dimensionLocation = (serverLevel = (ServerLevel)levelAccessor).m_46472_().m_135782_()).m_135827_().equals("touhou_little_maid_spell") && dimensionLocation.m_135815_().startsWith("the_retreat_")) {
            MaidSpellMod.LOGGER.info("Unloading retreat dimension: " + String.valueOf(dimensionLocation));
        }
    }

    public record RetreatTeleporter(BlockPos targetPos) implements ITeleporter
    {
        public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
            Entity repositioned = repositionEntity.apply(false);
            if (repositioned != null) {
                repositioned.m_7678_((double)this.targetPos.m_123341_() + 0.5, (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_() + 0.5, yaw, entity.m_146909_());
            }
            return repositioned;
        }

        public PortalInfo getPortalInfo(Entity entity, ServerLevel destWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
            return new PortalInfo(new Vec3((double)this.targetPos.m_123341_() + 0.5, (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_() + 0.5), Vec3.f_82478_, entity.m_146908_(), entity.m_146909_());
        }
    }
}

