/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.Config;
import com.github.yimeng261.maidspell.api.IMaidSpellData;
import com.github.yimeng261.maidspell.utils.DataItem;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import org.slf4j.Logger;

public class Global {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final List<BiFunction<LivingHurtEvent, EntityMaid, Void>> commonDamageCalc = new CopyOnWriteArrayList<BiFunction<LivingHurtEvent, EntityMaid, Void>>();
    public static final List<BiFunction<LivingDamageEvent, Player, Void>> playerHurtCalcAft = new CopyOnWriteArrayList<BiFunction<LivingDamageEvent, Player, Void>>();
    public static final Map<UUID, Map<UUID, EntityMaid>> maidInfos = new ConcurrentHashMap<UUID, Map<UUID, EntityMaid>>();
    public static final Set<EntityMaid> maidList = ConcurrentHashMap.newKeySet();
    public static final List<BiFunction<LivingHurtEvent, EntityMaid, Void>> commonHurtCalc = new CopyOnWriteArrayList<BiFunction<LivingHurtEvent, EntityMaid, Void>>();
    public static final List<Function<IMaidSpellData.CoolDown, Void>> commonCoolDownCalc = new CopyOnWriteArrayList<Function<IMaidSpellData.CoolDown, Void>>();
    public static final Map<Item, BiFunction<LivingDamageEvent, EntityMaid, Void>> baubleDamageCalcAft = new ConcurrentHashMap<Item, BiFunction<LivingDamageEvent, EntityMaid, Void>>();
    public static final Map<Item, BiFunction<LivingHurtEvent, EntityMaid, Void>> baubleDamageCalcPre = new ConcurrentHashMap<Item, BiFunction<LivingHurtEvent, EntityMaid, Void>>();
    public static final Map<Item, BiFunction<LivingHurtEvent, EntityMaid, Void>> baubleCommonHurtCalcPre = new ConcurrentHashMap<Item, BiFunction<LivingHurtEvent, EntityMaid, Void>>();
    public static final Map<Item, Function<DataItem, Void>> baubleHurtCalcPre = new ConcurrentHashMap<Item, Function<DataItem, Void>>();
    public static final Map<Item, Function<DataItem, Void>> baubleHurtCalcFinal = new ConcurrentHashMap<Item, Function<DataItem, Void>>();
    public static final Map<Item, Function<IMaidSpellData.CoolDown, Void>> baubleCoolDownCalc = new ConcurrentHashMap<Item, Function<IMaidSpellData.CoolDown, Void>>();
    public static final Map<Item, BiFunction<MobEffectEvent.Added, EntityMaid, Void>> baubleEffectAddedCalc = new ConcurrentHashMap<Item, BiFunction<MobEffectEvent.Added, EntityMaid, Void>>();
    public static final Map<Item, BiFunction<LivingDeathEvent, EntityMaid, Void>> baubleDeathCalc = new ConcurrentHashMap<Item, BiFunction<LivingDeathEvent, EntityMaid, Void>>();

    public static void resetCommonDamageCalc() {
        commonDamageCalc.clear();
        commonDamageCalc.add((event, maid) -> {
            LivingEntity entity = event.getEntity();
            if (entity instanceof EntityMaid) {
                event.setCanceled(true);
            } else if (entity instanceof Player) {
                event.setCanceled(true);
            }
            return null;
        });
        commonDamageCalc.add((hurtEvent, maid) -> {
            if (maid.getTask().getUid().toString().startsWith("maidspell")) {
                hurtEvent.setAmount((float)((double)hurtEvent.getAmount() * Config.spellDamageMultiplier));
            }
            return null;
        });
    }

    public static void resetCommonCoolDownCalc() {
        commonCoolDownCalc.clear();
        commonCoolDownCalc.add(coolDown -> {
            coolDown.cooldownticks = (int)((double)coolDown.cooldownticks * Config.coolDownMultiplier);
            return null;
        });
    }

    public static Map<UUID, EntityMaid> getOrCreatePlayerMaidMap(UUID playerUUID) {
        return maidInfos.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap());
    }

    public static void updateMaidInfo(EntityMaid maid, Boolean add) {
        UUID ownerUUID = maid.m_21805_();
        if (add.booleanValue()) {
            maidList.add(maid);
            if (ownerUUID != null) {
                Global.getOrCreatePlayerMaidMap(ownerUUID).put(maid.m_20148_(), maid);
            }
        } else {
            maidList.remove(maid);
            if (ownerUUID != null) {
                Global.getOrCreatePlayerMaidMap(ownerUUID).remove(maid.m_20148_());
            }
        }
    }
}

