/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell;

import com.github.yimeng261.maidspell.Global;
import com.github.yimeng261.maidspell.spell.SimplifiedSpellCaster;
import com.github.yimeng261.maidspell.task.SpellCombatFarTask;
import com.github.yimeng261.maidspell.task.SpellCombatMeleeTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="touhou_little_maid_spell", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.DoubleValue MAX_SPELL_RANGE;
    private static final ForgeConfigSpec.DoubleValue MELEE_RANGE;
    private static final ForgeConfigSpec.DoubleValue FAR_RANGE;
    private static final ForgeConfigSpec.DoubleValue SPELL_DAMAGE_MULTIPLIER;
    private static final ForgeConfigSpec.DoubleValue COOLDOWN_MULITIPLIER;
    private static final ForgeConfigSpec.IntValue MELEE_ATTACK_INTERVAL;
    private static final ForgeConfigSpec.IntValue FAR_ATTACK_INTERVAL;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> SPELL_BLACKLIST;
    private static final ForgeConfigSpec.DoubleValue SILVER_CERCIS_TRUE_DAMAGE_MULTIPLIER;
    private static final ForgeConfigSpec.DoubleValue SPRING_RING_MAX_DAMAGE_BONUS;
    private static final ForgeConfigSpec.DoubleValue FLOW_CORE_HEALTH_REGEN_RATE;
    private static final ForgeConfigSpec.DoubleValue BLEEDING_HEART_HEAL_RATIO;
    private static final ForgeConfigSpec.DoubleValue FLOW_CORE_DAMAGE_REDUCTION;
    private static final ForgeConfigSpec.DoubleValue DOUBLE_HEART_CHAIN_SHARE_RATIO;
    private static final ForgeConfigSpec.DoubleValue QUICK_CHANT_RING_COOLDOWN_REDUCTION;
    private static final ForgeConfigSpec.IntValue ROCK_CRYSTAL_KNOCKBACK_RESISTANCE;
    private static final ForgeConfigSpec.IntValue FLOW_CORE_TICK_INTERVAL;
    private static final ForgeConfigSpec.DoubleValue HAIRPIN_BENEFICIAL_EFFECT_EXTENSION;
    private static final ForgeConfigSpec.IntValue HAIRPIN_MIN_EXTENSION_TICKS;
    private static final ForgeConfigSpec.IntValue FRAGRANT_INGENUITY_FAVORABILITY_GAIN;
    private static final ForgeConfigSpec.IntValue FRAGRANT_INGENUITY_BUFF_DURATION;
    private static final ForgeConfigSpec.IntValue SILVER_CERCIS_TRIGGER_COUNT;
    private static final ForgeConfigSpec.IntValue SILVER_CERCIS_COOLDOWN_TICKS;
    private static final ForgeConfigSpec.IntValue WOUND_RIME_BLADE_RECORD_DURATION;
    private static final ForgeConfigSpec.DoubleValue CHAOS_BOOK_TRUE_DAMAGE_MIN;
    private static final ForgeConfigSpec.DoubleValue CHAOS_BOOK_TRUE_DAMAGE_PERCENT;
    private static final ForgeConfigSpec.IntValue CHAOS_BOOK_DAMAGE_SPLIT_COUNT;
    private static final ForgeConfigSpec.DoubleValue CHAOS_BOOK_MIN_SPLIT_DAMAGE;
    private static final ForgeConfigSpec.DoubleValue SOUL_BOOK_DAMAGE_THRESHOLD_PERCENT;
    private static final ForgeConfigSpec.IntValue SOUL_BOOK_DAMAGE_INTERVAL_THRESHOLD;
    public static final ForgeConfigSpec SPEC;
    public static double maxSpellRange;
    public static double meleeRange;
    public static double farRange;
    public static double spellDamageMultiplier;
    public static double coolDownMultiplier;
    public static int meleeAttackInterval;
    public static int farAttackInterval;
    public static List<String> spellBlacklist;
    public static double silverCercisTrueDamageMultiplier;
    public static double springRingMaxDamageBonus;
    public static double flowCoreHealthRegenRate;
    public static double bleedingHeartHealRatio;
    public static double flowCoreDamageReduction;
    public static double doubleHeartChainShareRatio;
    public static double quickChantRingCooldownReduction;
    public static int rockCrystalKnockbackResistance;
    public static int flowCoreTickInterval;
    public static int silverCercisTriggerCount;
    public static int silverCercisCooldownTicks;
    public static int woundRimeBladeRecordTimes;
    public static double hairpinBeneficialEffectExtension;
    public static int hairpinMinExtensionTicks;
    public static int fragrantIngenuityFavorabilityGain;
    public static int fragrantIngenuityBuffDuration;
    public static double chaosBookTrueDamageMin;
    public static double chaosBookTrueDamagePercent;
    public static int chaosBookDamageSplitCount;
    public static double chaosBookMinSplitDamage;
    public static double soulBookDamageThresholdPercent;
    public static int soulBookDamageIntervalThreshold;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        maxSpellRange = (Double)MAX_SPELL_RANGE.get();
        meleeRange = (Double)MELEE_RANGE.get();
        spellDamageMultiplier = (Double)SPELL_DAMAGE_MULTIPLIER.get();
        coolDownMultiplier = (Double)COOLDOWN_MULITIPLIER.get();
        farRange = (Double)FAR_RANGE.get();
        meleeAttackInterval = (Integer)MELEE_ATTACK_INTERVAL.get();
        farAttackInterval = (Integer)FAR_ATTACK_INTERVAL.get();
        spellBlacklist = new ArrayList<String>((Collection)SPELL_BLACKLIST.get());
        silverCercisTrueDamageMultiplier = (Double)SILVER_CERCIS_TRUE_DAMAGE_MULTIPLIER.get();
        springRingMaxDamageBonus = (Double)SPRING_RING_MAX_DAMAGE_BONUS.get();
        flowCoreHealthRegenRate = (Double)FLOW_CORE_HEALTH_REGEN_RATE.get();
        bleedingHeartHealRatio = (Double)BLEEDING_HEART_HEAL_RATIO.get();
        flowCoreDamageReduction = (Double)FLOW_CORE_DAMAGE_REDUCTION.get();
        doubleHeartChainShareRatio = (Double)DOUBLE_HEART_CHAIN_SHARE_RATIO.get();
        quickChantRingCooldownReduction = (Double)QUICK_CHANT_RING_COOLDOWN_REDUCTION.get();
        rockCrystalKnockbackResistance = (Integer)ROCK_CRYSTAL_KNOCKBACK_RESISTANCE.get();
        flowCoreTickInterval = (Integer)FLOW_CORE_TICK_INTERVAL.get();
        silverCercisTriggerCount = (Integer)SILVER_CERCIS_TRIGGER_COUNT.get();
        silverCercisCooldownTicks = (Integer)SILVER_CERCIS_COOLDOWN_TICKS.get();
        woundRimeBladeRecordTimes = (Integer)WOUND_RIME_BLADE_RECORD_DURATION.get();
        hairpinBeneficialEffectExtension = (Double)HAIRPIN_BENEFICIAL_EFFECT_EXTENSION.get();
        hairpinMinExtensionTicks = (Integer)HAIRPIN_MIN_EXTENSION_TICKS.get();
        fragrantIngenuityFavorabilityGain = (Integer)FRAGRANT_INGENUITY_FAVORABILITY_GAIN.get();
        fragrantIngenuityBuffDuration = (Integer)FRAGRANT_INGENUITY_BUFF_DURATION.get();
        chaosBookTrueDamageMin = (Double)CHAOS_BOOK_TRUE_DAMAGE_MIN.get();
        chaosBookTrueDamagePercent = (Double)CHAOS_BOOK_TRUE_DAMAGE_PERCENT.get();
        chaosBookDamageSplitCount = (Integer)CHAOS_BOOK_DAMAGE_SPLIT_COUNT.get();
        chaosBookMinSplitDamage = (Double)CHAOS_BOOK_MIN_SPLIT_DAMAGE.get();
        soulBookDamageThresholdPercent = (Double)SOUL_BOOK_DAMAGE_THRESHOLD_PERCENT.get();
        soulBookDamageIntervalThreshold = (Integer)SOUL_BOOK_DAMAGE_INTERVAL_THRESHOLD.get();
        SpellCombatMeleeTask.setSpellRange(Float.valueOf((float)maxSpellRange));
        SpellCombatFarTask.setSpellRange(Float.valueOf((float)maxSpellRange));
        SimplifiedSpellCaster.MELEE_RANGE = (float)meleeRange;
        SimplifiedSpellCaster.FAR_RANGE = (float)farRange;
        Global.resetCommonDamageCalc();
        Global.resetCommonCoolDownCalc();
    }

    static {
        BUILDER.comment("\u6218\u6597\u7cfb\u7edf\u76f8\u5173\u914d\u7f6e").comment("Combat system configurations").push("combat");
        MAX_SPELL_RANGE = BUILDER.comment("\u6700\u5927\u6cd5\u672f\u653b\u51fb\u8303\u56f4 (\u9ed8\u8ba4: 24.0)").comment("Maximum spell attack range").defineInRange("maxSpellRange", 24.0, 8.0, 64.0);
        BUILDER.comment("");
        MELEE_RANGE = BUILDER.comment("\u8fd1\u6218\u653b\u51fb\u8303\u56f4 (\u9ed8\u8ba4: 2.5)").comment("Melee attack range").defineInRange("meleeRange", 2.5, 1.0, 5.0);
        BUILDER.comment("");
        FAR_RANGE = BUILDER.comment("\u8fdc\u7a0b\u653b\u51fb\u8303\u56f4 (\u9ed8\u8ba4: 8.5)").comment("Far attack range").defineInRange("farRange", 8.5, 1.0, 20.0);
        BUILDER.comment("");
        SPELL_DAMAGE_MULTIPLIER = BUILDER.comment("\u5973\u4ec6\u4f24\u5bb3\u500d\u7387 (\u9ed8\u8ba4: 1.0\uff0c\u4ec5\u5728\u6cd5\u672f\u6218\u6597\u4efb\u52a1\u4e0b\u751f\u6548)").comment("Maid damage multiplier(default:1.0,only effective on spellCombatTask)").defineInRange("maidDamageMultiplier", 1.0, 0.0, 50.0);
        BUILDER.comment("");
        COOLDOWN_MULITIPLIER = BUILDER.comment("\u5973\u4ec6\u6cd5\u672f\u51b7\u5374\u500d\u7387 (\u9ed8\u8ba4: 1.0\uff0c\u4ec5\u5728\u6cd5\u672f\u6218\u6597\u4efb\u52a1\u4e0b\u751f\u6548)").comment("Maid cooldown multiplier(default:1.0,only effective on spellCombatTask)").defineInRange("maidCooldownMultiplier", 1.0, 0.0, 50.0);
        BUILDER.comment("");
        MELEE_ATTACK_INTERVAL = BUILDER.comment("\u8fd1\u6218\u6cd5\u672f\u4efb\u52a1\u653b\u51fb\u95f4\u9694\uff08\u5355\u4f4d\uff1atick\uff0c\u9ed8\u8ba4: 8\uff09").comment("Melee spell task attack interval (in ticks, default: 8)").defineInRange("meleeAttackInterval", 8, 1, 100);
        BUILDER.comment("");
        FAR_ATTACK_INTERVAL = BUILDER.comment("\u8fdc\u7a0b\u6cd5\u672f\u4efb\u52a1\u653b\u51fb\u95f4\u9694\uff08\u5355\u4f4d\uff1atick\uff0c\u9ed8\u8ba4: 5\uff09").comment("Far spell task attack interval (in ticks, default: 5)").defineInRange("farAttackInterval", 5, 1, 100);
        BUILDER.comment("");
        SPELL_BLACKLIST = BUILDER.comment("\u6cd5\u672f\u9ed1\u540d\u5355\uff0c\u5973\u4ec6\u4e0d\u4f1a\u65bd\u653e\u8fd9\u4e9b\u6cd5\u672f").comment("Spell blacklist, maids will not cast these spells").comment("\u793a\u4f8b: [\"irons_spellbooks:spectral_hammer\", \"irons_spellbooks:firecracker\"]").comment("Example: [\"irons_spellbooks:spectral_hammer\", \"irons_spellbooks:firecracker\"]").defineListAllowEmpty(List.of("spellBlacklist"), () -> List.of("irons_spellbooks:spectral_hammer"), obj -> obj instanceof String);
        BUILDER.pop();
        BUILDER.comment("\u9970\u54c1\u7cfb\u7edf\u76f8\u5173\u914d\u7f6e").comment("Bauble system configurations").push("baubles");
        BUILDER.comment("\u4f24\u5bb3\u76f8\u5173\u9970\u54c1\u914d\u7f6e").comment("Damage-related bauble configurations").push("damage");
        SILVER_CERCIS_TRUE_DAMAGE_MULTIPLIER = BUILDER.comment("\u7d2b\u8346\u94f6\u51a0\u53cd\u4f24\u500d\u7387 (\u9ed8\u8ba4: 0.8)").comment("Silver Cercis true damage multiplier").defineInRange("silverCercisTrueDamageMultiplier", 0.8, 0.1, 2.0);
        BUILDER.comment("");
        SPRING_RING_MAX_DAMAGE_BONUS = BUILDER.comment("\u70ec\u8840\u4e4b\u6212\u6700\u5927\u4f24\u5bb3\u52a0\u6210\u6bd4\u4f8b (\u9ed8\u8ba4: 0.5)").comment("Spring Ring maximum damage bonus ratio").defineInRange("springRingMaxDamageBonus", 0.5, 0.1, 1.0);
        BUILDER.pop();
        BUILDER.comment("\u6cbb\u7597\u76f8\u5173\u9970\u54c1\u914d\u7f6e").comment("Healing-related bauble configurations").push("healing");
        FLOW_CORE_HEALTH_REGEN_RATE = BUILDER.comment("\u6d41\u8f6c\u6838\u5fc3\u6bcf\u7ea7\u597d\u611f\u751f\u547d\u6062\u590d\u767e\u5206\u6bd4 (\u9ed8\u8ba4: 0.025)").comment("Flow Core health regeneration rate").defineInRange("flowCoreHealthRegenRate", 0.025, 0.001, 0.3);
        BUILDER.comment("");
        BLEEDING_HEART_HEAL_RATIO = BUILDER.comment("\u558b\u8840\u4e4b\u5fc3\u6cbb\u7597\u6bd4\u4f8b (\u9ed8\u8ba4: 0.1)").comment("Bleeding Heart heal ratio").defineInRange("bleedingHeartHealRatio", 0.1, 0.01, 1.0);
        BUILDER.pop();
        BUILDER.comment("\u9632\u5fa1\u76f8\u5173\u9970\u54c1\u914d\u7f6e").comment("Defense-related bauble configurations").push("defense");
        FLOW_CORE_DAMAGE_REDUCTION = BUILDER.comment("\u6d41\u8f6c\u6838\u5fc3\u6bcf\u7ea7\u597d\u611f\u4f24\u5bb3\u51cf\u514d\u6bd4\u4f8b (\u9ed8\u8ba4: 0.15)").comment("Flow Core damage reduction ratio").defineInRange("flowCoreDamageReduction", 0.15, 0.05, 0.5);
        BUILDER.comment("");
        DOUBLE_HEART_CHAIN_SHARE_RATIO = BUILDER.comment("\u53cc\u5fc3\u94fe\u4f24\u5bb3\u5206\u644a\u6bd4\u4f8b (\u9ed8\u8ba4: 0.5)").comment("\u4e3b\u4eba\u548c\u5973\u4ec6\u5404\u53d7\u5230\u539f\u4f24\u5bb3*\u6bd4\u4f8b\u7684\u4f24\u5bb3").comment("Double Heart Chain damage share ratio").defineInRange("doubleHeartChainShareRatio", 0.5, 0.1, 0.9);
        BUILDER.pop();
        BUILDER.comment("\u529f\u80fd\u76f8\u5173\u9970\u54c1\u914d\u7f6e").comment("Utility-related bauble configurations").push("utility");
        QUICK_CHANT_RING_COOLDOWN_REDUCTION = BUILDER.comment("\u65f6\u75d5\u4e4b\u6212\u6bcf\u7ea7\u597d\u611f\u51b7\u5374\u51cf\u5c11\u6bd4\u4f8b (\u9ed8\u8ba4: 0.25)").comment("Quick Chant Ring cooldown reduction ratio").defineInRange("quickChantRingCooldownReduction", 0.25, 0.1, 0.8);
        BUILDER.comment("");
        ROCK_CRYSTAL_KNOCKBACK_RESISTANCE = BUILDER.comment("\u78d0\u77f3\u9b54\u6676\u51fb\u9000\u6297\u6027\u52a0\u6210 (\u9ed8\u8ba4: 8)").comment("Rock Crystal knockback resistance bonus").defineInRange("rockCrystalKnockbackResistance", 8, 1, 20);
        BUILDER.comment("");
        FLOW_CORE_TICK_INTERVAL = BUILDER.comment("\u6d41\u8f6c\u6838\u5fc3\u6548\u679c\u89e6\u53d1\u95f4\u9694 (tick) (\u9ed8\u8ba4: 10)").comment("Flow Core effect trigger interval in ticks").defineInRange("flowCoreTickInterval", 10, 1, 100);
        BUILDER.comment("");
        HAIRPIN_BENEFICIAL_EFFECT_EXTENSION = BUILDER.comment("\u53d1\u7c2a\u6709\u76ca\u6548\u679c\u5ef6\u957f\u500d\u7387 (\u9ed8\u8ba4: 1.15)").comment("Hairpin beneficial effect extension multiplier").defineInRange("hairpinBeneficialEffectExtension", 1.15, 1.0, 10.0);
        BUILDER.comment("");
        HAIRPIN_MIN_EXTENSION_TICKS = BUILDER.comment("\u53d1\u7c2a\u6709\u76ca\u6548\u679c\u6700\u5c0f\u5ef6\u957f\u65f6\u95f4 (tick) (\u9ed8\u8ba4: 300)").comment("Hairpin minimum extension ticks for beneficial effects").defineInRange("hairpinMinExtensionTicks", 300, 0, 10000);
        BUILDER.comment("");
        FRAGRANT_INGENUITY_FAVORABILITY_GAIN = BUILDER.comment("\u99a5\u90c1\u5de7\u601d\u8fdb\u98df\u597d\u611f\u5ea6\u589e\u957f (\u9ed8\u8ba4: 2)").comment("Fragrant Ingenuity favorability gain when eating").defineInRange("fragrantIngenuityFavorabilityGain", 2, 1, 10);
        BUILDER.comment("");
        FRAGRANT_INGENUITY_BUFF_DURATION = BUILDER.comment("\u99a5\u90c1\u5de7\u601d\u5582\u98dfbuff\u6301\u7eed\u65f6\u95f4 (tick)").comment("Fragrant Ingenuity buff duration when maid feeds owner").defineInRange("fragrantIngenuityBuffDuration", 2400, 200, 120000);
        BUILDER.pop();
        BUILDER.comment("\u89e6\u53d1\u673a\u5236\u76f8\u5173\u9970\u54c1\u914d\u7f6e").comment("Trigger mechanism bauble configurations").push("triggers");
        SILVER_CERCIS_TRIGGER_COUNT = BUILDER.comment("\u7d2b\u8346\u94f6\u51a0\u89e6\u53d1\u6240\u9700\u653b\u51fb\u6b21\u6570 (\u9ed8\u8ba4: 3)").comment("Silver Cercis required attack count to trigger").defineInRange("silverCercisTriggerCount", 3, 1, 10);
        BUILDER.comment("");
        SILVER_CERCIS_COOLDOWN_TICKS = BUILDER.comment("\u7d2b\u8346\u94f6\u51a0\u89e6\u53d1\u540e\u51b7\u5374\u65f6\u95f4 (tick) (\u9ed8\u8ba4: 5)").comment("Silver Cercis cooldown ticks after trigger").defineInRange("silverCercisCooldownTicks", 5, 1, 100);
        BUILDER.comment("");
        WOUND_RIME_BLADE_RECORD_DURATION = BUILDER.comment("\u7834\u6108\u5492\u950b\u6bcf\u6b21\u653b\u51fb\u589e\u52a0\u7981\u7597\u6b21\u6570 (\u9ed8\u8ba4: 15)").comment("Wound Rime Blade record duration").defineInRange("woundRimeBladeRecordDuration", 15, 5, 100);
        BUILDER.pop();
        BUILDER.comment("\u7279\u6b8a\u9970\u54c1\u914d\u7f6e").comment("Special bauble configurations").push("special");
        CHAOS_BOOK_TRUE_DAMAGE_MIN = BUILDER.comment("\u6df7\u6c8c\u4e4b\u4e66\u771f\u5b9e\u4f24\u5bb3\u6700\u5c0f\u503c (\u9ed8\u8ba4: 5.0)").comment("Chaos Book minimum true damage").defineInRange("chaosBookTrueDamageMin", 5.0, 1.0, 50.0);
        BUILDER.comment("");
        CHAOS_BOOK_TRUE_DAMAGE_PERCENT = BUILDER.comment("\u6df7\u6c8c\u4e4b\u4e66\u771f\u5b9e\u4f24\u5bb3\u767e\u5206\u6bd4 (\u9ed8\u8ba4: 0.01)").comment("Chaos Book true damage percentage of max health").defineInRange("chaosBookTrueDamagePercent", 0.01, 0.001, 0.1);
        BUILDER.comment("");
        CHAOS_BOOK_DAMAGE_SPLIT_COUNT = BUILDER.comment("\u6df7\u6c8c\u4e4b\u4e66\u4f24\u5bb3\u5206\u5272\u6b21\u6570 (\u9ed8\u8ba4: 5)").comment("Chaos Book damage split count").defineInRange("chaosBookDamageSplitCount", 5, 1, 20);
        BUILDER.comment("");
        CHAOS_BOOK_MIN_SPLIT_DAMAGE = BUILDER.comment("\u6df7\u6c8c\u4e4b\u4e66\u6bcf\u6b21\u5206\u5272\u4f24\u5bb3\u6700\u5c0f\u503c (\u9ed8\u8ba4: 3.0)").comment("Chaos Book minimum damage per split").defineInRange("chaosBookMinSplitDamage", 3.0, 0.1, 100.0);
        BUILDER.comment("");
        SOUL_BOOK_DAMAGE_THRESHOLD_PERCENT = BUILDER.comment("\u9b42\u4e4b\u4e66\u4f24\u5bb3\u9608\u503c\u767e\u5206\u6bd4 (\u9ed8\u8ba4: 0.2)").comment("Soul Book damage threshold percentage of max health").defineInRange("soulBookDamageThresholdPercent", 0.2, 0.05, 1.0);
        BUILDER.comment("");
        SOUL_BOOK_DAMAGE_INTERVAL_THRESHOLD = BUILDER.comment("\u9b42\u4e4b\u4e66\u4f24\u5bb3\u95f4\u9694\u9608\u503c (tick) (\u9ed8\u8ba4: 10)").comment("Soul Book damage interval threshold in ticks").defineInRange("soulBookDamageIntervalThreshold", 10, 1, 100);
        BUILDER.pop();
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

