/*
 * Decompiled with CFR 0.152.
 */
package com.chiyukiruon.maid_mana_source.util;

import com.hollingsworth.arsnouveau.api.source.ISourceTile;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class TargetUtil {
    public static boolean isBlockFromMod(BlockState state, String modid) {
        if (modid == null || modid.isEmpty()) {
            return false;
        }
        Block block = state.m_60734_();
        ResourceLocation registryName = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (registryName != null) {
            return registryName.m_135827_().equals(modid);
        }
        return false;
    }

    public static boolean isTargetInList(BlockPos pos, ListTag list) {
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag entry = list.m_128728_(i);
            int x = entry.m_128451_("x");
            int y = entry.m_128451_("y");
            int z = entry.m_128451_("z");
            if (x != pos.m_123341_() || y != pos.m_123342_() || z != pos.m_123343_()) continue;
            return true;
        }
        return false;
    }

    public static boolean isTargetISourceTile(ServerLevel level, BlockPos pos) {
        try {
            BlockEntity blockEntity = level.m_7702_(pos);
            return blockEntity instanceof ISourceTile;
        }
        catch (Exception e) {
            System.err.println("isTargetISourceTile error at " + pos + ": " + e);
            return false;
        }
    }

    public static boolean canTargetCharge(ServerLevel level, BlockPos pos) {
        try {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof ISourceTile) {
                ISourceTile tile = (ISourceTile)blockEntity;
                return tile.canAcceptSource();
            }
        }
        catch (Exception e) {
            System.err.println("canCharge error at " + pos + ": " + e);
        }
        return false;
    }

    public static int getChargeAmount(ServerLevel level, List<BlockPos> sourceJarPos) {
        int amount = 0;
        for (BlockPos pos : sourceJarPos) {
            if (!TargetUtil.canTargetCharge(level, pos)) continue;
            ++amount;
        }
        return amount;
    }
}

