/*
 * Decompiled with CFR 0.152.
 */
package com.chiyukiruon.maid_mana_source.network;

import com.chiyukiruon.maid_mana_source.item.ItemSourceList;
import com.chiyukiruon.maid_mana_source.registry.ItemRegistry;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public record SortSourcePacket(BlockPos pos, int direction) {
    public SortSourcePacket(FriendlyByteBuf buf) {
        this(buf.m_130135_(), buf.readInt());
    }

    public static void toBytes(SortSourcePacket msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.pos);
        buf.writeInt(msg.direction);
    }

    public static void handle(SortSourcePacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            ItemStack held = player.m_21205_();
            if (!held.m_150930_((Item)ItemRegistry.SOURCE_LIST.get()) && !(held = player.m_21206_()).m_150930_((Item)ItemRegistry.SOURCE_LIST.get())) {
                return;
            }
            CompoundTag tag = held.m_41784_();
            if (!tag.m_128441_("SourceList")) {
                return;
            }
            ListTag list = tag.m_128437_("SourceList", 10);
            ItemSourceList.moveEntry(list, msg.pos(), msg.direction());
            tag.m_128365_("SourceList", (Tag)list);
            held.m_41751_(tag);
        });
        ctx.get().setPacketHandled(true);
    }
}

