/*
 * Decompiled with CFR 0.152.
 */
package com.chiyukiruon.maid_mana_source.network;

import com.chiyukiruon.maid_mana_source.data.IConfigSetter;
import com.chiyukiruon.maid_mana_source.data.MaidConfigKeys;
import com.chiyukiruon.maid_mana_source.network.Network;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class MaidConfigurePacket {
    public final int maidId;
    public final String name;
    public final String value;
    public final ResourceLocation key;

    public MaidConfigurePacket(int maidId, ResourceLocation key, String name, String value) {
        this.maidId = maidId;
        this.key = key;
        this.name = name;
        this.value = value;
    }

    public MaidConfigurePacket(FriendlyByteBuf buffer) {
        this.maidId = buffer.readInt();
        this.key = ResourceLocation.m_135820_((String)buffer.m_130277_());
        this.name = buffer.m_130277_();
        this.value = buffer.m_130277_();
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.writeInt(this.maidId);
        buffer.m_130070_(this.key.toString());
        buffer.m_130070_(this.name);
        buffer.m_130070_(this.value);
    }

    public static void handle(MaidConfigurePacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        EntityMaid entityMaid;
        Object t;
        Entity entity;
        NetworkEvent.Context context = contextSupplier.get();
        @Nullable ServerPlayer sender = context.getSender();
        if (sender != null && (entity = sender.m_9236_().m_6815_(msg.maidId)) instanceof EntityMaid && (t = MaidConfigKeys.getValue(entityMaid = (EntityMaid)entity, msg.key)) instanceof IConfigSetter) {
            IConfigSetter ics = (IConfigSetter)t;
            ics.setConfigValue(msg.name, msg.value);
        }
    }

    public static void send(EntityMaid maid, ResourceLocation key, String name, String value) {
        Network.INSTANCE.sendToServer((Object)new MaidConfigurePacket(maid.m_19879_(), key, name, value));
    }
}

