/*
 * Decompiled with CFR 0.152.
 */
package com.chiyukiruon.maid_mana_source.memory;

import com.chiyukiruon.maid_mana_source.registry.MemoryModuleRegistry;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import org.jetbrains.annotations.NotNull;

public class ScannedSourceListMemory {
    private final List<BlockPos> scannedSourceList;
    public static final Codec<ScannedSourceListMemory> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.f_121852_.listOf().fieldOf("scanned_source_list").forGetter(ScannedSourceListMemory::getJars)).apply((Applicative)instance, ScannedSourceListMemory::new));

    public ScannedSourceListMemory(List<BlockPos> sourceJars) {
        this.scannedSourceList = new ArrayList<BlockPos>(sourceJars);
    }

    public List<BlockPos> getJars() {
        return this.scannedSourceList;
    }

    public boolean isEmpty() {
        return this.scannedSourceList.isEmpty();
    }

    public static ScannedSourceListMemory getMemory(EntityMaid maid) {
        if (MemoryModuleRegistry.SCANNED_SOURCE_LIST.isPresent()) {
            return maid.m_6274_().m_21952_((MemoryModuleType)MemoryModuleRegistry.SCANNED_SOURCE_LIST.get()).orElse(null);
        }
        return null;
    }

    public static void setMemory(EntityMaid maid, List<BlockPos> jars) {
        MemoryModuleRegistry.SCANNED_SOURCE_LIST.ifPresent(module -> maid.m_6274_().m_21879_(module, (Object)new ScannedSourceListMemory(jars)));
    }

    @NotNull
    public static ListTag initializeSourceListNBT(EntityMaid maid) {
        ScannedSourceListMemory scanned = ScannedSourceListMemory.getMemory(maid);
        if (scanned != null) {
            ArrayList<BlockPos> scannedJars = new ArrayList<BlockPos>(scanned.getJars());
            ListTag listTag = new ListTag();
            for (BlockPos pos : scannedJars) {
                CompoundTag entry = new CompoundTag();
                entry.m_128405_("x", pos.m_123341_());
                entry.m_128405_("y", pos.m_123342_());
                entry.m_128405_("z", pos.m_123343_());
                entry.m_128379_("enabled", true);
                listTag.add((Object)entry);
            }
            return listTag;
        }
        return new ListTag();
    }
}

