/*
 * Decompiled with CFR 0.152.
 */
package com.chiyukiruon.maid_mana_source.item;

import com.chiyukiruon.maid_mana_source.memory.ScannedSourceListMemory;
import com.chiyukiruon.maid_mana_source.registry.ItemRegistry;
import com.chiyukiruon.maid_mana_source.task.MaidManaSourceTask;
import com.chiyukiruon.maid_mana_source.util.TargetUtil;
import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.BaubleItemHandler;
import com.github.tartaricacid.touhoulittlemaid.item.AbstractStoreMaidItem;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ItemSourceList
extends AbstractStoreMaidItem
implements IMaidBauble {
    public ItemSourceList() {
        super(new Item.Properties().m_41487_(1));
    }

    public static ItemStack getSourceList(@NotNull EntityMaid maid) {
        BaubleItemHandler handler = maid.getMaidBauble();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (!stack.m_150930_((Item)ItemRegistry.SOURCE_LIST.get())) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public void onTick(@NotNull EntityMaid maid, @NotNull ItemStack stack) {
        CompoundTag maidTag;
        if (maid.m_9236_().m_5776_()) {
            return;
        }
        if (!maid.getTask().getUid().equals((Object)MaidManaSourceTask.UID)) {
            return;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        if (!tag.m_128403_("BoundMaid")) {
            maidTag = new CompoundTag();
            this.bindMaid(maid, tag, maidTag);
        }
        if (!tag.m_128342_("BoundMaid").equals(maid.m_20148_())) {
            return;
        }
        if (!tag.m_128461_("BoundMaidName").equals(maid.m_7755_().getString())) {
            maidTag = new CompoundTag();
            maid.m_20240_(maidTag);
            maidTag.m_128359_("id", Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)((EntityType)InitEntities.MAID.get()))).toString());
            tag.m_128365_("MaidInfo", (Tag)maidTag);
            tag.m_128359_("BoundMaidName", maid.m_7755_().getString());
        }
    }

    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity target, @NotNull InteractionHand hand) {
        if (target instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)target;
            if (!player.m_9236_().f_46443_) {
                CompoundTag tag = stack.m_41784_();
                CompoundTag maidTag = new CompoundTag();
                if (tag.m_128403_("BoundMaid")) {
                    if (!tag.m_128342_("BoundMaid").equals(maid.m_20148_())) {
                        player.m_5661_((Component)Component.m_237110_((String)"tooltip.maid_mana_source.source_list.already_bound", (Object[])new Object[]{tag.m_128461_("BoundMaidName")}), true);
                        return InteractionResult.CONSUME;
                    }
                    return InteractionResult.PASS;
                }
                this.bindMaid(maid, tag, maidTag);
                player.m_5661_((Component)Component.m_237110_((String)"tooltip.maid_mana_source.source_list.bind_success", (Object[])new Object[]{maid.m_7755_()}), true);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6880_(stack, player, target, hand);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        if (!level.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack stack = player.m_21120_(hand);
            CompoundTag tag = stack.m_41784_();
            if (serverPlayer.m_6144_()) {
                BlockHitResult hitResult = (BlockHitResult)player.m_19907_(player.getEntityReach(), 0.0f, false);
                if (hitResult.m_6662_() == HitResult.Type.BLOCK && TargetUtil.isTargetInList(hitResult.m_82425_(), tag.m_128437_("SourceList", 10))) {
                    return InteractionResultHolder.m_19090_((Object)stack);
                }
                if (tag.m_128403_("BoundMaid")) {
                    serverPlayer.m_5661_((Component)Component.m_237110_((String)"tooltip.maid_mana_source.source_list.unbind_success", (Object[])new Object[]{tag.m_128461_("BoundMaidName")}), true);
                    tag.m_128473_("MaidInfo");
                    tag.m_128473_("BoundMaidName");
                    tag.m_128473_("BoundMaid");
                    tag.m_128473_("SourceList");
                    return InteractionResultHolder.m_19090_((Object)stack);
                }
                serverPlayer.m_5661_((Component)Component.m_237115_((String)"tooltip.maid_mana_source.source_list.not_bound"), true);
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }

    @NotNull
    public InteractionResult m_6225_(@NotNull UseOnContext context) {
        if (context.m_43725_().f_46443_) {
            return InteractionResult.PASS;
        }
        if (context.m_43723_() instanceof ServerPlayer) {
            ItemStack stack = context.m_43722_();
            CompoundTag tag = stack.m_41784_();
            if (stack.m_150930_((Item)ItemRegistry.SOURCE_LIST.get()) && tag.m_128403_("BoundMaid")) {
                BlockPos pos = context.m_8083_();
                ItemSourceList.updateSourceList(stack, pos);
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.add((Component)Component.m_237115_((String)"tooltip.maid_mana_source.source_list.desc").m_130940_(ChatFormatting.GRAY));
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128403_("BoundMaid")) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.maid_mana_source.source_list.bind_success", (Object[])new Object[]{tag.m_128461_("BoundMaidName")}).m_130940_(ChatFormatting.ITALIC));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.maid_mana_source.source_list.not_bound").m_130940_(ChatFormatting.ITALIC));
        }
    }

    private void bindMaid(@NotNull EntityMaid maid, @NotNull CompoundTag tag, CompoundTag maidTag) {
        maid.m_20240_(maidTag);
        maidTag.m_128359_("id", Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)((EntityType)InitEntities.MAID.get()))).toString());
        tag.m_128365_("MaidInfo", (Tag)maidTag);
        tag.m_128359_("BoundMaidName", maid.m_7755_().getString());
        tag.m_128362_("BoundMaid", maid.m_20148_());
        tag.m_128365_("SourceList", (Tag)ScannedSourceListMemory.initializeSourceListNBT(maid));
    }

    private static void updateSourceList(@NotNull ItemStack stack, BlockPos pos) {
        CompoundTag tag = stack.m_41784_();
        ListTag list = tag.m_128437_("SourceList", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag entry = list.m_128728_(i);
            int x = entry.m_128451_("x");
            int y = entry.m_128451_("y");
            int z = entry.m_128451_("z");
            if (x != pos.m_123341_() || y != pos.m_123342_() || z != pos.m_123343_()) continue;
            boolean oldEnabled = entry.m_128471_("enabled");
            entry.m_128379_("enabled", !oldEnabled);
            list.set(i, (Tag)entry);
            tag.m_128365_("SourceList", (Tag)list);
            stack.m_41751_(tag);
            break;
        }
    }

    public static void moveEntry(ListTag list, BlockPos pos, int direction) {
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag entry = list.m_128728_(i);
            if (entry.m_128451_("x") != pos.m_123341_() || entry.m_128451_("y") != pos.m_123342_() || entry.m_128451_("z") != pos.m_123343_()) continue;
            int newIndex = i + direction;
            if (newIndex < 0 || newIndex >= list.size()) {
                return;
            }
            list.remove(i);
            list.add(newIndex, (Tag)entry);
            return;
        }
    }
}

