/*
 * Decompiled with CFR 0.152.
 */
package com.chiyukiruon.maid_mana_source.client.render;

import com.chiyukiruon.maid_mana_source.Config;
import com.chiyukiruon.maid_mana_source.client.render.OutlineNoDepthRenderType;
import com.chiyukiruon.maid_mana_source.mixin.LevelRendererAccessor;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.event.RenderLevelStageEvent;

public class RenderHelper {
    public static boolean highlightPenetration = Config.enableHighlightPenetration;
    public static boolean numbersOnly = Config.numbersOnly;
    public static double listOverlayYOffset = Config.listOverlayYOffset;

    public static void renderIndexLabel(RenderLevelStageEvent event, BlockPos pos, int index, boolean enabled) {
        Minecraft mc = Minecraft.m_91087_();
        PoseStack poseStack = event.getPoseStack();
        Vec3 cameraPos = event.getCamera().m_90583_();
        Vec3 targetWorldPos = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + listOverlayYOffset, (double)pos.m_123343_() + 0.5);
        Vec3 renderPos = targetWorldPos.m_82546_(cameraPos);
        poseStack.m_85836_();
        poseStack.m_85837_(renderPos.f_82479_, renderPos.f_82480_, renderPos.f_82481_);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-event.getCamera().m_90590_()));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(event.getCamera().m_90589_()));
        float scale = -0.025f;
        poseStack.m_85841_(scale, scale, scale);
        MutableComponent text = Component.m_237110_((String)"overlay.maid_mana_source.source_list_number", (Object[])new Object[]{String.valueOf(index)});
        if (numbersOnly) {
            text = Component.m_130674_((String)String.valueOf(index));
        }
        float xOffset = (float)(-mc.f_91062_.m_92852_((FormattedText)text)) / 2.0f;
        int color = enabled ? -1 : -65536;
        MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
        mc.f_91062_.m_272077_((Component)text, xOffset, 0.0f, color, false, poseStack.m_85850_().m_252922_(), (MultiBufferSource)bufferSource, highlightPenetration ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, 0, 0xF000F0);
        bufferSource.m_109911_();
        poseStack.m_85849_();
    }

    public static void renderBlockOutline(PoseStack poseStack, Camera camera, BlockPos pos, int color) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        if (level == null) {
            return;
        }
        VoxelShape shape = level.m_8055_(pos).m_60808_((BlockGetter)level, pos);
        if (shape.m_83281_()) {
            return;
        }
        double camX = camera.m_90583_().f_82479_;
        double camY = camera.m_90583_().f_82480_;
        double camZ = camera.m_90583_().f_82481_;
        poseStack.m_85836_();
        poseStack.m_85837_((double)pos.m_123341_() - camX, (double)pos.m_123342_() - camY, (double)pos.m_123343_() - camZ);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        VertexConsumer buffer = mc.m_91269_().m_110104_().m_6299_((RenderType)(highlightPenetration ? OutlineNoDepthRenderType.getOutlineNoDepth() : RenderType.f_110371_));
        LevelRendererAccessor.callRenderShape(poseStack, buffer, shape, 0.0, 0.0, 0.0, r, g, b, a);
        poseStack.m_85849_();
    }
}

