/*
 * Decompiled with CFR 0.152.
 */
package com.chiyukiruon.maid_mana_source.behavior;

import com.chiyukiruon.maid_mana_source.Config;
import com.chiyukiruon.maid_mana_source.memory.ChargeSourceListMemory;
import com.chiyukiruon.maid_mana_source.util.I18nUtil;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.hollingsworth.arsnouveau.api.source.ISourceTile;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.behavior.Behavior;
import org.jetbrains.annotations.NotNull;

public class TaskSoundBehavior
extends Behavior<EntityMaid> {
    private boolean wasWorking = false;
    private long chatBubbleKey = 0L;

    public TaskSoundBehavior() {
        super(Map.of());
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull EntityMaid maid) {
        return Config.maidTaskSound;
    }

    protected void start(@NotNull ServerLevel level, @NotNull EntityMaid maid, long gameTime) {
        List jars = Optional.ofNullable(ChargeSourceListMemory.getMemory(maid)).map(ChargeSourceListMemory::getJars).orElse(List.of());
        boolean isWorking = jars.stream().map(arg_0 -> ((ServerLevel)level).m_7702_(arg_0)).filter(e -> e instanceof ISourceTile).map(e -> (ISourceTile)e).anyMatch(ISourceTile::canAcceptSource);
        if (!this.wasWorking && isWorking) {
            maid.getChatBubbleManager().removeChatBubble(this.chatBubbleKey);
            this.chatBubbleKey = maid.getChatBubbleManager().addTextChatBubble(I18nUtil.getRandomLangKey("chat_bubbles.maid_mana_source.working", 3));
            maid.m_5496_((SoundEvent)InitSounds.MAID_FIND_TARGET.get(), 1.0f, 1.0f);
        } else if (this.wasWorking && !isWorking) {
            maid.getChatBubbleManager().removeChatBubble(this.chatBubbleKey);
            this.chatBubbleKey = maid.getChatBubbleManager().addTextChatBubble(I18nUtil.getRandomLangKey("chat_bubbles.maid_mana_source.idle", 3));
            maid.m_5496_((SoundEvent)InitSounds.MAID_IDLE.get(), 1.0f, 1.0f);
        }
        this.wasWorking = isWorking;
    }
}

