/*
 * Decompiled with CFR 0.152.
 */
package com.chiyukiruon.maid_mana_source.behavior;

import com.chiyukiruon.maid_mana_source.advancement.AdvancementTypes;
import com.chiyukiruon.maid_mana_source.entry.SortedSourceJarEntry;
import com.chiyukiruon.maid_mana_source.item.ItemSourceList;
import com.chiyukiruon.maid_mana_source.memory.ChargeSourceListMemory;
import com.chiyukiruon.maid_mana_source.memory.ScannedSourceListMemory;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SortBehavior
extends Behavior<EntityMaid> {
    public SortBehavior() {
        super(Map.of());
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull EntityMaid maid) {
        ItemStack sourceListItem = ItemSourceList.getSourceList(maid);
        CompoundTag tag = sourceListItem.m_41784_();
        if (sourceListItem.m_41619_()) {
            return false;
        }
        if (!tag.m_128403_("BoundMaid")) {
            return false;
        }
        return ChargeSourceListMemory.getMemory(maid) != null;
    }

    protected void start(@NotNull ServerLevel level, @NotNull EntityMaid maid, long gameTime) {
        ScannedSourceListMemory scanned = ScannedSourceListMemory.getMemory(maid);
        if (scanned == null) {
            return;
        }
        ArrayList<BlockPos> scannedJars = new ArrayList<BlockPos>(scanned.getJars());
        ItemStack sourceListItem = ItemSourceList.getSourceList(maid);
        CompoundTag tag = sourceListItem.m_41784_();
        ListTag listTag = tag.m_128437_("SourceList", 10);
        ArrayList<SortedSourceJarEntry> stored = new ArrayList<SortedSourceJarEntry>();
        int disabledCount = 0;
        for (Tag entryTag : listTag) {
            CompoundTag entry = (CompoundTag)entryTag;
            BlockPos blockPos = new BlockPos(entry.m_128451_("x"), entry.m_128451_("y"), entry.m_128451_("z"));
            boolean enabled = entry.m_128471_("enabled");
            if (!enabled) {
                ++disabledCount;
            }
            stored.add(new SortedSourceJarEntry(blockPos, enabled));
        }
        if (disabledCount == listTag.size()) {
            AdvancementTypes.triggerForMaid(maid, "disable_all_source");
        }
        HashSet<BlockPos> scannedSet = new HashSet<BlockPos>(scannedJars);
        HashSet<BlockPos> storedSet = new HashSet<BlockPos>();
        for (SortedSourceJarEntry sortedSourceJarEntry : stored) {
            storedSet.add(sortedSourceJarEntry.getPos());
        }
        for (BlockPos blockPos : scannedSet) {
            if (storedSet.contains(blockPos)) continue;
            stored.add(new SortedSourceJarEntry(blockPos, true));
        }
        stored.removeIf(e -> !scannedSet.contains(e.getPos()));
        ArrayList<BlockPos> finalList = new ArrayList<BlockPos>();
        for (SortedSourceJarEntry e3 : stored) {
            if (!e3.isEnabled()) continue;
            finalList.add(e3.getPos());
        }
        ListTag listTag2 = new ListTag();
        for (SortedSourceJarEntry e4 : stored) {
            CompoundTag entry = new CompoundTag();
            entry.m_128405_("x", e4.getPos().m_123341_());
            entry.m_128405_("y", e4.getPos().m_123342_());
            entry.m_128405_("z", e4.getPos().m_123343_());
            entry.m_128379_("enabled", e4.isEnabled());
            listTag2.add((Object)entry);
        }
        tag.m_128365_("SourceList", (Tag)listTag2);
        ChargeSourceListMemory.setMemory(maid, finalList);
    }
}

