/*
 * Decompiled with CFR 0.152.
 */
package com.chiyukiruon.maid_mana_source.behavior;

import com.chiyukiruon.maid_mana_source.Config;
import com.chiyukiruon.maid_mana_source.advancement.AdvancementTypes;
import com.chiyukiruon.maid_mana_source.memory.ChargeSourceListMemory;
import com.chiyukiruon.maid_mana_source.memory.ScannedSourceListMemory;
import com.chiyukiruon.maid_mana_source.util.TargetUtil;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.Behavior;
import org.jetbrains.annotations.NotNull;

public class ScanBehavior
extends Behavior<EntityMaid> {
    public ScanBehavior() {
        super(Map.of());
    }

    protected boolean checkExtraStartConditions(ServerLevel level, @NotNull EntityMaid maid) {
        AdvancementTypes.triggerForMaid(maid, "mana_source");
        int scanInterval = maid.isHomeModeEnable() ? Config.scanInterval : Math.max(1, Config.scanInterval / 2);
        return level.m_46467_() % (long)scanInterval == 0L;
    }

    protected void start(@NotNull ServerLevel level, EntityMaid maid, long gameTime) {
        BlockPos center = maid.isHomeModeEnable() ? maid.m_21534_() : maid.m_20183_();
        int radius = (int)maid.m_21535_();
        int radiusSq = radius * radius;
        List<BlockPos> nearbyJars = BlockPos.m_121990_((BlockPos)center.m_7918_(-radius, 0, -radius), (BlockPos)center.m_7918_(radius, radius, radius)).map(BlockPos::m_7949_).filter(pos -> pos.m_123342_() >= center.m_123342_() && pos.m_123331_((Vec3i)center) <= (double)radiusSq && TargetUtil.isTargetISourceTile(level, pos)).toList();
        ChargeSourceListMemory.setMemory(maid, nearbyJars);
        ScannedSourceListMemory.setMemory(maid, nearbyJars);
    }
}

