/*
 * Decompiled with CFR 0.152.
 */
package com.chiyukiruon.maid_mana_source.behavior;

import com.chiyukiruon.maid_mana_source.Config;
import com.chiyukiruon.maid_mana_source.advancement.AdvancementTypes;
import com.chiyukiruon.maid_mana_source.data.MaidChargeConfig;
import com.chiyukiruon.maid_mana_source.memory.ChargeSourceListMemory;
import com.chiyukiruon.maid_mana_source.registry.MemoryModuleRegistry;
import com.chiyukiruon.maid_mana_source.util.MaidAiUtil;
import com.chiyukiruon.maid_mana_source.util.TargetUtil;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.hollingsworth.arsnouveau.api.source.ISourceTile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;

public class ChargeBehavior
extends Behavior<EntityMaid> {
    private static final Map<Integer, Long> COOLDOWNS = new HashMap<Integer, Long>();

    public ChargeBehavior() {
        super(Map.of());
    }

    protected boolean checkExtraStartConditions(ServerLevel level, EntityMaid maid) {
        return COOLDOWNS.getOrDefault(maid.m_19879_(), 0L) < level.m_46467_();
    }

    protected void start(@NotNull ServerLevel level, @NotNull EntityMaid maid, long gameTime) {
        List<BlockPos> knownJars = Optional.ofNullable(ChargeSourceListMemory.getMemory(maid)).map(ChargeSourceListMemory::getJars).orElse(List.of()).stream().toList();
        if (knownJars.isEmpty()) {
            return;
        }
        long currentTime = level.m_46467_();
        MaidChargeConfig.Data config = (MaidChargeConfig.Data)maid.getOrCreateData(MaidChargeConfig.KEY, (Object)MaidChargeConfig.Data.getDefault());
        boolean chargeMode = config.chargeMode();
        boolean chargeStrategy = config.chargeStrategy();
        int chargeThisTime = Config.maxPerCharge;
        int chargeAmount = TargetUtil.getChargeAmount(level, knownJars);
        int coolingTime = Config.coolingTime;
        if (Config.enableFavorEffect) {
            int maidFavorLevel = maid.getFavorabilityManager().getLevel();
            chargeThisTime += maidFavorLevel * Config.favorChargeBonus;
            coolingTime -= maidFavorLevel * Config.favorCooldownReduction;
            chargeThisTime = Math.max(chargeThisTime, 0);
            coolingTime = Math.max(coolingTime, 0);
        }
        if (!chargeMode && knownJars.size() > 1 && chargeAmount != 0) {
            chargeThisTime /= chargeAmount;
            for (BlockPos pos : knownJars) {
                ISourceTile jar = (ISourceTile)level.m_7702_(pos);
                if (jar == null || !jar.canAcceptSource()) continue;
                MaidAiUtil.setWalkAndLookTargetMemories(maid, pos, 0.5);
                this.doCharge(maid, level, pos, chargeThisTime);
            }
            COOLDOWNS.put(maid.m_19879_(), currentTime + (long)coolingTime);
            return;
        }
        if (chargeStrategy) {
            int index = maid.m_6274_().m_21952_((MemoryModuleType)MemoryModuleRegistry.CHARGE_INDEX.get()).orElse(0);
            BlockPos pos = knownJars.get(index % knownJars.size());
            ISourceTile jar = (ISourceTile)level.m_7702_(pos);
            if (jar == null) {
                maid.m_6274_().m_21879_((MemoryModuleType)MemoryModuleRegistry.CHARGE_INDEX.get(), (Object)((index + 1) % knownJars.size()));
                return;
            }
            if (jar.canAcceptSource()) {
                MaidAiUtil.setWalkAndLookTargetMemories(maid, pos, 0.5);
                this.doCharge(maid, level, pos, chargeThisTime);
                COOLDOWNS.put(maid.m_19879_(), currentTime + (long)coolingTime);
            }
            maid.m_6274_().m_21879_((MemoryModuleType)MemoryModuleRegistry.CHARGE_INDEX.get(), (Object)((index + 1) % knownJars.size()));
        } else {
            for (BlockPos pos : knownJars) {
                ISourceTile jar = (ISourceTile)level.m_7702_(pos);
                if (jar == null || !jar.canAcceptSource()) continue;
                MaidAiUtil.setWalkAndLookTargetMemories(maid, pos, 0.5);
                this.doCharge(maid, level, pos, chargeThisTime);
                COOLDOWNS.put(maid.m_19879_(), currentTime + (long)coolingTime);
                break;
            }
        }
    }

    private void doCharge(EntityMaid maid, @NotNull ServerLevel level, BlockPos pos, int charge) {
        BlockEntity block = level.m_7702_(pos);
        BlockState state = level.m_8055_(pos);
        if (block instanceof ISourceTile) {
            ISourceTile sourceTile = (ISourceTile)block;
            if (!sourceTile.canAcceptSource()) {
                return;
            }
            sourceTile.addSource(charge);
            level.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, Config.chargeParticleCount, Config.chargeParticleRadius, Config.chargeParticleRadius, Config.chargeParticleRadius, 0.01);
            if (ModList.get().isLoaded("botania") && ModList.get().isLoaded("ars_botania") && TargetUtil.isBlockFromMod(state, "botania")) {
                AdvancementTypes.triggerForMaid(maid, "charge_mana_pool");
            }
            AdvancementTypes.triggerForMaid(maid, "maid_charge");
            if (!sourceTile.canAcceptSource() && Config.chargingCompletedSound) {
                level.m_5594_(null, pos, SoundEvents.f_11871_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }
}

