/*
 * Decompiled with CFR 0.152.
 */
package com.chiyukiruon.maid_mana_source;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="maid_mana_source", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.IntValue COOLING_TIME = BUILDER.comment("The base cooldown time (in ticks) after each mana charging action").defineInRange("coolingTime", 200, 0, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.IntValue MAX_PER_CHARGE = BUILDER.comment("The base maximum mana amount added to source jar per charge").defineInRange("maxPerCharge", 200, 0, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.IntValue SCAN_INTERVAL = BUILDER.comment("Interval between source jar searches (in ticks)").defineInRange("scanInterval", 200, 1, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.BooleanValue ENABLE_FAVOR_EFFECT = BUILDER.comment("If true, maid's favorability affects charging amount and cooldown").define("enableFavorEffect", false);
    private static final ForgeConfigSpec.IntValue FAVOR_CHARGE_BONUS = BUILDER.comment("Extra mana per levels (only effective if enableFavorEffect = true)").defineInRange("favorChargeBonus", 100, Integer.MIN_VALUE, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.IntValue FAVOR_COOLDOWN_REDUCTION = BUILDER.comment("Cooldown reduction (in ticks) per levels (only effective if enableFavorEffect = true)").defineInRange("favorCooldownReduction", 20, Integer.MIN_VALUE, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.BooleanValue ENABLE_HIGHLIGHT_PENETRATION = BUILDER.comment("If true, highlights will show through the blocks").define("enableHighlightPenetration", true);
    private static final ForgeConfigSpec.DoubleValue LIST_OVERLAY_TEXT_Y_OFFSET = BUILDER.comment("The Y offset of the charging number display").defineInRange("chargeParticleInterval", 1.3, Double.MIN_VALUE, Double.MAX_VALUE);
    private static final ForgeConfigSpec.BooleanValue NUMBERS_ONLY = BUILDER.comment("If true, only numbers will be displayed").define("numbersOnly", false);
    private static final ForgeConfigSpec.IntValue CHARGE_PARTICLE_COUNT = BUILDER.comment("The number of particles to be displayed when charging").defineInRange("chargeParticleCount", 20, 0, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.DoubleValue CHARGE_PARTICLE_RADIUS = BUILDER.comment("The radius of the particles to be displayed when charging").defineInRange("chargeParticleRadius", 0.5, 0.0, Double.MAX_VALUE);
    private static final ForgeConfigSpec.BooleanValue MAID_TASK_SOUND = BUILDER.comment("If true, maid will play sound when starting and ending tasks").define("maidTaskSound", true);
    private static final ForgeConfigSpec.BooleanValue CHARGING_COMPLETED_SOUND = BUILDER.comment("If true, a sound will be played when the Source Jar is fully charged.").define("chargingCompletedSound", true);
    static final ForgeConfigSpec SPEC = BUILDER.build();
    public static int coolingTime;
    public static int maxPerCharge;
    public static int scanInterval;
    public static boolean enableFavorEffect;
    public static int favorChargeBonus;
    public static int favorCooldownReduction;
    public static boolean enableHighlightPenetration;
    public static double listOverlayYOffset;
    public static boolean numbersOnly;
    public static int chargeParticleCount;
    public static double chargeParticleRadius;
    public static boolean maidTaskSound;
    public static boolean chargingCompletedSound;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        coolingTime = (Integer)COOLING_TIME.get();
        maxPerCharge = (Integer)MAX_PER_CHARGE.get();
        scanInterval = (Integer)SCAN_INTERVAL.get();
        enableFavorEffect = (Boolean)ENABLE_FAVOR_EFFECT.get();
        favorChargeBonus = (Integer)FAVOR_CHARGE_BONUS.get();
        favorCooldownReduction = (Integer)FAVOR_COOLDOWN_REDUCTION.get();
        enableHighlightPenetration = (Boolean)ENABLE_HIGHLIGHT_PENETRATION.get();
        listOverlayYOffset = (Double)LIST_OVERLAY_TEXT_Y_OFFSET.get();
        numbersOnly = (Boolean)NUMBERS_ONLY.get();
        chargeParticleCount = (Integer)CHARGE_PARTICLE_COUNT.get();
        chargeParticleRadius = (Double)CHARGE_PARTICLE_RADIUS.get();
        maidTaskSound = (Boolean)MAID_TASK_SOUND.get();
        chargingCompletedSound = (Boolean)CHARGING_COMPLETED_SOUND.get();
    }
}

