/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.subcommands;

import appeng.core.AELog;
import appeng.core.definitions.AEItems;
import appeng.core.localization.PlayerMessages;
import appeng.items.tools.powered.ColorApplicatorItem;
import appeng.server.ISubCommand;
import appeng.server.testplots.KitOutPlayerEvent;
import appeng.server.testplots.TestPlots;
import appeng.server.testworld.TestWorldGenerator;
import com.google.common.base.Stopwatch;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import org.jetbrains.annotations.Nullable;

public class SetupTestWorldCommand
implements ISubCommand {
    @Override
    public void addArguments(LiteralArgumentBuilder<CommandSourceStack> builder) {
        for (ResourceLocation plotId : TestPlots.getPlotIds()) {
            builder.then(Commands.m_82127_((String)plotId.toString()).executes(ctx -> {
                this.setupTestWorld(((CommandSourceStack)ctx.getSource()).m_81377_(), (CommandSourceStack)ctx.getSource(), plotId);
                return 1;
            }));
        }
    }

    @Override
    public void call(MinecraftServer srv, CommandContext<CommandSourceStack> ctx, CommandSourceStack sender) {
        this.setupTestWorld(srv, sender, null);
    }

    private void setupTestWorld(MinecraftServer srv, CommandSourceStack sender, @Nullable ResourceLocation plotId) {
        Stopwatch sw = Stopwatch.createStarted();
        try {
            ServerPlayer player = sender.m_81375_();
            if (!player.m_7500_()) {
                sender.m_81352_((Component)PlayerMessages.TestWorldNotInCreativeMode.text());
                return;
            }
            ServerLevel level = player.m_284548_();
            if (!SetupTestWorldCommand.isSuperflatWorld(level)) {
                sender.m_81352_((Component)PlayerMessages.TestWorldNotInSuperflat.text());
                return;
            }
            SetupTestWorldCommand.changeGameRules(srv);
            this.removeAllEntitiesButPlayer(srv);
            BlockPos origin = player.m_20183_();
            if (origin.m_123342_() - 3 < level.m_141937_()) {
                origin = origin.m_175288_(level.m_141937_() + 3);
            }
            TestWorldGenerator generator = new TestWorldGenerator(level, player, origin, plotId);
            generator.generate();
            player.m_150110_().f_35935_ = true;
            player.m_6885_();
            this.kitOutPlayer(player);
            if (!generator.isWithinBounds(player.m_20183_())) {
                BlockPos goodStartPos = generator.getSuitableStartPos();
                player.m_8999_(level, (double)goodStartPos.m_123341_(), (double)goodStartPos.m_123342_(), (double)goodStartPos.m_123343_(), 0.0f, 0.0f);
            }
            sender.m_288197_(() -> PlayerMessages.TestWorldSetupComplete.text(sw), true);
        }
        catch (CommandSyntaxException | RuntimeException e) {
            AELog.error(e);
            sender.m_81352_((Component)PlayerMessages.TestWorldSetupFailed.text(e));
        }
    }

    private void removeAllEntitiesButPlayer(MinecraftServer srv) {
        for (ServerLevel level : srv.m_129785_()) {
            ArrayList entities = new ArrayList();
            level.m_260813_(EntityTypeTest.m_156916_(Entity.class), e -> true, entities);
            for (Entity entity : entities) {
                if (entity instanceof Player) continue;
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    private void kitOutPlayer(ServerPlayer player) {
        Inventory playerInv = player.m_150109_();
        ItemStack fullApplicator = ColorApplicatorItem.createFullColorApplicator();
        if (!playerInv.m_18949_(Collections.singleton(AEItems.COLOR_APPLICATOR.m_5456_()))) {
            playerInv.m_150079_(fullApplicator);
        }
        KitOutPlayerEvent.EVENT.invoker().accept(player);
    }

    private static void changeGameRules(MinecraftServer srv) {
        SetupTestWorldCommand.makeAlwaysDaytime(srv);
        SetupTestWorldCommand.disableWeather(srv);
        SetupTestWorldCommand.disableMobSpawning(srv);
    }

    private static void makeAlwaysDaytime(MinecraftServer srv) {
        ((GameRules.BooleanValue)srv.m_129900_().m_46170_(GameRules.f_46140_)).m_46246_(false, srv);
        srv.m_129783_().m_8615_(1000L);
    }

    private static void disableWeather(MinecraftServer srv) {
        ((GameRules.BooleanValue)srv.m_129900_().m_46170_(GameRules.f_46150_)).m_46246_(false, srv);
        srv.m_129783_().m_8606_(9999, 0, false, false);
    }

    private static void disableMobSpawning(MinecraftServer srv) {
        ((GameRules.BooleanValue)srv.m_129900_().m_46170_(GameRules.f_46134_)).m_46246_(false, srv);
    }

    private static boolean isSuperflatWorld(ServerLevel level) {
        ChunkGenerator generator = level.m_7726_().m_8481_();
        return generator instanceof FlatLevelSource;
    }
}

