/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity;

import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridHelper;
import appeng.api.orientation.BlockOrientation;
import appeng.api.orientation.IOrientationStrategy;
import appeng.api.orientation.RelativeSide;
import appeng.block.AEBaseEntityBlock;
import appeng.client.render.model.AEModelData;
import appeng.core.AELog;
import appeng.hooks.VisualStateSaving;
import appeng.hooks.ticking.TickHandler;
import appeng.items.tools.MemoryCardItem;
import appeng.util.CustomNameUtil;
import appeng.util.SettingsFrom;
import appeng.util.helpers.ItemComparisonHelper;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Clearable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.Nullable;

public class AEBaseBlockEntity
extends BlockEntity
implements Nameable,
ISegmentedInventory,
Clearable {
    private static final Map<BlockEntityType<?>, Item> REPRESENTATIVE_ITEMS = new HashMap();
    @Nullable
    private Component customName;
    private boolean setChangedQueued = false;
    private byte queuedForReady = 0;
    private byte readyInvoked = 0;
    @Nullable
    private BlockOrientation pendingOrientationChange;

    public AEBaseBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
    }

    public static void registerBlockEntityItem(BlockEntityType<?> type, Item wat) {
        REPRESENTATIVE_ITEMS.put(type, wat);
    }

    public boolean notLoaded() {
        return !this.f_58857_.m_46805_(this.f_58858_);
    }

    public final GlobalPos getGlobalPos() {
        if (this.f_58857_ == null) {
            throw new IllegalStateException("Block entity is not in a level");
        }
        return GlobalPos.m_122643_((ResourceKey)this.f_58857_.m_46472_(), (BlockPos)this.m_58899_());
    }

    public BlockEntity getBlockEntity() {
        return this;
    }

    protected Item getItemFromBlockEntity() {
        return REPRESENTATIVE_ITEMS.getOrDefault(this.m_58903_(), Items.f_41852_);
    }

    public final void m_142466_(CompoundTag tag) {
        if (tag.m_128425_("#upd", 7) && tag.m_128440_() == 1) {
            byte[] updateData = tag.m_128463_("#upd");
            if (this.readUpdateData(new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])updateData))) && this.f_58857_ != null) {
                this.requestModelDataUpdate();
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 0);
            }
            return;
        }
        if (tag.m_128425_("visual", 10)) {
            this.loadVisualState(tag.m_128469_("visual"));
        }
        super.m_142466_(tag);
        this.loadTag(tag);
    }

    public void loadTag(CompoundTag data) {
        this.customName = data.m_128441_("customName") ? Component.m_237113_((String)data.m_128461_("customName")) : null;
        if (data.m_128425_("forward", 8) && data.m_128425_("up", 8)) {
            try {
                Direction forward = Direction.valueOf((String)data.m_128461_("forward").toUpperCase(Locale.ROOT));
                Direction up = Direction.valueOf((String)data.m_128461_("up").toUpperCase(Locale.ROOT));
                this.pendingOrientationChange = BlockOrientation.get(forward, up);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void m_183515_(CompoundTag data) {
        if (VisualStateSaving.isEnabled(this.f_58857_)) {
            CompoundTag visualTag = new CompoundTag();
            this.saveVisualState(visualTag);
            data.m_128365_("visual", (Tag)visualTag);
        }
        super.m_183515_(data);
        if (this.customName != null) {
            data.m_128359_("customName", this.customName.getString());
        }
    }

    @MustBeInvokedByOverriders
    public void onReady() {
        this.readyInvoked = (byte)(this.readyInvoked + 1);
        if (this.pendingOrientationChange != null) {
            BlockState state = this.m_58900_();
            this.f_58857_.m_46597_(this.m_58899_(), IOrientationStrategy.get(state).setOrientation(state, this.pendingOrientationChange.getSide(RelativeSide.FRONT), this.pendingOrientationChange.getSpin()));
            this.pendingOrientationChange = null;
        }
    }

    protected void scheduleInit() {
        this.queuedForReady = (byte)(this.queuedForReady + 1);
        GridHelper.onFirstTick(this, AEBaseBlockEntity::onReady);
    }

    public CompoundTag m_5995_() {
        CompoundTag data = new CompoundTag();
        FriendlyByteBuf stream = new FriendlyByteBuf(Unpooled.buffer());
        this.writeToStream(stream);
        stream.capacity(stream.readableBytes());
        data.m_128382_("#upd", stream.array());
        return data;
    }

    private boolean readUpdateData(FriendlyByteBuf stream) {
        boolean output = false;
        try {
            output = this.readFromStream(stream);
        }
        catch (Throwable t) {
            AELog.warn(t);
        }
        return output;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    protected boolean readFromStream(FriendlyByteBuf data) {
        return false;
    }

    protected void writeToStream(FriendlyByteBuf data) {
    }

    @MustBeInvokedByOverriders
    protected void saveVisualState(CompoundTag data) {
    }

    @MustBeInvokedByOverriders
    protected void loadVisualState(CompoundTag data) {
    }

    public void markForUpdate() {
        this.requestModelDataUpdate();
        if (this.f_58857_ != null && !this.m_58901_() && !this.notLoaded()) {
            AEBaseEntityBlock block;
            BlockState newState;
            boolean alreadyUpdated = false;
            BlockState currentState = this.m_58900_();
            Block block2 = currentState.m_60734_();
            if (block2 instanceof AEBaseEntityBlock && currentState != (newState = (block = (AEBaseEntityBlock)block2).getBlockEntityBlockState(currentState, this))) {
                AELog.blockUpdate(this.f_58858_, currentState, newState, this);
                this.f_58857_.m_46597_(this.f_58858_, newState);
                alreadyUpdated = true;
            }
            if (!alreadyUpdated) {
                this.f_58857_.m_7260_(this.f_58858_, currentState, currentState, 1);
            }
        }
    }

    public final BlockOrientation getOrientation() {
        return BlockOrientation.get(this.m_58900_());
    }

    public Direction getFront() {
        return this.getOrientation().getSide(RelativeSide.FRONT);
    }

    public Direction getTop() {
        return this.getOrientation().getSide(RelativeSide.TOP);
    }

    @ApiStatus.OverrideOnly
    protected void onOrientationChanged(BlockOrientation orientation) {
    }

    @MustBeInvokedByOverriders
    public void exportSettings(SettingsFrom mode, CompoundTag output, @Nullable Player player) {
        CustomNameUtil.setCustomName(output, this.customName);
        if (mode == SettingsFrom.MEMORY_CARD) {
            MemoryCardItem.exportGenericSettings(this, output);
        }
    }

    @MustBeInvokedByOverriders
    public void importSettings(SettingsFrom mode, CompoundTag input, @Nullable Player player) {
        Component customName = CustomNameUtil.getCustomName(input);
        this.customName = customName != null ? Component.m_237113_((String)customName.getString()) : null;
        MemoryCardItem.importGenericSettings(this, input, player);
    }

    @MustBeInvokedByOverriders
    public void addAdditionalDrops(Level level, BlockPos pos, List<ItemStack> drops) {
    }

    @MustBeInvokedByOverriders
    public void m_6211_() {
    }

    public Component m_7755_() {
        return Objects.requireNonNullElse(this.customName, this.getItemFromBlockEntity().m_41466_());
    }

    @Nullable
    public Component m_7770_() {
        return this.customName;
    }

    public boolean isClientSide() {
        Level level = this.m_58904_();
        return level == null || level.m_5776_();
    }

    public void saveChanges() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            this.m_6596_();
        } else {
            this.f_58857_.m_151543_(this.f_58858_);
            if (!this.setChangedQueued) {
                TickHandler.instance().addCallable(null, this::setChangedAtEndOfTick);
                this.setChangedQueued = true;
            }
        }
    }

    private Object setChangedAtEndOfTick(Level level) {
        this.m_6596_();
        this.setChangedQueued = false;
        return null;
    }

    public void setName(String name) {
        this.customName = Component.m_237113_((String)name);
    }

    @Override
    @Nullable
    @MustBeInvokedByOverriders
    public InternalInventory getSubInventory(ResourceLocation id) {
        return null;
    }

    public ModelData getModelData() {
        return AEModelData.create();
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_, this.f_58858_.m_7918_(1, 1, 1));
    }

    public InteractionResult disassembleWithWrench(Player player, Level level, BlockHitResult hitResult, ItemStack wrench) {
        BlockPos pos = hitResult.m_82425_();
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            List drops = Block.m_49874_((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)this, (Entity)player, (ItemStack)wrench);
            ItemStack op = new ItemStack((ItemLike)state.m_60734_());
            for (ItemStack ol : drops) {
                if (!ItemComparisonHelper.isEqualItemType(ol, op)) continue;
                CompoundTag tag = new CompoundTag();
                this.exportSettings(SettingsFrom.DISMANTLE_ITEM, tag, player);
                if (tag.m_128456_()) break;
                ol.m_41751_(tag);
                break;
            }
            this.addAdditionalDrops(level, pos, drops);
            this.m_6211_();
            for (ItemStack item : drops) {
                player.m_150109_().m_150079_(item);
            }
        }
        block.m_5707_(level, pos, state, player);
        level.m_7471_(pos, false);
        block.m_6786_((LevelAccessor)level, pos, this.m_58900_());
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    public byte getQueuedForReady() {
        return this.queuedForReady;
    }

    public byte getReadyInvoked() {
        return this.readyInvoked;
    }

    public void m_155250_(BlockState state) {
        BlockOrientation previousOrientation = BlockOrientation.get(this.m_58900_());
        super.m_155250_(state);
        BlockOrientation newOrientation = BlockOrientation.get(this.m_58900_());
        if (previousOrientation != newOrientation) {
            this.onOrientationChanged(newOrientation);
        }
    }
}

