/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.common.item;

import java.util.List;
import mekanism.additions.common.AdditionsLang;
import mekanism.additions.common.config.MekanismAdditionsConfig;
import mekanism.api.text.EnumColor;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ItemWalkieTalkie
extends Item
implements IModeItem {
    public ItemWalkieTalkie(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public void m_7373_(@NotNull ItemStack stack, Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add(BooleanStateDisplay.OnOff.of((boolean)this.getOn(stack), (boolean)true).getTextComponent());
        tooltip.add((Component)AdditionsLang.CHANNEL.translateColored(EnumColor.DARK_AQUA, new Object[]{EnumColor.GRAY, this.getChannel(stack)}));
        if (!MekanismAdditionsConfig.additions.voiceServerEnabled.get()) {
            tooltip.add((Component)AdditionsLang.WALKIE_DISABLED.translateColored(EnumColor.DARK_RED, new Object[0]));
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (player.m_6144_()) {
            this.setOn(itemStack, !this.getOn(itemStack));
            return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)world.f_46443_);
        }
        return InteractionResultHolder.m_19098_((Object)itemStack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, @NotNull ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.m_41720_() != newStack.m_41720_();
    }

    public void setOn(ItemStack itemStack, boolean on) {
        ItemDataUtils.setBoolean((ItemStack)itemStack, (String)"running", (boolean)on);
    }

    public boolean getOn(ItemStack itemStack) {
        return ItemDataUtils.getBoolean((ItemStack)itemStack, (String)"running");
    }

    public void setChannel(ItemStack itemStack, int channel) {
        ItemDataUtils.setInt((ItemStack)itemStack, (String)"channel", (int)channel);
    }

    public int getChannel(ItemStack itemStack) {
        int channel = ItemDataUtils.getInt((ItemStack)itemStack, (String)"channel");
        if (channel == 0) {
            this.setChannel(itemStack, 1);
            channel = 1;
        }
        return channel;
    }

    public void changeMode(@NotNull Player player, @NotNull ItemStack stack, int shift, IModeItem.DisplayChange displayChange) {
        int newChannel;
        int channel;
        if (this.getOn(stack) && (channel = this.getChannel(stack)) != (newChannel = Math.floorMod(channel + shift - 1, 8) + 1)) {
            this.setChannel(stack, newChannel);
            displayChange.sendMessage(player, () -> AdditionsLang.CHANNEL_CHANGE.translate(new Object[]{newChannel}));
        }
    }

    @NotNull
    public Component getScrollTextComponent(@NotNull ItemStack stack) {
        return AdditionsLang.CHANNEL.translateColored(EnumColor.GRAY, new Object[]{EnumColor.WHITE, this.getChannel(stack)});
    }
}

