/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers;

import cofh.core.client.event.CoreClientEvents;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.vfx.Color;
import cofh.lib.util.helpers.MathHelper;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL11;

public final class RenderHelper {
    public static final float RENDER_OFFSET = 0.001953125f;
    public static final int FULL_BRIGHT = 0xF000F0;
    public static final ResourceLocation MC_BLOCK_SHEET = new ResourceLocation("textures/atlas/blocks.png");
    public static final ResourceLocation MC_FONT_DEFAULT = new ResourceLocation("textures/font/ascii.png");
    public static final ResourceLocation MC_FONT_SGA = new ResourceLocation("textures/font/ascii_sga.png");
    public static final ResourceLocation MC_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    public static PoseStack particleStack = new PoseStack();
    private static int vertexColorIndex;

    private RenderHelper() {
    }

    public static MultiBufferSource.BufferSource bufferSource() {
        return Minecraft.m_91087_().m_91269_().m_110104_();
    }

    public static TextureManager engine() {
        return Minecraft.m_91087_().m_91097_();
    }

    public static TextureAtlas textureMap() {
        return Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_);
    }

    public static Tesselator tesselator() {
        return Tesselator.m_85913_();
    }

    public static ItemRenderer renderItem() {
        return Minecraft.m_91087_().m_91291_();
    }

    public static BlockRenderDispatcher renderBlock() {
        return Minecraft.m_91087_().m_91289_();
    }

    public static EntityRenderDispatcher renderEntity() {
        return Minecraft.m_91087_().m_91290_();
    }

    public static ModelPart bakeLayer(ModelLayerLocation location) {
        return Minecraft.m_91087_().m_167973_().m_171103_(location);
    }

    public static int renderTime() {
        return CoreClientEvents.renderTime;
    }

    public static float partialTick() {
        return Minecraft.m_91087_().getPartialTick();
    }

    public static float frameDelta() {
        return Minecraft.m_91087_().m_91297_();
    }

    public static boolean isFabulousGraphics() {
        return ((GraphicsStatus)Minecraft.m_91087_().f_91066_.m_232060_().m_231551_()).m_35965_() >= GraphicsStatus.FABULOUS.m_35965_();
    }

    public static void setBlockTextureSheet() {
        RenderHelper.setShaderTexture0(MC_BLOCK_SHEET);
    }

    public static void setDefaultFontTextureSheet() {
        RenderHelper.setShaderTexture0(MC_FONT_DEFAULT);
    }

    public static void setSGAFontTextureSheet() {
        RenderHelper.setShaderTexture0(MC_FONT_SGA);
    }

    public static void drawFluid(int x, int y, FluidStack fluid, int width, int height) {
        if (fluid.isEmpty()) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int color = FluidHelper.color(fluid);
        RenderHelper.setPosTexShader();
        RenderHelper.setBlockTextureSheet();
        RenderHelper.setShaderColorFromInt(color);
        RenderHelper.drawTiledTexture(x, y, RenderHelper.getTexture(IClientFluidTypeExtensions.of((Fluid)fluid.getFluid()).getStillTexture(fluid)), width, height);
    }

    public static void drawIcon(TextureAtlasSprite icon, double z) {
        BufferBuilder buffer = RenderHelper.tesselator().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_5483_(0.0, 16.0, z).m_7421_(icon.m_118409_(), icon.m_118412_());
        buffer.m_5483_(16.0, 16.0, z).m_7421_(icon.m_118410_(), icon.m_118412_());
        buffer.m_5483_(16.0, 0.0, z).m_7421_(icon.m_118410_(), icon.m_118411_());
        buffer.m_5483_(0.0, 0.0, z).m_7421_(icon.m_118409_(), icon.m_118411_());
        RenderHelper.tesselator().m_85914_();
    }

    public static void drawIcon(double x, double y, double z, TextureAtlasSprite icon, int width, int height) {
        BufferBuilder buffer = RenderHelper.tesselator().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_5483_(x, y + (double)height, z).m_7421_(icon.m_118409_(), icon.m_118412_());
        buffer.m_5483_(x + (double)width, y + (double)height, z).m_7421_(icon.m_118410_(), icon.m_118412_());
        buffer.m_5483_(x + (double)width, y, z).m_7421_(icon.m_118410_(), icon.m_118411_());
        buffer.m_5483_(x, y, z).m_7421_(icon.m_118409_(), icon.m_118411_());
        RenderHelper.tesselator().m_85914_();
    }

    public static void drawTiledTexture(int x, int y, TextureAtlasSprite icon, int width, int height) {
        for (int i = 0; i < width; i += 16) {
            for (int j = 0; j < height; j += 16) {
                int drawWidth = Math.min(width - i, 16);
                int drawHeight = Math.min(height - j, 16);
                RenderHelper.drawScaledTexturedModalRectFromSprite(x + i, y + j, icon, drawWidth, drawHeight);
            }
        }
        RenderHelper.resetShaderColor();
    }

    public static void drawScaledTexturedModalRectFromSprite(int x, int y, TextureAtlasSprite icon, int width, int height) {
        if (icon == null) {
            return;
        }
        float minU = icon.m_118409_();
        float maxU = icon.m_118410_();
        float minV = icon.m_118411_();
        float maxV = icon.m_118412_();
        float u = minU + (maxU - minU) * (float)width / 16.0f;
        float v = minV + (maxV - minV) * (float)height / 16.0f;
        BufferBuilder buffer = RenderHelper.tesselator().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_5483_((double)x, (double)(y + height), 0.0).m_7421_(minU, v).m_5752_();
        buffer.m_5483_((double)(x + width), (double)(y + height), 0.0).m_7421_(u, v).m_5752_();
        buffer.m_5483_((double)(x + width), (double)y, 0.0).m_7421_(u, minV).m_5752_();
        buffer.m_5483_((double)x, (double)y, 0.0).m_7421_(minU, minV).m_5752_();
        RenderHelper.tesselator().m_85914_();
    }

    public static void drawFluid(GuiGraphics pGuiGraphics, int x, int y, FluidStack fluid, int width, int height) {
        if (fluid.isEmpty()) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        int color = FluidHelper.color(fluid);
        RenderHelper.setPosTexShader();
        RenderHelper.setBlockTextureSheet();
        RenderHelper.setShaderColorFromInt(color);
        RenderHelper.drawTiledTexture(pGuiGraphics, x, y, RenderHelper.getTexture(IClientFluidTypeExtensions.of((Fluid)fluid.getFluid()).getStillTexture(fluid)), width, height);
    }

    public static void drawIcon(GuiGraphics pGuiGraphics, TextureAtlasSprite icon, float z) {
        Matrix4f matrix = pGuiGraphics.m_280168_().m_85850_().m_252922_();
        BufferBuilder buffer = RenderHelper.tesselator().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_252986_(matrix, 0.0f, 16.0f, z).m_7421_(icon.m_118409_(), icon.m_118412_());
        buffer.m_252986_(matrix, 16.0f, 16.0f, z).m_7421_(icon.m_118410_(), icon.m_118412_());
        buffer.m_252986_(matrix, 16.0f, 0.0f, z).m_7421_(icon.m_118410_(), icon.m_118411_());
        buffer.m_252986_(matrix, 0.0f, 0.0f, z).m_7421_(icon.m_118409_(), icon.m_118411_());
        RenderHelper.tesselator().m_85914_();
    }

    public static void drawIcon(GuiGraphics pGuiGraphics, float x, float y, float z, TextureAtlasSprite icon, int width, int height) {
        Matrix4f matrix = pGuiGraphics.m_280168_().m_85850_().m_252922_();
        BufferBuilder buffer = RenderHelper.tesselator().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_252986_(matrix, x, y + (float)height, z).m_7421_(icon.m_118409_(), icon.m_118412_());
        buffer.m_252986_(matrix, x + (float)width, y + (float)height, z).m_7421_(icon.m_118410_(), icon.m_118412_());
        buffer.m_252986_(matrix, x + (float)width, y, z).m_7421_(icon.m_118410_(), icon.m_118411_());
        buffer.m_252986_(matrix, x, y, z).m_7421_(icon.m_118409_(), icon.m_118411_());
        RenderHelper.tesselator().m_85914_();
    }

    public static void drawTiledTexture(GuiGraphics pGuiGraphics, int x, int y, TextureAtlasSprite icon, int width, int height) {
        for (int i = 0; i < width; i += 16) {
            for (int j = 0; j < height; j += 16) {
                int drawWidth = Math.min(width - i, 16);
                int drawHeight = Math.min(height - j, 16);
                RenderHelper.drawScaledTexturedModalRectFromSprite(pGuiGraphics, x + i, y + j, icon, drawWidth, drawHeight);
            }
        }
        RenderHelper.resetShaderColor();
    }

    public static void drawScaledTexturedModalRectFromSprite(GuiGraphics pGuiGraphics, int x, int y, TextureAtlasSprite icon, int width, int height) {
        if (icon == null) {
            return;
        }
        float minU = icon.m_118409_();
        float maxU = icon.m_118410_();
        float minV = icon.m_118411_();
        float maxV = icon.m_118412_();
        float u = minU + (maxU - minU) * (float)width / 16.0f;
        float v = minV + (maxV - minV) * (float)height / 16.0f;
        Matrix4f matrix = pGuiGraphics.m_280168_().m_85850_().m_252922_();
        BufferBuilder buffer = RenderHelper.tesselator().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_252986_(matrix, (float)x, (float)(y + height), 0.0f).m_7421_(minU, v).m_5752_();
        buffer.m_252986_(matrix, (float)(x + width), (float)(y + height), 0.0f).m_7421_(u, v).m_5752_();
        buffer.m_252986_(matrix, (float)(x + width), (float)y, 0.0f).m_7421_(u, minV).m_5752_();
        buffer.m_252986_(matrix, (float)x, (float)y, 0.0f).m_7421_(minU, minV).m_5752_();
        RenderHelper.tesselator().m_85914_();
    }

    public static void drawStencil(PoseStack matrixStack, int xStart, int yStart, int xEnd, int yEnd, int flag) {
        RenderSystem.setShader(GameRenderer::m_172808_);
        GL11.glStencilFunc((int)519, (int)flag, (int)flag);
        GL11.glStencilOp((int)0, (int)0, (int)7681);
        GL11.glStencilMask((int)flag);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        RenderSystem.depthMask((boolean)false);
        GL11.glClearStencil((int)0);
        RenderSystem.clear((int)1024, (boolean)false);
        Matrix4f matrix = matrixStack.m_85850_().m_252922_();
        BufferBuilder buffer = RenderHelper.tesselator().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        buffer.m_252986_(matrix, (float)xStart, (float)yEnd, 0.0f).m_5752_();
        buffer.m_252986_(matrix, (float)xEnd, (float)yEnd, 0.0f).m_5752_();
        buffer.m_252986_(matrix, (float)xEnd, (float)yStart, 0.0f).m_5752_();
        buffer.m_252986_(matrix, (float)xStart, (float)yStart, 0.0f).m_5752_();
        RenderHelper.tesselator().m_85914_();
        GL11.glStencilFunc((int)514, (int)flag, (int)flag);
        GL11.glStencilMask((int)0);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.depthMask((boolean)true);
    }

    public static TextureAtlasSprite getTexture(String location) {
        return RenderHelper.textureMap().m_118316_(new ResourceLocation(location));
    }

    public static TextureAtlasSprite getTexture(ResourceLocation location) {
        return RenderHelper.textureMap().m_118316_(location);
    }

    public static TextureAtlasSprite getFluidTexture(Fluid fluid) {
        return RenderHelper.getTexture(IClientFluidTypeExtensions.of((Fluid)fluid).getStillTexture());
    }

    public static TextureAtlasSprite getFluidTexture(FluidStack fluid) {
        return RenderHelper.getTexture(IClientFluidTypeExtensions.of((Fluid)fluid.getFluid()).getStillTexture(fluid));
    }

    public static boolean textureExists(String location) {
        return RenderHelper.textureExists(new ResourceLocation(location));
    }

    public static boolean textureExists(ResourceLocation location) {
        return RenderHelper.getTexture(location) != RenderHelper.getTexture(MissingTextureAtlasSprite.m_118071_());
    }

    public static BakedQuad mulColor(BakedQuad quad, int color) {
        VertexFormat from = DefaultVertexFormat.f_85811_;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        int[] packedData = (int[])quad.m_111303_().clone();
        float[] data = new float[4];
        for (int v = 0; v < 4; ++v) {
            RenderHelper.unpackLight(packedData, data, from, v, vertexColorIndex);
            data[0] = MathHelper.clamp(data[0] * r, 0.0f, 1.0f);
            data[1] = MathHelper.clamp(data[1] * g, 0.0f, 1.0f);
            data[2] = MathHelper.clamp(data[2] * b, 0.0f, 1.0f);
            RenderHelper.packLight(data, packedData, from, v, vertexColorIndex);
        }
        return new BakedQuad(packedData, quad.m_111305_(), quad.m_111306_(), quad.m_173410_(), quad.m_111307_());
    }

    public static void unpackLight(int[] from, float[] to, VertexFormat formatFrom, int v, int e) {
        int length = Math.min(4, to.length);
        VertexFormatElement element = (VertexFormatElement)formatFrom.m_86023_().get(e);
        int vertexStart = v * formatFrom.m_86020_() + formatFrom.getOffset(e);
        int count = element.getElementCount();
        VertexFormatElement.Type type = element.m_86041_();
        VertexFormatElement.Usage usage = element.m_86048_();
        int size = type.m_86074_();
        int mask = (256 << 8 * (size - 1)) - 1;
        for (int i = 0; i < length; ++i) {
            if (i < count) {
                int pos = vertexStart + size * i;
                int index = pos >> 2;
                int offset = pos & 3;
                int bits = from[index];
                bits >>>= offset * 8;
                if ((pos + size - 1) / 4 != index) {
                    bits |= from[index + 1] << (4 - offset) * 8;
                }
                bits &= mask;
                if (type == VertexFormatElement.Type.FLOAT) {
                    to[i] = Float.intBitsToFloat(bits);
                    continue;
                }
                if (type == VertexFormatElement.Type.UBYTE || type == VertexFormatElement.Type.USHORT) {
                    to[i] = (float)bits / (float)mask;
                    continue;
                }
                if (type == VertexFormatElement.Type.UINT) {
                    to[i] = (float)((double)((long)bits & 0xFFFFFFFFL) / 4.294967295E9);
                    continue;
                }
                if (type == VertexFormatElement.Type.BYTE) {
                    to[i] = (float)((byte)bits) / (float)(mask >> 1);
                    continue;
                }
                if (type == VertexFormatElement.Type.SHORT) {
                    to[i] = (float)((short)bits) / (float)(mask >> 1);
                    continue;
                }
                if (type != VertexFormatElement.Type.INT) continue;
                to[i] = (float)((double)((long)bits & 0xFFFFFFFFL) / 2.147483647E9);
                continue;
            }
            to[i] = i == 3 && usage == VertexFormatElement.Usage.POSITION ? 1.0f : 0.0f;
        }
    }

    public static void packLight(float[] from, int[] to, VertexFormat formatTo, int v, int e) {
        VertexFormatElement element = (VertexFormatElement)formatTo.m_86023_().get(e);
        int vertexStart = v * formatTo.m_86020_() + formatTo.getOffset(e);
        int count = element.getElementCount();
        VertexFormatElement.Type type = element.m_86041_();
        int size = type.m_86074_();
        int mask = (256 << 8 * (size - 1)) - 1;
        for (int i = 0; i < 4; ++i) {
            float f;
            if (i >= count) continue;
            int pos = vertexStart + size * i;
            int index = pos >> 2;
            int offset = pos & 3;
            int bits = 0;
            float f2 = f = i < from.length ? from[i] : 0.0f;
            bits = type == VertexFormatElement.Type.FLOAT ? Float.floatToRawIntBits(f) : (type == VertexFormatElement.Type.UBYTE || type == VertexFormatElement.Type.USHORT || type == VertexFormatElement.Type.UINT ? Math.round(f * (float)mask) : Math.round(f * (float)(mask >> 1)));
            int n = index;
            to[n] = to[n] & ~(mask << offset * 8);
            int n2 = index;
            to[n2] = to[n2] | (bits & mask) << offset * 8;
        }
    }

    public static void setShaderColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)1.0f);
    }

    public static float red(int color) {
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    public static float green(int color) {
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    public static float blue(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }

    public static void setPosTexShader() {
        RenderSystem.setShader(GameRenderer::m_172817_);
    }

    public static void resetShaderColor() {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void setShaderTexture0(ResourceLocation texture) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
    }

    public static void renderItemOnBlockSide(PoseStack poseStackIn, ItemStack stack, Direction side, BlockPos pos) {
        if (stack.m_41619_() || side.m_122434_() == Direction.Axis.Y) {
            return;
        }
        poseStackIn.m_85836_();
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        switch (side) {
            case NORTH: {
                poseStackIn.m_85837_((double)x + 0.75, (double)y + 0.84375, (double)((float)z + 0.28320312f));
                break;
            }
            case SOUTH: {
                poseStackIn.m_85837_((double)x + 0.25, (double)y + 0.84375, (double)((float)(z + 1) - 0.28320312f));
                poseStackIn.m_252781_(MathHelper.quaternion(0.0f, 180.0f, 0.0f));
                break;
            }
            case WEST: {
                poseStackIn.m_85837_((double)((float)x + 0.28320312f), (double)y + 0.84375, (double)z + 0.25);
                poseStackIn.m_252781_(MathHelper.quaternion(0.0f, 90.0f, 0.0f));
                break;
            }
            case EAST: {
                poseStackIn.m_85837_((double)((float)(x + 1) - 0.28320312f), (double)y + 0.84375, (double)z + 0.75);
                poseStackIn.m_252781_(MathHelper.quaternion(0.0f, 270.0f, 0.0f));
                break;
            }
        }
        poseStackIn.m_85841_(0.03125f, 0.03125f, -0.001953125f);
        poseStackIn.m_252781_(MathHelper.quaternion(0.0f, 0.0f, 180.0f));
        poseStackIn.m_85849_();
    }

    public static void renderCuboid(AABB aabb, PoseStack poseStack, VertexConsumer buffer, int light, float r, float g, float b, float a, TextureAtlasSprite icon) {
        Matrix4f mat4 = poseStack.m_85850_().m_252922_();
        Matrix3f mat3 = poseStack.m_85850_().m_252943_();
        float u0 = icon.m_118409_();
        float u1 = icon.m_118410_();
        float v0 = icon.m_118411_();
        float v1 = icon.m_118412_();
        buffer.m_252986_(mat4, (float)aabb.f_82288_, (float)aabb.f_82289_, (float)aabb.f_82290_).m_85950_(r, g, b, a).m_7421_(u0, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(mat3, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat4, (float)aabb.f_82291_, (float)aabb.f_82289_, (float)aabb.f_82290_).m_85950_(r, g, b, a).m_7421_(u1, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(mat3, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat4, (float)aabb.f_82291_, (float)aabb.f_82289_, (float)aabb.f_82293_).m_85950_(r, g, b, a).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(mat3, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat4, (float)aabb.f_82288_, (float)aabb.f_82289_, (float)aabb.f_82293_).m_85950_(r, g, b, a).m_7421_(u0, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(mat3, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat4, (float)aabb.f_82288_, (float)aabb.f_82292_, (float)aabb.f_82290_).m_85950_(r, g, b, a).m_7421_(u0, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(mat3, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat4, (float)aabb.f_82288_, (float)aabb.f_82292_, (float)aabb.f_82293_).m_85950_(r, g, b, a).m_7421_(u0, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(mat3, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat4, (float)aabb.f_82291_, (float)aabb.f_82292_, (float)aabb.f_82293_).m_85950_(r, g, b, a).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(mat3, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat4, (float)aabb.f_82291_, (float)aabb.f_82292_, (float)aabb.f_82290_).m_85950_(r, g, b, a).m_7421_(u1, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(mat3, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat4, (float)aabb.f_82288_, (float)aabb.f_82289_, (float)aabb.f_82290_).m_85950_(r, g, b, a).m_7421_(u0, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(mat3, 0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_252986_(mat4, (float)aabb.f_82288_, (float)aabb.f_82292_, (float)aabb.f_82290_).m_85950_(r, g, b, a).m_7421_(u0, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(mat3, 0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_252986_(mat4, (float)aabb.f_82291_, (float)aabb.f_82292_, (float)aabb.f_82290_).m_85950_(r, g, b, a).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(mat3, 0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_252986_(mat4, (float)aabb.f_82291_, (float)aabb.f_82289_, (float)aabb.f_82290_).m_85950_(r, g, b, a).m_7421_(u1, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(mat3, 0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_252986_(mat4, (float)aabb.f_82288_, (float)aabb.f_82289_, (float)aabb.f_82293_).m_85950_(r, g, b, a).m_7421_(u0, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(mat3, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(mat4, (float)aabb.f_82291_, (float)aabb.f_82289_, (float)aabb.f_82293_).m_85950_(r, g, b, a).m_7421_(u1, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(mat3, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(mat4, (float)aabb.f_82291_, (float)aabb.f_82292_, (float)aabb.f_82293_).m_85950_(r, g, b, a).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(mat3, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(mat4, (float)aabb.f_82288_, (float)aabb.f_82292_, (float)aabb.f_82293_).m_85950_(r, g, b, a).m_7421_(u0, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(mat3, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(mat4, (float)aabb.f_82288_, (float)aabb.f_82289_, (float)aabb.f_82290_).m_85950_(r, g, b, a).m_7421_(u0, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(mat3, -1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat4, (float)aabb.f_82288_, (float)aabb.f_82289_, (float)aabb.f_82293_).m_85950_(r, g, b, a).m_7421_(u0, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(mat3, -1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat4, (float)aabb.f_82288_, (float)aabb.f_82292_, (float)aabb.f_82293_).m_85950_(r, g, b, a).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(mat3, -1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat4, (float)aabb.f_82288_, (float)aabb.f_82292_, (float)aabb.f_82290_).m_85950_(r, g, b, a).m_7421_(u1, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(mat3, -1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat4, (float)aabb.f_82291_, (float)aabb.f_82289_, (float)aabb.f_82290_).m_85950_(r, g, b, a).m_7421_(u0, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(mat3, 1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat4, (float)aabb.f_82291_, (float)aabb.f_82292_, (float)aabb.f_82290_).m_85950_(r, g, b, a).m_7421_(u1, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(mat3, 1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat4, (float)aabb.f_82291_, (float)aabb.f_82292_, (float)aabb.f_82293_).m_85950_(r, g, b, a).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(mat3, 1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat4, (float)aabb.f_82291_, (float)aabb.f_82289_, (float)aabb.f_82293_).m_85950_(r, g, b, a).m_7421_(u0, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(mat3, 1.0f, 0.0f, 0.0f).m_5752_();
    }

    public static Vector4f[] getCuboidCorners(Matrix4f pose, float w, float l, float h) {
        Vector4f[] corners;
        for (Vector4f corner : corners = new Vector4f[]{new Vector4f(-w, -l, -h, 1.0f), new Vector4f(-w, -l, h, 1.0f), new Vector4f(w, -l, -h, 1.0f), new Vector4f(w, -l, h, 1.0f), new Vector4f(w, l, -h, 1.0f), new Vector4f(w, l, h, 1.0f), new Vector4f(-w, l, -h, 1.0f), new Vector4f(-w, l, h, 1.0f)}) {
            corner.mul((Matrix4fc)pose);
        }
        return corners;
    }

    public static void renderSides(VertexConsumer consumer, int light, Color color, Vector4f[] corners, Vector3f normal, float u0, float v0, float u1, float v1) {
        RenderHelper.renderFace(consumer, light, color, corners[1], corners[0], corners[2], corners[3], u0, v0, u1, v1, normal);
        RenderHelper.renderFace(consumer, light, color, corners[3], corners[2], corners[4], corners[5], u0, v0, u1, v1, normal);
        RenderHelper.renderFace(consumer, light, color, corners[5], corners[4], corners[6], corners[7], u0, v0, u1, v1, normal);
        RenderHelper.renderFace(consumer, light, color, corners[7], corners[6], corners[0], corners[1], u0, v0, u1, v1, normal);
    }

    public static void renderBottom(VertexConsumer consumer, int light, Color color, Vector4f[] corners, Vector3f normal, float u0, float v0, float u1, float v1) {
        RenderHelper.renderFace(consumer, light, color, corners[6], corners[4], corners[2], corners[0], u0, v0, u1, v1, normal);
    }

    public static void renderTop(VertexConsumer consumer, int light, Color color, Vector4f[] corners, Vector3f normal, float u0, float v0, float u1, float v1) {
        RenderHelper.renderFace(consumer, light, color, corners[1], corners[3], corners[5], corners[7], u0, v0, u1, v1, normal);
    }

    public static void renderCuboid(VertexConsumer consumer, int light, Color color, Vector4f[] corners, Vector3f normal, float u0, float v0, float u1, float v1) {
        RenderHelper.renderSides(consumer, light, color, corners, normal, u0, v0, u1, v1);
        RenderHelper.renderBottom(consumer, light, color, corners, normal, u0, v0, u1, v1);
        RenderHelper.renderTop(consumer, light, color, corners, normal, u0, v0, u1, v1);
    }

    public static void renderFace(VertexConsumer consumer, int light, Color color, Vector4f a, Vector4f b, Vector4f c, Vector4f d, float u0, float v0, float u1, float v1, Vector3f normal) {
        consumer.m_5483_((double)a.x(), (double)a.y(), (double)a.z()).m_6122_(color.r, color.g, color.b, color.a).m_7421_(u0, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(normal.x(), normal.y(), normal.z()).m_5752_();
        consumer.m_5483_((double)b.x(), (double)b.y(), (double)b.z()).m_6122_(color.r, color.g, color.b, color.a).m_7421_(u1, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(normal.x(), normal.y(), normal.z()).m_5752_();
        consumer.m_5483_((double)c.x(), (double)c.y(), (double)c.z()).m_6122_(color.r, color.g, color.b, color.a).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(normal.x(), normal.y(), normal.z()).m_5752_();
        consumer.m_5483_((double)d.x(), (double)d.y(), (double)d.z()).m_6122_(color.r, color.g, color.b, color.a).m_7421_(u0, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(normal.x(), normal.y(), normal.z()).m_5752_();
    }

    public static void renderTrigonalTrapezohedron(PoseStack stack, VertexConsumer consumer, int packedLight, Color col, float height, float radius) {
        Vector4f v2;
        Vector4f v1;
        Vector4f v0;
        int i;
        int a = col.a;
        if (a <= 0) {
            return;
        }
        int r = col.r;
        int g = col.g;
        int b = col.b;
        PoseStack.Pose last = stack.m_85850_();
        Matrix4f pose = last.m_252922_();
        Matrix3f norm = last.m_252943_();
        float h = 0.1666667f * height;
        Vector4f u = new Vector4f(0.0f, 3.0f * h, 0.0f, 1.0f).mul((Matrix4fc)pose);
        Vector4f l = new Vector4f(0.0f, -3.0f * h, 0.0f, 1.0f).mul((Matrix4fc)pose);
        Vector4f[] v = new Vector4f[8];
        for (i = 0; i < 6; ++i) {
            v[i] = new Vector4f(radius * MathHelper.sin((float)i * 1.0472f), h, radius * MathHelper.cos((float)i * 1.0472f), 1.0f).mul((Matrix4fc)pose);
            h = -h;
        }
        v[6] = v[0];
        v[7] = v[1];
        for (i = 0; i < 6; i += 2) {
            v0 = v[i];
            v1 = v[i + 1];
            v2 = v[i + 2];
            consumer.m_5483_((double)v0.x(), (double)v0.y(), (double)v0.z()).m_6122_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(norm, 0.0f, 1.0f, 0.0f).m_5752_();
            consumer.m_5483_((double)v1.x(), (double)v1.y(), (double)v1.z()).m_6122_(r, g, b, a).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(norm, 0.0f, 1.0f, 0.0f).m_5752_();
            consumer.m_5483_((double)v2.x(), (double)v2.y(), (double)v2.z()).m_6122_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(norm, 0.0f, 1.0f, 0.0f).m_5752_();
            consumer.m_5483_((double)u.x(), (double)u.y(), (double)u.z()).m_6122_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(norm, 0.0f, 1.0f, 0.0f).m_5752_();
        }
        for (i = 1; i < 7; i += 2) {
            v0 = v[i + 2];
            v1 = v[i + 1];
            v2 = v[i];
            consumer.m_5483_((double)v0.x(), (double)v0.y(), (double)v0.z()).m_6122_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(norm, 0.0f, 1.0f, 0.0f).m_5752_();
            consumer.m_5483_((double)v1.x(), (double)v1.y(), (double)v1.z()).m_6122_(r, g, b, a).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(norm, 0.0f, 1.0f, 0.0f).m_5752_();
            consumer.m_5483_((double)v2.x(), (double)v2.y(), (double)v2.z()).m_6122_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(norm, 0.0f, 1.0f, 0.0f).m_5752_();
            consumer.m_5483_((double)l.x(), (double)l.y(), (double)l.z()).m_6122_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(norm, 0.0f, 1.0f, 0.0f).m_5752_();
        }
    }

    public static void renderBipyramid(PoseStack stack, VertexConsumer consumer, int packedLight, Color col, int baseEdges, float height, float radius) {
        int i;
        int a = col.a;
        if (col.a <= 0) {
            return;
        }
        int r = col.r;
        int g = col.g;
        int b = col.b;
        PoseStack.Pose last = stack.m_85850_();
        Matrix4f pose = last.m_252922_();
        Matrix3f norm = last.m_252943_();
        Vector4f u = new Vector4f(0.0f, height * 0.5f, 0.0f, 1.0f).mul((Matrix4fc)pose);
        Vector4f l = new Vector4f(0.0f, height * -0.5f, 0.0f, 1.0f).mul((Matrix4fc)pose);
        Vector4f[] v = new Vector4f[baseEdges + 1];
        float angle = (float)Math.PI * 2 / (float)baseEdges;
        for (i = 0; i < baseEdges; ++i) {
            v[i] = new Vector4f(radius * MathHelper.sin((float)i * angle), 0.0f, radius * MathHelper.cos((float)i * angle), 1.0f).mul((Matrix4fc)pose);
        }
        v[baseEdges] = v[0];
        for (i = 0; i < baseEdges; ++i) {
            Vector4f v0 = v[i];
            Vector4f v1 = v[i + 1];
            consumer.m_5483_((double)v0.x(), (double)v0.y(), (double)v0.z()).m_6122_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(norm, 0.0f, 1.0f, 0.0f).m_5752_();
            consumer.m_5483_((double)v1.x(), (double)v1.y(), (double)v1.z()).m_6122_(r, g, b, a).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(norm, 0.0f, 1.0f, 0.0f).m_5752_();
            consumer.m_5483_((double)u.x(), (double)u.y(), (double)u.z()).m_6122_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(norm, 0.0f, 1.0f, 0.0f).m_5752_();
            consumer.m_5483_((double)u.x(), (double)u.y(), (double)u.z()).m_6122_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(norm, 0.0f, 1.0f, 0.0f).m_5752_();
            consumer.m_5483_((double)v1.x(), (double)v1.y(), (double)v1.z()).m_6122_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(norm, 0.0f, 1.0f, 0.0f).m_5752_();
            consumer.m_5483_((double)v0.x(), (double)v0.y(), (double)v0.z()).m_6122_(r, g, b, a).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(norm, 0.0f, 1.0f, 0.0f).m_5752_();
            consumer.m_5483_((double)l.x(), (double)l.y(), (double)l.z()).m_6122_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(norm, 0.0f, 1.0f, 0.0f).m_5752_();
            consumer.m_5483_((double)l.x(), (double)l.y(), (double)l.z()).m_6122_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(norm, 0.0f, 1.0f, 0.0f).m_5752_();
        }
    }

    static {
        VertexFormat from = DefaultVertexFormat.f_85811_;
        vertexColorIndex = -1;
        ImmutableList elements = from.m_86023_();
        for (int i = 0; i < from.m_86023_().size(); ++i) {
            VertexFormatElement element = (VertexFormatElement)elements.get(i);
            if (element.m_86048_() != VertexFormatElement.Usage.COLOR) continue;
            vertexColorIndex = i;
            break;
        }
    }
}

