/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.common.network.packet.server;

import cofh.core.CoFHCore;
import cofh.core.util.control.ITransferControllableTile;
import cofh.lib.common.network.packet.IPacketServer;
import cofh.lib.common.network.packet.PacketBase;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TransferControlPacket
extends PacketBase
implements IPacketServer {
    protected BlockPos pos;
    protected boolean transferIn;
    protected boolean transferOut;

    public TransferControlPacket() {
        super(35, CoFHCore.PACKET_HANDLER);
    }

    @Override
    public void handleServer(ServerPlayer player) {
        Level world = player.f_19853_;
        if (!world.m_46749_(this.pos)) {
            return;
        }
        BlockEntity tile = world.m_7702_(this.pos);
        if (tile instanceof ITransferControllableTile) {
            ITransferControllableTile transferControllableTile = (ITransferControllableTile)tile;
            transferControllableTile.setControl(this.transferIn, this.transferOut);
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeBoolean(this.transferIn);
        buf.writeBoolean(this.transferOut);
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.transferIn = buf.readBoolean();
        this.transferOut = buf.readBoolean();
    }

    public static void sendToServer(ITransferControllableTile tile) {
        TransferControlPacket packet = new TransferControlPacket();
        packet.pos = tile.pos();
        packet.transferIn = tile.transferControl().getTransferIn();
        packet.transferOut = tile.transferControl().getTransferOut();
        packet.sendToServer();
    }
}

