/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.ingredient;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.converter.JSONConverter;
import com.blamejared.crafttweaker.api.tag.type.KnownTag;
import com.blamejared.crafttweaker.api.util.Many;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import com.google.gson.JsonElement;
import java.util.List;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.providers.IChemicalProvider;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.integration.crafttweaker.ingredient.CrTIngredientHelper;
import net.minecraft.tags.TagKey;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@NativeTypeRegistration(value=ChemicalStackIngredient.SlurryStackIngredient.class, zenCodeName="mods.mekanism.api.ingredient.ChemicalStackIngredient.SlurryStackIngredient")
public class CrTSlurryStackIngredient {
    private CrTSlurryStackIngredient() {
    }

    @ZenCodeType.StaticExpansionMethod
    public static ChemicalStackIngredient.SlurryStackIngredient from(Slurry instance, long amount) {
        CrTIngredientHelper.assertValid(instance, amount, "SlurryStackIngredients", "slurry");
        return IngredientCreatorAccess.slurry().from((IChemicalProvider<Slurry>)instance, amount);
    }

    @ZenCodeType.StaticExpansionMethod
    public static ChemicalStackIngredient.SlurryStackIngredient from(ICrTChemicalStack.ICrTSlurryStack instance) {
        CrTIngredientHelper.assertValid(instance, "SlurryStackIngredients");
        return IngredientCreatorAccess.slurry().from((SlurryStack)instance.getImmutableInternal());
    }

    @ZenCodeType.StaticExpansionMethod
    public static ChemicalStackIngredient.SlurryStackIngredient from(KnownTag<Slurry> slurryTag, long amount) {
        TagKey<Slurry> tag = CrTIngredientHelper.assertValidAndGet(slurryTag, amount, "SlurryStackIngredients");
        return IngredientCreatorAccess.slurry().from(tag, amount);
    }

    @ZenCodeType.StaticExpansionMethod
    public static ChemicalStackIngredient.SlurryStackIngredient from(Many<KnownTag<Slurry>> slurryTag) {
        return CrTSlurryStackIngredient.from((KnownTag<Slurry>)((KnownTag)slurryTag.getData()), (long)slurryTag.getAmount());
    }

    @ZenCodeType.StaticExpansionMethod
    public static ChemicalStackIngredient.SlurryStackIngredient createMulti(ChemicalStackIngredient.SlurryStackIngredient ... ingredients) {
        return (ChemicalStackIngredient.SlurryStackIngredient)CrTIngredientHelper.createMulti((String)"SlurryStackIngredients", IngredientCreatorAccess.slurry(), (InputIngredient[])ingredients);
    }

    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    public static IData asIData(ChemicalStackIngredient.SlurryStackIngredient _this) {
        return JSONConverter.convert((JsonElement)_this.serialize());
    }

    @ZenCodeType.Method
    public static boolean testType(ChemicalStackIngredient.SlurryStackIngredient _this, ICrTChemicalStack.ICrTSlurryStack type) {
        return _this.testType((SlurryStack)type.getInternal());
    }

    @ZenCodeType.Method
    public static boolean test(ChemicalStackIngredient.SlurryStackIngredient _this, ICrTChemicalStack.ICrTSlurryStack stack) {
        return _this.test((SlurryStack)stack.getInternal());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="representations")
    public static List<ICrTChemicalStack.ICrTSlurryStack> getRepresentations(ChemicalStackIngredient.SlurryStackIngredient _this) {
        return CrTUtils.convertSlurry(_this.getRepresentations());
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.OR)
    public static ChemicalStackIngredient.SlurryStackIngredient or(ChemicalStackIngredient.SlurryStackIngredient _this, ChemicalStackIngredient.SlurryStackIngredient other) {
        return (ChemicalStackIngredient.SlurryStackIngredient)IngredientCreatorAccess.slurry().createMulti(new ChemicalStackIngredient.SlurryStackIngredient[]{_this, other});
    }
}

