/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.util;

import java.util.LinkedList;
import java.util.List;
import java.util.function.BooleanSupplier;

public final class CycleTaskHelper {
    private static final List<CycleTaskTicker> CYCLE_TASKS = new LinkedList<CycleTaskTicker>();
    private static final List<CycleTaskTicker> TEMP_CYCLE_TASKS = new LinkedList<CycleTaskTicker>();

    public static void addCycleTask(BooleanSupplier task, long periodMs, int cycles) {
        CycleTaskTicker ticker = new CycleTaskTicker(task, periodMs, cycles);
        if (ticker.tick()) {
            CYCLE_TASKS.add(ticker);
        }
    }

    public static void addCycleTask(BooleanSupplier task, long delayMs, long periodMs, int cycles) {
        if (delayMs <= 0L) {
            CycleTaskHelper.addCycleTask(task, periodMs, cycles);
            return;
        }
        CycleTaskTicker ticker = new CycleTaskTicker(task, delayMs, periodMs, cycles);
        CYCLE_TASKS.add(ticker);
    }

    public static void tick() {
        TEMP_CYCLE_TASKS.addAll(CYCLE_TASKS);
        CYCLE_TASKS.clear();
        TEMP_CYCLE_TASKS.removeIf(ticker -> !ticker.tick());
        CYCLE_TASKS.addAll(TEMP_CYCLE_TASKS);
        TEMP_CYCLE_TASKS.clear();
    }

    private static class CycleTaskTicker {
        private final BooleanSupplier task;
        private final float periodS;
        private final int cycles;
        private float delayS = 0.0f;
        private long timestamp = -1L;
        private float compensation = 0.0f;
        private int count = 0;

        private CycleTaskTicker(BooleanSupplier task, long periodMs, int cycles) {
            this.task = task;
            this.periodS = (float)periodMs / 1000.0f;
            this.cycles = cycles;
        }

        private CycleTaskTicker(BooleanSupplier task, long delayMs, long periodMs, int cycles) {
            this.delayS = (float)delayMs / 1000.0f;
            this.timestamp = System.currentTimeMillis();
            this.task = task;
            this.periodS = (float)periodMs / 1000.0f;
            this.cycles = cycles;
        }

        private boolean tick() {
            if (this.timestamp == -1L) {
                this.timestamp = System.currentTimeMillis();
                if (this.cycles > 0 && ++this.count > this.cycles) {
                    return false;
                }
                return this.task.getAsBoolean();
            }
            float duration = (float)(System.currentTimeMillis() - this.timestamp) / 1000.0f + this.compensation;
            if (this.delayS > 0.0f) {
                if (this.delayS > duration) {
                    this.delayS -= duration;
                    return true;
                }
                this.delayS = 0.0f;
                duration = duration - this.delayS + this.periodS;
            }
            if (duration > this.periodS) {
                this.compensation = duration;
                this.timestamp = System.currentTimeMillis();
                while (this.compensation > this.periodS) {
                    if (this.cycles > 0 && ++this.count > this.cycles) {
                        return false;
                    }
                    if (!this.task.getAsBoolean()) {
                        return false;
                    }
                    this.compensation -= this.periodS;
                }
            }
            return true;
        }
    }
}

