/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.charm;

import it.hurts.sskirillss.relics.entities.SporeEntity;
import it.hurts.sskirillss.relics.init.EntityRegistry;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.SlotContext;

public class SporeSackItem
extends RelicItem {
    private static final String TAG_SPORES = "spores";

    @Override
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder("spore").maxLevel(10).stat(StatData.builder("size").initialValue(0.1, 0.5).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.15).formatValue(value -> MathUtils.round(value, 2)).build()).stat(StatData.builder("damage").initialValue(0.25, 0.5).upgradeModifier(UpgradeOperation.MULTIPLY_TOTAL, 0.1).formatValue(value -> MathUtils.round(value, 2)).build()).stat(StatData.builder("cooldown").initialValue(15.0, 10.0).upgradeModifier(UpgradeOperation.MULTIPLY_TOTAL, -0.1).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatData.builder("duration").initialValue(2.0, 4.0).upgradeModifier(UpgradeOperation.MULTIPLY_TOTAL, 0.2).formatValue(value -> MathUtils.round(value, 1)).build()).build()).ability(AbilityData.builder("buffer").requiredLevel(5).maxLevel(10).stat(StatData.builder("capacity").initialValue(2.0, 5.0).upgradeModifier(UpgradeOperation.ADD, 1.0).formatValue(value -> (int)MathUtils.round(value, 0)).build()).stat(StatData.builder("chance").initialValue(0.025, 0.075).upgradeModifier(UpgradeOperation.MULTIPLY_TOTAL, 0.1).formatValue(value -> MathUtils.round(value * 100.0, 1)).build()).build()).ability(AbilityData.builder("multiplying").requiredLevel(10).maxLevel(10).stat(StatData.builder("chance").initialValue(0.05, 0.15).upgradeModifier(UpgradeOperation.MULTIPLY_TOTAL, 0.128).formatValue(value -> (int)Math.round(MathUtils.round(value, 3) * 100.0)).build()).stat(StatData.builder("size").initialValue(0.05, 0.1).upgradeModifier(UpgradeOperation.MULTIPLY_TOTAL, 0.1775).formatValue(value -> (int)Math.round(MathUtils.round(value, 3) * 100.0)).build()).stat(StatData.builder("amount").initialValue(0.05, 0.15).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.4).formatValue(value -> MathUtils.round(value, 2)).build()).build()).ability(AbilityData.builder("explosion").requiredLevel(15).maxLevel(10).active(CastData.builder().type(CastType.INSTANTANEOUS).castPredicate("spore", (player, stack) -> NBTUtils.getInt(stack, TAG_SPORES, 0) > 0).build()).stat(StatData.builder("size").initialValue(0.05, 0.25).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.15).formatValue(value -> MathUtils.round(value, 2)).build()).build()).build()).leveling(new LevelingData(100, 20, 100)).style(StyleData.builder().build()).loot(LootData.builder().entry(LootCollections.JUNGLE).build()).build();
    }

    public int getMaxSpores(ItemStack stack) {
        return (int)Math.round(this.canUseAbility(stack, "buffer") ? this.getAbilityValue(stack, "buffer", "capacity") : 1.0);
    }

    public int getSpores(ItemStack stack) {
        return NBTUtils.getInt(stack, TAG_SPORES, 0);
    }

    public void setSpores(ItemStack stack, int amount) {
        NBTUtils.setInt(stack, TAG_SPORES, Mth.m_14045_((int)amount, (int)0, (int)this.getMaxSpores(stack)));
    }

    public void addSpores(ItemStack stack, int amount) {
        if (this.canUseAbility(stack, "buffer") && amount < 0) {
            Random random = new Random();
            if ((double)random.nextFloat() <= this.getAbilityValue(stack, "buffer", "chance")) {
                return;
            }
        }
        this.setSpores(stack, this.getSpores(stack) + amount);
    }

    @Override
    public void castActiveAbility(ItemStack stack, Player player, String ability, CastType type, CastStage stage) {
        Level level = player.m_20193_();
        RandomSource random = level.m_213780_();
        if (ability.equals("explosion") && this.getSpores(stack) > 0) {
            ParticleUtils.createBall((ParticleOptions)ParticleTypes.f_123764_, player.m_20182_().m_82520_(0.0, (double)(player.m_20206_() / 2.0f), 0.0), level, 2, 0.5f);
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_12290_, SoundSource.MASTER, 1.0f, 1.0f);
            while (this.getSpores(stack) > 0) {
                float mul = player.m_20206_() / 1.5f;
                float speed = 0.25f + random.m_188501_() * 0.2f;
                Vec3 motion = new Vec3((double)(MathUtils.randomFloat(random) * speed), (double)speed, (double)(MathUtils.randomFloat(random) * speed));
                SporeEntity spore = new SporeEntity((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.SPORE.get()), level);
                spore.m_5602_((Entity)player);
                spore.setStack(stack);
                spore.m_20256_(motion);
                spore.m_146884_(player.m_20182_().m_82520_(0.0, (double)mul, 0.0).m_82549_(motion.m_82541_().m_82490_((double)mul)));
                spore.setSize((float)Math.min((double)player.m_21233_(), (double)0.1f + (double)(player.m_21233_() - player.m_21223_()) * this.getAbilityValue(stack, "explosion", "size")));
                level.m_7967_((Entity)spore);
                this.addSpores(stack, -1);
            }
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).m_9236_().m_5776_() || this.getSpores(stack) >= this.getMaxSpores(stack) || (long)player.f_19797_ % Math.round(this.getAbilityValue(stack, "spore", "cooldown") * 20.0) != 0L) {
            return;
        }
        this.addSpores(stack, 1);
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class Events {
        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent event) {
            SporeSackItem relic;
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player)) {
                return;
            }
            Player player = (Player)livingEntity;
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.SPORE_SACK.get());
            Item item = stack.m_41720_();
            if (!(item instanceof SporeSackItem) || (relic = (SporeSackItem)item).getSpores(stack) < 1) {
                return;
            }
            Level level = player.m_9236_();
            if (level.m_5776_()) {
                return;
            }
            RandomSource random = player.m_217043_();
            float mul = player.m_20206_() / 1.5f;
            float speed = 0.25f + random.m_188501_() * 0.2f;
            Vec3 motion = new Vec3((double)(MathUtils.randomFloat(random) * speed), (double)speed, (double)(MathUtils.randomFloat(random) * speed));
            SporeEntity spore = new SporeEntity((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.SPORE.get()), level);
            spore.m_5602_((Entity)player);
            spore.setStack(stack.m_41777_());
            spore.m_20256_(motion);
            spore.m_146884_(player.m_20182_().m_82520_(0.0, (double)mul, 0.0).m_82549_(motion.m_82541_().m_82490_((double)mul)));
            spore.setSize((float)Math.min((double)player.m_21233_(), (double)0.1f + (double)event.getAmount() * relic.getAbilityValue(stack, "spore", "size")));
            level.m_7967_((Entity)spore);
            relic.addSpores(stack, -1);
            relic.spreadExperience((LivingEntity)player, stack, 1);
        }
    }
}

