/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.network.packets;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class EntityMotionPacket {
    private final int id;
    private final double x;
    private final double y;
    private final double z;

    public EntityMotionPacket(int id, Vec3 motion) {
        this(id, motion.m_7096_(), motion.m_7098_(), motion.m_7094_());
    }

    public static EntityMotionPacket decode(FriendlyByteBuf buf) {
        return new EntityMotionPacket(buf.readInt(), buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (context.getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                this.handleClientSide();
            } else {
                Level level;
                Entity entity;
                ServerPlayer player = context.getSender();
                if (player != null && (entity = (level = player.m_20193_()).m_6815_(this.id)) != null) {
                    entity.m_20334_(this.x, this.y, this.z);
                }
            }
        });
        context.setPacketHandled(true);
    }

    private void handleClientSide() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Entity entity = level.m_6815_(this.id);
        if (entity == null) {
            return;
        }
        entity.m_20334_(this.x, this.y, this.z);
    }

    public int getId() {
        return this.id;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityMotionPacket)) {
            return false;
        }
        EntityMotionPacket other = (EntityMotionPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (Double.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Double.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        return Double.compare(this.getZ(), other.getZ()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof EntityMotionPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        long $x = Double.doubleToLongBits(this.getX());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.getY());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        long $z = Double.doubleToLongBits(this.getZ());
        result = result * 59 + (int)($z >>> 32 ^ $z);
        return result;
    }

    public String toString() {
        return "EntityMotionPacket(id=" + this.getId() + ", x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ")";
    }

    public EntityMotionPacket(int id, double x, double y, double z) {
        this.id = id;
        this.x = x;
        this.y = y;
        this.z = z;
    }
}

