/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.worldgen.structure;

import com.github.yimeng261.maidspell.Global;
import com.github.yimeng261.maidspell.MaidSpellMod;
import com.github.yimeng261.maidspell.worldgen.MaidSpellStructures;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import org.jetbrains.annotations.NotNull;

public class HiddenRetreatStructure
extends Structure {
    public static final Codec<HiddenRetreatStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Structure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size)).apply((Applicative)instance, HiddenRetreatStructure::new)).codec();
    private final Holder<StructureTemplatePool> startPool;
    private final int size;
    private int height;
    private static final double MAX_TERRAIN_VARIANCE = 16.0;
    private static final int SAMPLES_PER_CHUNK = 5;
    public static final Set<Long> GENERATED_DIMENSIONS = ConcurrentHashMap.newKeySet();

    public HiddenRetreatStructure(Structure.StructureSettings settings, Holder<StructureTemplatePool> startPool, int size) {
        super(settings);
        this.startPool = startPool;
        this.size = size;
    }

    @NotNull
    protected Optional<Structure.GenerationStub> m_214086_(@NotNull Structure.GenerationContext context) {
        if (!this.isRetreatDimension(context)) {
            return Optional.empty();
        }
        long worldSeed = context.f_226627_();
        ChunkPos chunkPos = context.f_226628_();
        if (GENERATED_DIMENSIONS.contains(worldSeed)) {
            Global.LOGGER.debug("[findGenerationPoint] \u7ef4\u5ea6\u79cd\u5b50 {} \u5df2\u6807\u8bb0\u4e3a\u5df2\u751f\u6210\uff0c\u8df3\u8fc7\u533a\u5757 {}", (Object)worldSeed, (Object)chunkPos);
            return Optional.empty();
        }
        Global.LOGGER.debug("[findGenerationPoint] \u7ef4\u5ea6\u79cd\u5b50 {} \u672a\u6807\u8bb0\uff0c\u5f00\u59cb\u68c0\u67e5\u533a\u5757 {} \u7684\u5730\u5f62", (Object)worldSeed, (Object)chunkPos);
        if (!this.isValidGenerationLocation(context, chunkPos)) {
            return Optional.empty();
        }
        BlockPos centerPos = new BlockPos(chunkPos.m_45604_() + 8, this.height, chunkPos.m_45605_() + 8);
        Optional result = JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPool, Optional.empty(), (int)this.size, (BlockPos)centerPos, (boolean)false, Optional.empty(), (int)150);
        if (result.isPresent()) {
            MaidSpellMod.LOGGER.info("\u9690\u4e16\u4e4b\u5883\u7ed3\u6784\u751f\u6210\u6210\u529f\uff0c\u6807\u8bb0\u7ef4\u5ea6\u79cd\u5b50: {}\uff0c\u4f4d\u7f6e: {}", (Object)worldSeed, (Object)centerPos);
        }
        return result;
    }

    @NotNull
    public StructureType<?> m_213658_() {
        return (StructureType)MaidSpellStructures.HIDDEN_RETREAT.get();
    }

    private boolean isValidGenerationLocation(Structure.GenerationContext context, ChunkPos centerChunk) {
        ArrayList<Integer> heightSamples = new ArrayList<Integer>();
        int range = 2;
        int totalSamples = 0;
        int waterSamples = 0;
        for (int dx = -range; dx <= range; ++dx) {
            for (int dz = -range; dz <= range; ++dz) {
                ChunkPos checkChunk = new ChunkPos(centerChunk.f_45578_ + dx, centerChunk.f_45579_ + dz);
                SamplingResult result = this.sampleChunkHeights(context, checkChunk);
                heightSamples.addAll(result.heights);
                totalSamples += result.totalSamples;
                waterSamples += result.waterSamples;
            }
        }
        if (totalSamples > 0 && waterSamples > totalSamples / 2) {
            return false;
        }
        return this.isTerrainFlat(heightSamples);
    }

    private SamplingResult sampleChunkHeights(Structure.GenerationContext context, ChunkPos chunk) {
        ArrayList<Integer> heights = new ArrayList<Integer>();
        int waterCount = 0;
        RandomSource random = RandomSource.m_216335_((long)chunk.m_45588_());
        int minX = chunk.m_45604_();
        int minZ = chunk.m_45605_();
        for (int i = 0; i < 5; ++i) {
            int x = minX + random.m_188503_(16);
            int z = minZ + random.m_188503_(16);
            int surfaceHeight = context.f_226622_().m_223235_(x, z, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, context.f_226629_(), context.f_226624_());
            int oceanFloorHeight = context.f_226622_().m_223235_(x, z, Heightmap.Types.OCEAN_FLOOR_WG, context.f_226629_(), context.f_226624_());
            if (oceanFloorHeight < surfaceHeight) {
                ++waterCount;
            }
            heights.add(surfaceHeight);
        }
        return new SamplingResult(heights, 5, waterCount);
    }

    private boolean isTerrainFlat(List<Integer> heights) {
        if (heights.size() < 2) {
            return true;
        }
        double sum = 0.0;
        for (int height : heights) {
            sum += (double)height;
        }
        double mean = sum / (double)heights.size();
        this.height = (int)mean;
        double varianceSum = 0.0;
        for (int height : heights) {
            double diff = (double)height - mean;
            varianceSum += diff * diff;
        }
        double variance = varianceSum / (double)heights.size();
        return variance <= 16.0;
    }

    private boolean isRetreatDimension(Structure.GenerationContext context) {
        try {
            if (context.f_226623_() instanceof FixedBiomeSource) {
                Holder biome = context.f_226623_().m_203407_(0, 0, 0, context.f_226624_().m_224579_());
                return biome.m_203565_(Biomes.f_271432_);
            }
            return false;
        }
        catch (Exception e) {
            MaidSpellMod.LOGGER.error("Error checking dimension type", (Throwable)e);
            return false;
        }
    }

    private record SamplingResult(List<Integer> heights, int totalSamples, int waterSamples) {
    }
}

