/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.worldgen.structure;

import com.github.yimeng261.maidspell.worldgen.MaidSpellStructures;
import com.github.yimeng261.maidspell.worldgen.structure.SingleTemplatePiece;
import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;

public class FairyMaidCafeStructure
extends Structure {
    public static final Codec<FairyMaidCafeStructure> CODEC = FairyMaidCafeStructure.m_226607_(FairyMaidCafeStructure::new);
    private static final ResourceLocation TEMPLATE_LOCATION = new ResourceLocation("touhou_little_maid_spell", "fairy_maid_cafe");

    public FairyMaidCafeStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    @NotNull
    protected Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        if (!ModList.get().isLoaded("youkaishomecoming")) {
            return Optional.empty();
        }
        return FairyMaidCafeStructure.m_226585_((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, builder -> this.generatePieces((StructurePiecesBuilder)builder, context));
    }

    private void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context) {
        int x = context.f_226628_().m_45604_() + 8;
        int z = context.f_226628_().m_45605_() + 8;
        int y = context.f_226622_().m_223235_(x, z, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, context.f_226629_(), context.f_226624_());
        Rotation rotation = Rotation.m_221990_((RandomSource)context.f_226626_());
        Optional template = context.f_226625_().m_230407_(TEMPLATE_LOCATION);
        if (template.isEmpty()) {
            return;
        }
        BlockPos pos = new BlockPos(x, y - 1, z);
        builder.m_142679_((StructurePiece)new SingleTemplatePiece(context.f_226625_(), TEMPLATE_LOCATION, pos, rotation));
    }

    public StructureType<?> m_213658_() {
        return (StructureType)MaidSpellStructures.FAIRY_MAID_CAFE.get();
    }
}

