/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.worldgen.modifier;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class TemplatePoolModifier {
    private static final ResourceLocation VILLAGE_DESERT_STREETS_POOL = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"village/desert/streets");
    private static final ResourceLocation VILLAGE_PLAINS_STREETS_POOL = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"village/plains/streets");
    private static final ResourceLocation VILLAGE_SAVANNA_STREETS_POOL = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"village/savanna/streets");
    private static final ResourceLocation VILLAGE_SNOWY_STREETS_POOL = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"village/snowy/streets");
    private static final ResourceLocation VILLAGE_TAIGA_STREETS_POOL = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"village/taiga/streets");
    private static final ResourceLocation ENCHANTRESS_FOOTSTEPS_VILLAGE_DESERT_STREETS_POOL = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid_spell", (String)"enchantress_footsteps/village/desert_streets");
    private static final ResourceLocation ENCHANTRESS_FOOTSTEPS_VILLAGE_PLAINS_STREETS_POOL = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid_spell", (String)"enchantress_footsteps/village/plains_streets");
    private static final ResourceLocation ENCHANTRESS_FOOTSTEPS_VILLAGE_SAVANNA_STREETS_POOL = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid_spell", (String)"enchantress_footsteps/village/savanna_streets");
    private static final ResourceLocation ENCHANTRESS_FOOTSTEPS_VILLAGE_SNOWY_STREETS_POOL = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid_spell", (String)"enchantress_footsteps/village/snowy_streets");
    private static final ResourceLocation ENCHANTRESS_FOOTSTEPS_VILLAGE_TAIGA_STREETS_POOL = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid_spell", (String)"enchantress_footsteps/village/taiga_streets");

    private static void mergeBuildingPool(Registry<StructureTemplatePool> templatePoolRegistry, ResourceLocation target, ResourceLocation from) {
        StructureTemplatePool targetTemplatePool = (StructureTemplatePool)templatePoolRegistry.m_7745_(target);
        StructureTemplatePool fromTemplatePool = (StructureTemplatePool)templatePoolRegistry.m_7745_(from);
        if (targetTemplatePool == null || fromTemplatePool == null) {
            return;
        }
        ObjectArrayList templates = fromTemplatePool.f_210560_;
        targetTemplatePool.f_210560_.addAll((ObjectList)templates);
        List rawTemplates = fromTemplatePool.f_210559_;
        ArrayList mergedRawTemplates = new ArrayList(targetTemplatePool.f_210559_);
        mergedRawTemplates.addAll(rawTemplates);
        targetTemplatePool.f_210559_ = mergedRawTemplates;
    }

    @SubscribeEvent
    public static void modifyTemplatePoolBeforeServerStart(ServerAboutToStartEvent event) {
        Registry templatePoolRegistry = (Registry)event.getServer().m_206579_().m_6632_(Registries.f_256948_).orElseThrow();
        if (ModList.get().isLoaded("irons_spellbooks")) {
            TemplatePoolModifier.mergeBuildingPool((Registry<StructureTemplatePool>)templatePoolRegistry, VILLAGE_DESERT_STREETS_POOL, ENCHANTRESS_FOOTSTEPS_VILLAGE_DESERT_STREETS_POOL);
            TemplatePoolModifier.mergeBuildingPool((Registry<StructureTemplatePool>)templatePoolRegistry, VILLAGE_PLAINS_STREETS_POOL, ENCHANTRESS_FOOTSTEPS_VILLAGE_PLAINS_STREETS_POOL);
            TemplatePoolModifier.mergeBuildingPool((Registry<StructureTemplatePool>)templatePoolRegistry, VILLAGE_SAVANNA_STREETS_POOL, ENCHANTRESS_FOOTSTEPS_VILLAGE_SAVANNA_STREETS_POOL);
            TemplatePoolModifier.mergeBuildingPool((Registry<StructureTemplatePool>)templatePoolRegistry, VILLAGE_SNOWY_STREETS_POOL, ENCHANTRESS_FOOTSTEPS_VILLAGE_SNOWY_STREETS_POOL);
            TemplatePoolModifier.mergeBuildingPool((Registry<StructureTemplatePool>)templatePoolRegistry, VILLAGE_TAIGA_STREETS_POOL, ENCHANTRESS_FOOTSTEPS_VILLAGE_TAIGA_STREETS_POOL);
        }
    }
}

