/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.utils;

import com.mojang.logging.LogUtils;
import java.util.Optional;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import org.slf4j.Logger;

public class VersionUtil {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static String getModVersion(String modId) {
        Optional modContainer = ModList.get().getModContainerById(modId);
        if (modContainer.isPresent()) {
            String version = ((ModContainer)modContainer.get()).getModInfo().getVersion().toString();
            LOGGER.debug("Found mod {} with version: {}", (Object)modId, (Object)version);
            return version;
        }
        LOGGER.debug("Mod {} not found or not loaded", (Object)modId);
        return null;
    }

    public static boolean isVersionGreaterOrEqual(String version1, String version2) {
        if (version1 == null || version2 == null) {
            return false;
        }
        try {
            int[] v1Parts = VersionUtil.parseVersion(version1);
            int[] v2Parts = VersionUtil.parseVersion(version2);
            for (int i = 0; i < Math.max(v1Parts.length, v2Parts.length); ++i) {
                int v2Part;
                int v1Part = i < v1Parts.length ? v1Parts[i] : 0;
                int n = v2Part = i < v2Parts.length ? v2Parts[i] : 0;
                if (v1Part > v2Part) {
                    return true;
                }
                if (v1Part >= v2Part) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to compare versions {} and {}: {}", new Object[]{version1, version2, e.getMessage()});
            return false;
        }
    }

    private static int[] parseVersion(String version) {
        String cleanVersion = VersionUtil.cleanVersionString(version);
        String[] parts = cleanVersion.split("\\.");
        int[] versionParts = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            try {
                String numericPart = parts[i].replaceAll("\\D", "");
                versionParts[i] = numericPart.isEmpty() ? 0 : Integer.parseInt(numericPart);
                continue;
            }
            catch (NumberFormatException e) {
                versionParts[i] = 0;
            }
        }
        return versionParts;
    }

    private static String cleanVersionString(String version) {
        if (version == null) {
            return "0.0.0";
        }
        String cleaned = version.toLowerCase().replaceAll("^(v|version-?)", "").replaceAll("^mc\\d+\\.\\d+\\.\\d+-?", "").replaceAll("^forge-?", "").replaceAll("^fabric-?", "");
        if ((cleaned = cleaned.replaceAll("-(forge|fabric|snapshot|alpha|beta|rc\\d*).*$", "")).isEmpty()) {
            return "0.0.0";
        }
        return cleaned;
    }

    public static boolean isModVersionSatisfied(String modId, String minVersion) {
        String currentVersion = VersionUtil.getModVersion(modId);
        if (currentVersion == null) {
            return false;
        }
        boolean satisfied = VersionUtil.isVersionGreaterOrEqual(currentVersion, minVersion);
        LOGGER.debug("Mod {} version check: current={}, required={}, satisfied={}", new Object[]{modId, currentVersion, minVersion, satisfied});
        return satisfied;
    }

    public static boolean isGoetyVersionSatisfied(String minVersion) {
        return VersionUtil.isModVersionSatisfied("goety", minVersion);
    }
}

