/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IAttackTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidRangedWalkToTarget;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.item.MaidSpellItems;
import com.github.yimeng261.maidspell.spell.SimplifiedSpellCaster;
import com.github.yimeng261.maidspell.spell.data.MaidIronsSpellData;
import com.github.yimeng261.maidspell.task.SpellCombatMeleeTask;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class SpellCombatFarTask
extends SpellCombatMeleeTask {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ResourceLocation UID = new ResourceLocation("maidspell", "spell_combat_far");
    private static final MutableComponent NAME = Component.m_237115_((String)"task.maidspell.spell_combat_far");
    private static float SPELL_RANGE;

    public static void setSpellRange(Float range) {
        SPELL_RANGE = range.floatValue();
    }

    @Override
    @NotNull
    public ResourceLocation getUid() {
        return UID;
    }

    @Override
    @NotNull
    public MutableComponent getName() {
        return NAME;
    }

    @Override
    public boolean enableLookAndRandomWalk(@NotNull EntityMaid maid) {
        return super.enableLookAndRandomWalk(maid);
    }

    @Override
    @NotNull
    public ItemStack getIcon() {
        return ((Item)MaidSpellItems.FAR_TASK_ICON.get()).m_7968_();
    }

    @Override
    @NotNull
    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(@NotNull EntityMaid maid) {
        BehaviorControl supplementedTask = StartAttacking.m_257741_(this::hasSpellBook, IAttackTask::findFirstValidAttackTarget);
        BehaviorControl findTargetTask = StopAttackingIfTargetInvalid.m_257990_(target -> this.farAway((LivingEntity)target, maid));
        BehaviorControl moveToTargetTask = MaidRangedWalkToTarget.create((float)0.6f);
        FarSpellCombatBehavior spellCastingTask = new FarSpellCombatBehavior();
        SpellStrafingTask strafingTask = new SpellStrafingTask();
        SpellCombatMeleeTask.CombatLookControlTask lookControlTask = new SpellCombatMeleeTask.CombatLookControlTask();
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)1, (Object)((Object)lookControlTask)), Pair.of((Object)2, (Object)supplementedTask), Pair.of((Object)2, (Object)findTargetTask), Pair.of((Object)2, (Object)moveToTargetTask), Pair.of((Object)2, (Object)((Object)spellCastingTask)), Pair.of((Object)2, (Object)((Object)strafingTask))});
    }

    private static class FarSpellCombatBehavior
    extends SpellCombatMeleeTask.SpellCombatBehavior {
        private SimplifiedSpellCaster currentSpellCaster;

        private FarSpellCombatBehavior() {
        }

        @Override
        protected void start(@NotNull ServerLevel level, @NotNull EntityMaid maid, long gameTime) {
            this.currentSpellCaster = new SimplifiedSpellCaster(maid);
            LivingEntity target = maid.m_6274_().m_21952_(MemoryModuleType.f_26372_).orElse(null);
            if (target == maid.m_269323_() && ModList.get().isLoaded("irons_spellbooks")) {
                target = MaidIronsSpellData.getOrCreate(maid).getOriginTarget();
            }
            if (!(target instanceof Player)) {
                this.currentSpellCaster.setTarget(target);
            }
        }

        @Override
        protected void tick(@NotNull ServerLevel level, @NotNull EntityMaid maid, long gameTime) {
            if (this.currentSpellCaster != null) {
                LivingEntity currentTarget = maid.m_6274_().m_21952_(MemoryModuleType.f_26372_).orElse(null);
                if (!(currentTarget instanceof Player)) {
                    this.currentSpellCaster.setTarget(currentTarget);
                }
                this.currentSpellCaster.far_tick();
            }
        }

        @Override
        protected void stop(@NotNull ServerLevel level, @NotNull EntityMaid maid, long gameTime) {
            if (this.currentSpellCaster != null) {
                this.currentSpellCaster = null;
            }
        }
    }

    static class SpellStrafingTask
    extends SpellCombatMeleeTask.SpellStrafingTask {
        private final double optimalMinDistance = SimplifiedSpellCaster.FAR_RANGE;
        private final double maxAttackDistance = SPELL_RANGE;
        private final double rangeRange = 5.0;

        @Override
        protected void tick(@NotNull ServerLevel worldIn, EntityMaid maid, long gameTime) {
            if (maid.m_21827_()) {
                return;
            }
            SpellCombatFarTask task = new SpellCombatFarTask();
            if (!task.hasSpellBook(maid)) {
                return;
            }
            maid.m_6274_().m_21952_(MemoryModuleType.f_26372_).ifPresent(target -> {
                double distance = maid.m_20270_((Entity)target);
                double optimalMaxDistance = this.optimalMinDistance + 5.0;
                this.strafingTime = distance < this.maxAttackDistance && maid.canSee(target) ? ++this.strafingTime : -1;
                if (this.strafingTime >= 20) {
                    if ((double)maid.m_217043_().m_188501_() < 0.3) {
                        boolean bl = this.strafingClockwise = !this.strafingClockwise;
                    }
                    if ((double)maid.m_217043_().m_188501_() < 0.3) {
                        this.strafingBackwards = !this.strafingBackwards;
                    }
                    this.strafingTime = 0;
                }
                if (this.strafingTime > -1) {
                    if (distance > optimalMaxDistance) {
                        this.strafingBackwards = false;
                    } else if (distance < this.optimalMinDistance) {
                        this.strafingBackwards = true;
                    }
                    float forwardSpeed = this.strafingBackwards ? -0.7f : 0.7f;
                    float strafeSpeed = this.strafingClockwise ? 0.7f : -0.7f;
                    maid.m_21566_().m_24988_(forwardSpeed, strafeSpeed);
                    maid.m_146922_(Mth.m_14094_((float)maid.m_146908_(), (float)maid.f_20885_, (float)0.0f));
                }
            });
        }
    }
}

