/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.spell.providers;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.api.ISpellBookProvider;
import com.github.yimeng261.maidspell.spell.data.MaidYHSpellData;
import com.github.yimeng261.maidspell.spell.helpers.SpellCardHelper;
import com.github.yimeng261.maidspell.spell.holders.MaidCardHolder;
import com.mojang.logging.LogUtils;
import dev.xkmc.l2library.util.raytrace.RayTraceUtil;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.ItemDanmakuEntity;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.ItemLaserEntity;
import dev.xkmc.youkaishomecoming.content.item.danmaku.DanmakuItem;
import dev.xkmc.youkaishomecoming.content.item.danmaku.LaserItem;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.CardHolder;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.SpellCardWrapper;
import dev.xkmc.youkaishomecoming.init.registrate.YHEntities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class YoukaiHomecomingProvider
extends ISpellBookProvider<MaidYHSpellData, ItemStack> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MIN_DANMAKU_COUNT = 1;
    private static final int MAX_DANMAKU_COUNT = 10;
    private static final float FAN_ANGLE = 45.0f;
    private static final double SPELL_CARD_ACTIVATION_CHANCE = 0.5;
    private static final HashSet<Class<?>> DANMAKU_CLASSES = new HashSet<Class>(Arrays.asList(DanmakuItem.class, LaserItem.class));

    public YoukaiHomecomingProvider() {
        super(MaidYHSpellData::getOrCreate, ItemStack.class);
        LOGGER.info("YoukaiHomecomingProvider initialized with SpellCard support");
    }

    @Override
    protected List<ItemStack> collectSpellFromSingleSpellBook(ItemStack spellBook, EntityMaid maid) {
        return List.of(spellBook);
    }

    @Override
    public boolean isSpellBook(ItemStack itemStack) {
        if (itemStack == null || itemStack.m_41619_()) {
            return false;
        }
        return DANMAKU_CLASSES.contains(itemStack.m_41720_().getClass()) || SpellCardHelper.isSpellCardItem(itemStack);
    }

    @Override
    public void initiateCasting(EntityMaid maid) {
        MaidYHSpellData data = (MaidYHSpellData)this.getData(maid);
        Set<ItemStack> allDanmakuItems = data.getSpellBooks();
        if (allDanmakuItems.isEmpty()) {
            return;
        }
        if (!data.hasActiveSpellCard() && Math.random() < 0.5) {
            this.activateSpellCardFromInventory(maid, data, allDanmakuItems);
            return;
        }
        if (!data.hasActiveSpellCard()) {
            this.performRandomFanShooting(maid, allDanmakuItems);
        }
    }

    @Override
    public void processContinuousCasting(EntityMaid maid) {
        MaidYHSpellData data = (MaidYHSpellData)this.getData(maid);
        if (data == null || !data.isCasting()) {
            return;
        }
        data.updateCasting();
        if (data.hasActiveSpellCard()) {
            this.tickSpellCard(maid, data);
        }
        if (data.isSpellComplete()) {
            this.completeCasting(maid, data);
        }
    }

    @Override
    public void stopCasting(EntityMaid maid) {
        MaidYHSpellData data = (MaidYHSpellData)this.getData(maid);
        if (data != null && data.isCasting()) {
            data.resetCastingState();
            data.deactivateSpellCard();
        }
    }

    @Override
    public void updateCooldown(EntityMaid maid) {
        MaidYHSpellData data = (MaidYHSpellData)this.getData(maid);
        if (data != null) {
            data.updateCooldowns();
        }
    }

    private void performRandomFanShooting(EntityMaid maid, Set<ItemStack> allDanmakuItems) {
        ItemStack selectedItem;
        if (!(maid.m_9236_() instanceof ServerLevel)) {
            return;
        }
        MaidYHSpellData data = (MaidYHSpellData)this.getData(maid);
        Random random = new Random();
        int shotCount = random.nextInt(1, 11);
        Vec3 baseDirection = this.calculateShootDirection(maid, data);
        ArrayList<ItemStack> availableItem = new ArrayList<ItemStack>(allDanmakuItems.stream().toList());
        availableItem.removeIf(SpellCardHelper::isSpellCardItem);
        if (availableItem.isEmpty()) {
            LOGGER.debug("No danmaku available");
            return;
        }
        while (SpellCardHelper.isSpellCardItem(selectedItem = (ItemStack)availableItem.get(random.nextInt(availableItem.size())))) {
        }
        for (int i = 0; i < shotCount; ++i) {
            float angleOffset = 0.0f;
            if (shotCount > 1) {
                angleOffset = 45.0f / (float)(shotCount - 1) * (float)i - 22.5f;
            }
            Vec3 shootDirection = this.calculateFanDirection(baseDirection, angleOffset);
            this.fireDanmakuByType(maid, selectedItem, shootDirection);
        }
    }

    private Vec3 calculateShootDirection(EntityMaid maid, MaidYHSpellData data) {
        if (data.isValidTarget()) {
            LivingEntity target = data.getTarget();
            Vec3 targetPos = target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0);
            Vec3 maidPos = maid.m_20182_().m_82520_(0.0, (double)maid.m_20206_() * 0.8, 0.0);
            return targetPos.m_82546_(maidPos).m_82541_();
        }
        return RayTraceUtil.getRayTerm((Vec3)Vec3.f_82478_, (float)maid.m_146909_(), (float)maid.m_146908_(), (double)1.0);
    }

    private Vec3 calculateFanDirection(Vec3 baseDirection, float angleOffsetDegrees) {
        if (Math.abs(angleOffsetDegrees) < 0.1f) {
            return baseDirection;
        }
        double angleRad = Math.toRadians(angleOffsetDegrees);
        double cos = Math.cos(angleRad);
        double sin = Math.sin(angleRad);
        double newX = baseDirection.f_82479_ * cos - baseDirection.f_82481_ * sin;
        double newZ = baseDirection.f_82479_ * sin + baseDirection.f_82481_ * cos;
        return new Vec3(newX, baseDirection.f_82480_, newZ).m_82541_();
    }

    private void fireDanmakuByType(EntityMaid maid, ItemStack item, Vec3 direction) {
        if (!(maid.m_9236_() instanceof ServerLevel)) {
            return;
        }
        Item item2 = item.m_41720_();
        if (item2 instanceof DanmakuItem) {
            DanmakuItem danmakuItem = (DanmakuItem)item2;
            this.fireDanmakuWithDirection(maid, danmakuItem, item, direction);
        } else {
            item2 = item.m_41720_();
            if (item2 instanceof LaserItem) {
                LaserItem laserItem = (LaserItem)item2;
                this.fireLaserWithDirection(maid, laserItem, item, direction);
            }
        }
    }

    private void fireDanmakuWithDirection(EntityMaid maid, DanmakuItem danmakuItem, ItemStack item, Vec3 direction) {
        Level level = maid.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ItemDanmakuEntity danmaku = new ItemDanmakuEntity((EntityType)YHEntities.ITEM_DANMAKU.get(), (LivingEntity)maid, maid.m_9236_());
        danmaku.setItem(item);
        if (danmakuItem != null) {
            danmaku.setup((float)danmakuItem.type.damage(), 80, false, danmakuItem.type.bypass(), direction.m_82490_(2.0));
        } else {
            danmaku.setup(10.0f, 80, false, false, direction.m_82490_(2.0));
        }
        serverLevel.m_7967_((Entity)danmaku);
    }

    private void fireLaserWithDirection(EntityMaid maid, LaserItem laserItem, ItemStack item, Vec3 direction) {
        Level level = maid.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Vec3 startPos = maid.m_20182_().m_82520_(0.0, (double)maid.m_20206_() * 0.8, 0.0);
        ItemLaserEntity laser = new ItemLaserEntity((EntityType)YHEntities.ITEM_LASER.get(), (LivingEntity)maid, maid.m_9236_());
        laser.setItem(item);
        laser.setup((float)laserItem.type.damage(), 60, 32.0f, false, direction.m_82490_(1.5));
        laser.m_146884_(startPos);
        serverLevel.m_7967_((Entity)laser);
    }

    private void completeCasting(EntityMaid maid, MaidYHSpellData data) {
        if (data.getActiveSpellCard() != null) {
            data.setSpellCooldown(data.getActiveSpellCard().modelId, 1200, maid);
            data.deactivateSpellCard();
        }
        data.resetCastingState();
    }

    private void activateSpellCardFromInventory(EntityMaid maid, MaidYHSpellData data, Set<ItemStack> allItems) {
        ArrayList<ItemStack> spellCardItems = new ArrayList<ItemStack>();
        for (ItemStack item : allItems) {
            if (!SpellCardHelper.isSpellCardItem(item)) continue;
            spellCardItems.add(item);
        }
        if (spellCardItems.isEmpty()) {
            return;
        }
        ItemStack selectedItem = (ItemStack)spellCardItems.get(maid.m_217043_().m_188503_(spellCardItems.size()));
        SpellCardWrapper wrapper = SpellCardHelper.createSpellCardFromItem(selectedItem);
        if (wrapper == null || data.isSpellOnCooldown(wrapper.modelId)) {
            return;
        }
        data.activateSpellCard(wrapper);
    }

    private void tickSpellCard(EntityMaid maid, MaidYHSpellData data) {
        SpellCardWrapper spellCard = data.getActiveSpellCard();
        if (spellCard == null || spellCard.card == null || data.getTarget() == null) {
            return;
        }
        MaidCardHolder holder = new MaidCardHolder(maid, data.getTarget());
        spellCard.tick((CardHolder)holder);
    }
}

