/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.spell.providers;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.api.ISpellBookProvider;
import com.github.yimeng261.maidspell.spell.SimplifiedSpellCaster;
import com.github.yimeng261.maidspell.spell.data.MaidSlashBladeData;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.registry.SlashArtsRegistry;
import mods.flammpfeil.slashblade.registry.combo.ComboState;
import mods.flammpfeil.slashblade.slasharts.CircleSlash;
import mods.flammpfeil.slashblade.slasharts.Drive;
import mods.flammpfeil.slashblade.slasharts.JudgementCut;
import mods.flammpfeil.slashblade.slasharts.SakuraEnd;
import mods.flammpfeil.slashblade.slasharts.SlashArts;
import mods.flammpfeil.slashblade.slasharts.WaveEdge;
import mods.flammpfeil.slashblade.util.AttackManager;
import mods.flammpfeil.slashblade.util.KnockBacks;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.IForgeRegistry;
import org.slf4j.Logger;

public class SlashBladeProvider
extends ISpellBookProvider<MaidSlashBladeData, ResourceLocation> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Random RANDOM = new Random();
    private static final int DASH_COUNT = 3;
    private static final double DASH_DISTANCE_MULTIPLIER = 4.0;
    private static final int RANDOM_JUMP_CHANCE = 15;
    private static double JUMP_HEIGHT_MULTIPLIER = 1.2;
    private static final List<DirectSkill> GROUND_BASIC_SKILLS = List.of(DirectSkill.BASIC_SLASH, DirectSkill.HORIZONTAL_SLASH, DirectSkill.VERTICAL_SLASH, DirectSkill.DIAGONAL_SLASH_LEFT, DirectSkill.DIAGONAL_SLASH_RIGHT, DirectSkill.UPWARD_SLASH, DirectSkill.DOWNWARD_SLASH);
    private static final List<DirectSkill> GROUND_COMBO_SKILLS = List.of(DirectSkill.RAPID_SLASH, DirectSkill.MULTI_SLASH, DirectSkill.CROSS_SLASH, DirectSkill.SPINNING_SLASH, DirectSkill.RUSHING_COMBO, DirectSkill.PHANTOM_SLASH, DirectSkill.DASH_SLASH, DirectSkill.RUSH_ASSAULT, DirectSkill.CHARGE_SLASH, DirectSkill.SPRINT_COMBO, DirectSkill.BACKSTEP_SLASH, DirectSkill.SLIDE_SLASH, DirectSkill.JUMP_SLASH, DirectSkill.LEAP_STRIKE, DirectSkill.BOUNCE_ATTACK);
    private static final List<DirectSkill> GROUND_SPECIAL_SKILLS = List.of(DirectSkill.CIRCLE_SLASH, DirectSkill.FULL_CIRCLE_SLASH, DirectSkill.DRIVE_HORIZONTAL, DirectSkill.DRIVE_VERTICAL, DirectSkill.DRIVE_CROSS, DirectSkill.WAVE_EDGE, DirectSkill.WAVE_EDGE_BURST, DirectSkill.SAKURA_END, DirectSkill.JUDGEMENT_CUT, DirectSkill.JUDGEMENT_CUT_JUST, DirectSkill.VOID_SLASH, DirectSkill.PIERCING_DRIVE, DirectSkill.DOUBLE_DRIVE, DirectSkill.AREA_SWEEP, DirectSkill.OMNISLASH, DirectSkill.BLITZ_STRIKE, DirectSkill.PIERCING_DASH, DirectSkill.DASH_DRIVE, DirectSkill.WHIRLWIND_DASH, DirectSkill.JUMP_DRIVE, DirectSkill.DOUBLE_JUMP_SLASH);
    private static final List<DirectSkill> AERIAL_SKILLS = List.of(DirectSkill.AIR_SLASH, DirectSkill.AIR_SPIN, DirectSkill.AIR_CROSS, DirectSkill.AIR_DRIVE, DirectSkill.AIR_SPIRAL, DirectSkill.AIR_WAVE, DirectSkill.AERIAL_DASH);
    private static final List<DirectSkill> ALL_DASH_SKILLS = List.of(DirectSkill.DASH_SLASH, DirectSkill.RUSH_ASSAULT, DirectSkill.CHARGE_SLASH, DirectSkill.SPRINT_COMBO, DirectSkill.BACKSTEP_SLASH, DirectSkill.SLIDE_SLASH, DirectSkill.BLITZ_STRIKE, DirectSkill.PIERCING_DASH, DirectSkill.DASH_DRIVE, DirectSkill.WHIRLWIND_DASH);

    public SlashBladeProvider() {
        super(MaidSlashBladeData::getOrCreate, ResourceLocation.class);
    }

    @Override
    protected List<ResourceLocation> collectSpellFromSingleSpellBook(ItemStack spellBook, EntityMaid maid) {
        ArrayList<ResourceLocation> slashArts = new ArrayList<ResourceLocation>();
        if (spellBook == null || spellBook.m_41619_() || !this.isSpellBook(spellBook)) {
            return slashArts;
        }
        spellBook.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
            ResourceLocation slashArtKey = state.getSlashArtsKey();
            if (slashArtKey != null && !slashArtKey.equals((Object)SlashArtsRegistry.NONE.getId())) {
                slashArts.add(slashArtKey);
            }
        });
        return slashArts;
    }

    @Override
    public boolean isSpellBook(ItemStack itemStack) {
        return itemStack != null && !itemStack.m_41619_() && itemStack.m_41720_() instanceof ItemSlashBlade;
    }

    @Override
    public void setTarget(EntityMaid maid, LivingEntity target) {
        MaidSlashBladeData data = (MaidSlashBladeData)this.getData(maid);
        data.setTarget(target);
        ItemStack slashBlade = maid.m_21205_();
        if (this.isSpellBook(slashBlade)) {
            slashBlade.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
                if (target != null && target.m_6084_()) {
                    state.setTargetEntityId(target.m_19879_());
                }
            });
        }
    }

    @Override
    public void initiateCasting(EntityMaid maid) {
        LOGGER.debug("[MaidSpell] Initiate casting for slashblade");
        ItemStack itemStack = maid.m_21205_();
        MaidSlashBladeData data = (MaidSlashBladeData)this.getData(maid);
        LivingEntity target = data.getTarget();
        if (!maid.m_20096_()) {
            LOGGER.debug("[MaidSpell] Maid is in air, performing aerial attack");
            this.performSlashBladeAttack(maid, itemStack);
            return;
        }
        if (data.isOnCooldown().booleanValue() || !this.hasSlashArt(itemStack)) {
            if ((double)maid.m_20270_((Entity)target) < SimplifiedSpellCaster.MELEE_RANGE) {
                this.performSlashBladeAttack(maid, itemStack);
            } else {
                maid.m_21573_().m_5624_((Entity)target, 0.6);
            }
            return;
        }
        LOGGER.debug("[MaidSpell] Initiate casting for slashblade - start charging");
        itemStack.getCapability(ItemSlashBlade.BLADESTATE).map(state -> {
            if (state.isBroken() || state.isSealed()) {
                return false;
            }
            maid.m_6672_(InteractionHand.MAIN_HAND);
            int targetUseTime = state.getFullChargeTicks((LivingEntity)maid) + SlashArts.getJustReceptionSpan((LivingEntity)maid) / 2;
            LOGGER.debug("[MaidSpell] Target use time: {} ticks", (Object)targetUseTime);
            data.setCasting(true);
            data.setSAExecutionStartTime(maid.m_9236_().m_46467_());
            data.setTargetUseTime(targetUseTime);
            return true;
        });
    }

    @Override
    public void processContinuousCasting(EntityMaid maid) {
        MaidSlashBladeData data = (MaidSlashBladeData)this.getData(maid);
        ItemStack slashBlade = maid.m_21205_();
        if (!this.isSpellBook(slashBlade)) {
            return;
        }
        if (data.isOnCooldown().booleanValue() || !data.isCasting()) {
            return;
        }
        if (maid.m_6117_()) {
            int ticksUsing = maid.m_21252_();
            if (ticksUsing >= data.getTargetUseTime()) {
                this.triggerSlashArt(maid, slashBlade);
            } else {
                slashBlade.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
                    LivingEntity target = data.getTarget();
                    if (target != null && target.m_6084_()) {
                        BehaviorUtils.m_22595_((LivingEntity)maid, (LivingEntity)target);
                        Vec3 targetEyePos = target.m_146892_();
                        maid.m_7618_(EntityAnchorArgument.Anchor.EYES, targetEyePos);
                    }
                    slashBlade.m_41720_().m_6883_(slashBlade, maid.m_9236_(), (Entity)maid, 0, true);
                });
            }
        } else {
            this.processComboExecution(maid, slashBlade);
        }
    }

    @Override
    public void stopCasting(EntityMaid maid) {
        ItemStack slashBlade;
        MaidSlashBladeData data = (MaidSlashBladeData)this.getData(maid);
        if (maid.m_6117_()) {
            maid.m_21253_();
        }
        if (this.isSpellBook(slashBlade = maid.m_21205_())) {
            slashBlade.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
                state.setComboSeq(ComboStateRegistry.NONE.getId());
                state.setLastActionTime(maid.m_9236_().m_46467_());
            });
        }
        data.reset();
        if (data.getCooldown() < -40) {
            data.setCooldown(100);
        }
    }

    private void triggerSlashArt(EntityMaid maid, ItemStack slashBlade) {
        int ticksUsing = maid.m_21252_();
        int useDuration = slashBlade.m_41779_();
        int timeLeft = Math.max(0, useDuration - ticksUsing);
        slashBlade.m_41674_(maid.m_9236_(), (LivingEntity)maid, timeLeft);
        maid.m_5810_();
        slashBlade.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
            ResourceLocation currentCombo = state.getComboSeq();
            if (!currentCombo.equals((Object)ComboStateRegistry.NONE.getId())) {
                MaidSlashBladeData data = (MaidSlashBladeData)this.getData(maid);
                data.setSAExecutionStartTime(maid.m_9236_().m_46467_());
            } else {
                this.stopCasting(maid);
            }
        });
    }

    public boolean hasSlashArt(ItemStack itemStack) {
        if (itemStack.m_41619_() || !(itemStack.m_41720_() instanceof ItemSlashBlade)) {
            return false;
        }
        return itemStack.getCapability(ItemSlashBlade.BLADESTATE).map(state -> state.getSlashArtsKey() != null && !state.getSlashArtsKey().equals((Object)SlashArtsRegistry.NONE.getId())).orElse(false);
    }

    private void processComboExecution(EntityMaid maid, ItemStack slashBlade) {
        MaidSlashBladeData data = (MaidSlashBladeData)this.getData(maid);
        long currentTime = maid.m_9236_().m_46467_();
        long executionTime = currentTime - data.getSAExecutionStartTime();
        if (executionTime > 200L) {
            LOGGER.debug("SA execution timeout, forcing stop");
            this.stopCasting(maid);
            return;
        }
        slashBlade.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
            ResourceLocation currentCombo = state.getComboSeq();
            if (currentCombo.equals((Object)ComboStateRegistry.NONE.getId())) {
                this.stopCasting(maid);
                return;
            }
            data.setLastComboState(currentCombo);
            ComboState comboState = (ComboState)((IForgeRegistry)ComboStateRegistry.REGISTRY.get()).getValue(currentCombo);
            if (comboState != null) {
                slashBlade.m_41720_().m_6883_(slashBlade, maid.m_9236_(), (Entity)maid, 0, true);
            } else {
                this.stopCasting(maid);
            }
        });
    }

    private void performSlashBladeAttack(EntityMaid maid, ItemStack slashBlade) {
        LOGGER.debug("[MaidSpell] Performing slash blade attack with direct skill");
        MaidSlashBladeData data = (MaidSlashBladeData)this.getData(maid);
        LivingEntity target = data.getTarget();
        if (target != null && target.m_6084_()) {
            this.adjustMaidLookAngle(maid, target);
        }
        if (maid.m_20096_() && RANDOM.nextInt(100) < 15) {
            JUMP_HEIGHT_MULTIPLIER = data.getTarget() != null ? (double)(data.getTarget().m_20206_() / 2.0f) : 1.2;
            Vec3 jumpMotion = new Vec3(0.0, JUMP_HEIGHT_MULTIPLIER * 0.7, 0.0);
            maid.m_20256_(maid.m_20184_().m_82549_(jumpMotion));
            maid.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 100, 0, false, false, true));
            LOGGER.debug("[MaidSpell] Random jump triggered!");
        }
        DirectSkill skill = this.selectRandomSkill(maid);
        LOGGER.debug("[MaidSpell] Selected skill: {} (NonDashCount: {})", (Object)skill.getDisplayName(), (Object)data.getNonDashSkillCount());
        if (ALL_DASH_SKILLS.contains((Object)skill)) {
            data.resetNonDashSkillCount();
        } else {
            data.incrementNonDashSkillCount();
        }
        skill.execute(maid);
        slashBlade.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> state.setLastActionTime(maid.m_9236_().m_46467_()));
    }

    private void adjustMaidLookAngle(EntityMaid maid, LivingEntity target) {
        Vec3 maidPos = maid.m_146892_();
        Vec3 targetPos = target.m_146892_();
        Vec3 direction = targetPos.m_82546_(maidPos);
        double horizontalDistance = Math.sqrt(direction.f_82479_ * direction.f_82479_ + direction.f_82481_ * direction.f_82481_);
        double heightDiff = direction.f_82480_;
        float pitch = (float)Math.toDegrees(Math.atan2(heightDiff, horizontalDistance));
        float yaw = (float)Math.toDegrees(Math.atan2(-direction.f_82479_, direction.f_82481_));
        maid.m_146922_(yaw);
        maid.m_146926_(pitch);
        maid.m_5616_(yaw);
        maid.f_19859_ = yaw;
        maid.f_19860_ = pitch;
        LOGGER.debug("[MaidSpell] Adjusted maid look angle: yaw={}, pitch={}, heightDiff={}, horizontalDist={}", new Object[]{Float.valueOf(yaw), Float.valueOf(pitch), heightDiff, horizontalDistance});
    }

    private static float getPitchCorrection(EntityMaid maid) {
        return maid.m_146909_();
    }

    private DirectSkill selectRandomSkill(EntityMaid maid) {
        int roll;
        MaidSlashBladeData data = (MaidSlashBladeData)this.getData(maid);
        if (data.getNonDashSkillCount() >= 3 && maid.m_20096_()) {
            LOGGER.debug("[MaidSpell] Forcing dash skill (count: {})", (Object)data.getNonDashSkillCount());
            return ALL_DASH_SKILLS.get(RANDOM.nextInt(ALL_DASH_SKILLS.size()));
        }
        List<DirectSkill> availableSkills = maid.m_20096_() ? ((roll = RANDOM.nextInt(100)) < 60 ? GROUND_BASIC_SKILLS : (roll < 80 ? GROUND_COMBO_SKILLS : GROUND_SPECIAL_SKILLS)) : AERIAL_SKILLS;
        return availableSkills.get(RANDOM.nextInt(availableSkills.size()));
    }

    public static enum DirectSkill {
        BASIC_SLASH("\u57fa\u7840\u65a9\u51fb", SkillType.BASIC, maid -> {
            float roll = RANDOM.nextInt(60) - 30;
            AttackManager.doSlash((LivingEntity)maid, (float)roll, (Vec3)Vec3.f_82478_, (boolean)false, (boolean)false, (double)1.0, (KnockBacks)KnockBacks.cancel);
        }),
        HORIZONTAL_SLASH("\u6a2a\u65a9", SkillType.BASIC, maid -> {
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            AttackManager.doSlash((LivingEntity)maid, (float)pitch, (Vec3)Vec3.f_82478_, (boolean)false, (boolean)false, (double)1.0, (KnockBacks)KnockBacks.cancel);
        }),
        VERTICAL_SLASH("\u7eb5\u65a9", SkillType.BASIC, maid -> {
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            AttackManager.doSlash((LivingEntity)maid, (float)(-90.0f + pitch), (Vec3)Vec3.f_82478_, (boolean)false, (boolean)false, (double)1.0, (KnockBacks)KnockBacks.cancel);
        }),
        DIAGONAL_SLASH_LEFT("\u659c\u65a9\u00b7\u5de6", SkillType.BASIC, maid -> {
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            AttackManager.doSlash((LivingEntity)maid, (float)(-45.0f + pitch), (Vec3)Vec3.f_82478_, (boolean)false, (boolean)false, (double)1.0, (KnockBacks)KnockBacks.cancel);
        }),
        DIAGONAL_SLASH_RIGHT("\u659c\u65a9\u00b7\u53f3", SkillType.BASIC, maid -> {
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            AttackManager.doSlash((LivingEntity)maid, (float)(45.0f + pitch), (Vec3)Vec3.f_82478_, (boolean)false, (boolean)false, (double)1.0, (KnockBacks)KnockBacks.cancel);
        }),
        UPWARD_SLASH("\u4e0a\u6311\u65a9", SkillType.BASIC, maid -> {
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            AttackManager.doSlash((LivingEntity)maid, (float)(-135.0f + pitch), (Vec3)Vec3.f_82478_, (boolean)false, (boolean)false, (double)1.1, (KnockBacks)KnockBacks.toss);
        }),
        DOWNWARD_SLASH("\u4e0b\u5288\u65a9", SkillType.BASIC, maid -> {
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            AttackManager.doSlash((LivingEntity)maid, (float)(90.0f + pitch), (Vec3)Vec3.f_82478_, (boolean)false, (boolean)true, (double)1.2, (KnockBacks)KnockBacks.smash);
        }),
        RAPID_SLASH("\u75be\u8d70\u5c45\u5408", SkillType.COMBO, maid -> {
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            for (int i = 0; i < 3; ++i) {
                float roll = -45.0f + 90.0f * RANDOM.nextFloat() + (float)(i * 180);
                AttackManager.doSlash((LivingEntity)maid, (float)(roll + pitch), (Vec3)Vec3.f_82478_, (boolean)false, (i == 2 ? 1 : 0) != 0, (double)0.44, (KnockBacks)KnockBacks.cancel);
            }
        }),
        MULTI_SLASH("\u8fde\u7eed\u65a9", SkillType.COMBO, maid -> {
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            for (int i = 0; i < 5; ++i) {
                float roll = -90.0f + 180.0f * RANDOM.nextFloat();
                Vec3 offset = new Vec3((double)(RANDOM.nextFloat() - 0.5f), 0.0, (double)(RANDOM.nextFloat() - 0.5f));
                AttackManager.doSlash((LivingEntity)maid, (float)(roll + pitch), (Vec3)offset, (boolean)false, (boolean)false, (double)0.24, (KnockBacks)KnockBacks.cancel);
            }
        }),
        CROSS_SLASH("\u5341\u5b57\u65a9", SkillType.COMBO, maid -> {
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            AttackManager.doSlash((LivingEntity)maid, (float)pitch, (Vec3)Vec3.f_82478_, (boolean)false, (boolean)false, (double)0.6, (KnockBacks)KnockBacks.cancel);
            AttackManager.doSlash((LivingEntity)maid, (float)(-90.0f + pitch), (Vec3)Vec3.f_82478_, (boolean)false, (boolean)true, (double)0.6, (KnockBacks)KnockBacks.cancel);
        }),
        SPINNING_SLASH("\u65cb\u98ce\u65a9", SkillType.COMBO, maid -> {
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            for (int i = 0; i < 4; ++i) {
                float roll = i * 90;
                AttackManager.doSlash((LivingEntity)maid, (float)(roll + pitch), (Vec3)Vec3.f_82478_, (boolean)false, (i == 3 ? 1 : 0) != 0, (double)0.35, (KnockBacks)KnockBacks.cancel);
            }
        }),
        RUSHING_COMBO("\u7a81\u8fdb\u8fde\u65a9", SkillType.COMBO, maid -> {
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            for (int i = 0; i < 3; ++i) {
                Vec3 offset = AttackManager.genRushOffset((LivingEntity)maid).m_82490_(0.3);
                float roll = -60 + i * 60;
                AttackManager.doSlash((LivingEntity)maid, (float)(roll + pitch), (Vec3)offset, (boolean)false, (i == 2 ? 1 : 0) != 0, (double)0.5, (KnockBacks)KnockBacks.cancel);
            }
        }),
        PHANTOM_SLASH("\u5e7b\u5f71\u65a9", SkillType.COMBO, maid -> {
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            for (int i = 0; i < 4; ++i) {
                float roll = RANDOM.nextInt(180) - 90;
                Vec3 offset = new Vec3((double)(RANDOM.nextFloat() - 0.5f) * 0.5, 0.0, (double)(RANDOM.nextFloat() - 0.5f) * 0.5);
                AttackManager.doSlash((LivingEntity)maid, (float)(roll + pitch), (Vec3)offset, (boolean)true, (boolean)false, (double)0.28, (KnockBacks)KnockBacks.cancel);
            }
        }),
        CIRCLE_SLASH("\u56de\u65cb\u65a9", SkillType.SPECIAL, maid -> {
            for (int i = 0; i < 4; ++i) {
                float yRot = i * 90;
                CircleSlash.doCircleSlashAttack((LivingEntity)maid, (float)yRot);
            }
        }),
        FULL_CIRCLE_SLASH("\u5168\u65b9\u4f4d\u56de\u65cb\u65a9", SkillType.SPECIAL, maid -> {
            for (int i = 0; i < 8; ++i) {
                float yRot = i * 45;
                CircleSlash.doCircleSlashAttack((LivingEntity)maid, (float)yRot);
            }
        }),
        DRIVE_HORIZONTAL("\u9a71\u52a8\u65a9\u00b7\u6a2a", SkillType.SPECIAL, maid -> {
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            Drive.doSlash((LivingEntity)maid, (float)pitch, (int)10, (Vec3)Vec3.f_82478_, (boolean)false, (double)1.5, (float)2.0f);
        }),
        DRIVE_VERTICAL("\u9a71\u52a8\u65a9\u00b7\u7eb5", SkillType.SPECIAL, maid -> {
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            Drive.doSlash((LivingEntity)maid, (float)(-90.0f + pitch), (int)10, (Vec3)Vec3.f_82478_, (boolean)false, (double)1.5, (float)2.0f);
        }),
        DRIVE_CROSS("\u9a71\u52a8\u65a9\u00b7\u5341\u5b57", SkillType.SPECIAL, maid -> {
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            Drive.doSlash((LivingEntity)maid, (float)pitch, (int)8, (Vec3)Vec3.f_82478_, (boolean)false, (double)1.2, (float)2.2f);
            Drive.doSlash((LivingEntity)maid, (float)(-90.0f + pitch), (int)8, (Vec3)Vec3.f_82478_, (boolean)false, (double)1.2, (float)2.2f);
        }),
        WAVE_EDGE("\u6ce2\u5203", SkillType.SPECIAL, maid -> {
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            WaveEdge.doSlash((LivingEntity)maid, (float)pitch, (int)12, (Vec3)Vec3.f_82478_, (boolean)false, (double)0.8, (float)1.5f, (float)2.5f, (int)3);
        }),
        WAVE_EDGE_BURST("\u6ce2\u5203\u7206\u53d1", SkillType.SPECIAL, maid -> {
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            WaveEdge.doSlash((LivingEntity)maid, (float)pitch, (int)10, (Vec3)Vec3.f_82478_, (boolean)true, (double)0.6, (float)1.8f, (float)3.0f, (int)5);
        }),
        SAKURA_END("\u6a31\u82b1\u7ec8\u7ed3", SkillType.SPECIAL, maid -> {
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            SakuraEnd.doSlash((LivingEntity)maid, (float)pitch, (Vec3)Vec3.f_82478_, (boolean)false, (boolean)true, (double)1.8, (KnockBacks)KnockBacks.toss);
        }),
        JUDGEMENT_CUT("\u6b21\u5143\u65a9", SkillType.SPECIAL, JudgementCut::doJudgementCut),
        JUDGEMENT_CUT_JUST("\u6b21\u5143\u65a9\u00b7\u6781", SkillType.SPECIAL, JudgementCut::doJudgementCutJust),
        VOID_SLASH("\u865a\u7a7a\u65a9", SkillType.SPECIAL, AttackManager::doVoidSlashAttack),
        PIERCING_DRIVE("\u8d2f\u7a7f\u9a71\u52a8", SkillType.SPECIAL, maid -> {
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            Drive.doSlash((LivingEntity)maid, (float)pitch, (int)15, (Vec3)Vec3.f_82478_, (boolean)true, (double)2.0, (KnockBacks)KnockBacks.smash, (float)2.5f);
        }),
        DOUBLE_DRIVE("\u53cc\u91cd\u9a71\u52a8", SkillType.SPECIAL, maid -> {
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            Vec3 leftOffset = new Vec3(0.0, 0.0, -0.5);
            Vec3 rightOffset = new Vec3(0.0, 0.0, 0.5);
            Drive.doSlash((LivingEntity)maid, (float)pitch, (int)10, (Vec3)leftOffset, (boolean)false, (double)1.3, (float)2.0f);
            Drive.doSlash((LivingEntity)maid, (float)pitch, (int)10, (Vec3)rightOffset, (boolean)false, (double)1.3, (float)2.0f);
        }),
        AIR_SLASH("\u7a7a\u4e2d\u65a9", SkillType.AERIAL, maid -> {
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            AttackManager.doSlash((LivingEntity)maid, (float)(-20.0f + pitch), (Vec3)Vec3.f_82478_, (boolean)false, (boolean)false, (double)0.28, (KnockBacks)KnockBacks.cancel);
        }),
        AIR_SPIN("\u7a7a\u4e2d\u56de\u65cb", SkillType.AERIAL, maid -> {
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            for (int i = 0; i < 2; ++i) {
                float roll = 237 + i * 180;
                AttackManager.doSlash((LivingEntity)maid, (float)(roll + pitch), (Vec3)Vec3.f_82478_, (boolean)false, (boolean)false, (double)0.34, (KnockBacks)KnockBacks.toss);
            }
        }),
        AIR_CROSS("\u7a7a\u4e2d\u5341\u5b57", SkillType.AERIAL, maid -> {
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            AttackManager.doSlash((LivingEntity)maid, (float)pitch, (Vec3)Vec3.f_82478_, (boolean)false, (boolean)false, (double)0.35, (KnockBacks)KnockBacks.cancel);
            AttackManager.doSlash((LivingEntity)maid, (float)(-90.0f + pitch), (Vec3)Vec3.f_82478_, (boolean)false, (boolean)false, (double)0.35, (KnockBacks)KnockBacks.smash);
        }),
        AIR_DRIVE("\u7a7a\u4e2d\u9a71\u52a8", SkillType.AERIAL, maid -> {
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            Drive.doSlash((LivingEntity)maid, (float)(-30.0f + pitch), (int)8, (Vec3)Vec3.f_82478_, (boolean)false, (double)1.2, (float)2.0f);
        }),
        AIR_SPIRAL("\u7a7a\u4e2d\u87ba\u65cb", SkillType.AERIAL, maid -> {
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            for (int i = 0; i < 3; ++i) {
                float roll = i * 120;
                Vec3 offset = new Vec3(Math.cos((double)i * Math.PI * 2.0 / 3.0) * 0.3, -0.2 * (double)i, Math.sin((double)i * Math.PI * 2.0 / 3.0) * 0.3);
                AttackManager.doSlash((LivingEntity)maid, (float)(roll + pitch), (Vec3)offset, (boolean)false, (i == 2 ? 1 : 0) != 0, (double)0.4, (KnockBacks)KnockBacks.cancel);
            }
        }),
        AIR_WAVE("\u7a7a\u4e2d\u6ce2\u5203", SkillType.AERIAL, maid -> {
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            WaveEdge.doSlash((LivingEntity)maid, (float)(-20.0f + pitch), (int)10, (Vec3)Vec3.f_82478_, (boolean)false, (double)0.7, (float)1.5f, (float)2.2f, (int)2);
        }),
        AREA_SWEEP("\u8303\u56f4\u6a2a\u626b", SkillType.SPECIAL, maid -> {
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            for (int i = 0; i < 3; ++i) {
                float roll = -30 + i * 30;
                Vec3 offset = new Vec3(0.0, 0.0, (double)(i - 1) * 0.4);
                AttackManager.doSlash((LivingEntity)maid, (float)(roll + pitch), (Vec3)offset, (boolean)false, (i == 2 ? 1 : 0) != 0, (double)0.8, (KnockBacks)KnockBacks.cancel);
            }
        }),
        OMNISLASH("\u5168\u65b9\u4f4d\u65a9", SkillType.SPECIAL, maid -> {
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            for (int i = 0; i < 6; ++i) {
                float roll = i * 60;
                AttackManager.doSlash((LivingEntity)maid, (float)(roll + pitch), (Vec3)Vec3.f_82478_, (boolean)true, (i == 5 ? 1 : 0) != 0, (double)0.3, (KnockBacks)KnockBacks.cancel);
            }
        }),
        DASH_SLASH("\u51b2\u523a\u65a9", SkillType.COMBO, maid -> {
            Vec3 lookAngle = maid.m_20154_();
            Vec3 dashMotion = new Vec3(lookAngle.f_82479_ * 4.0, 0.1, lookAngle.f_82481_ * 4.0);
            maid.m_20256_(maid.m_20184_().m_82549_(dashMotion));
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            AttackManager.doSlash((LivingEntity)maid, (float)pitch, (Vec3)Vec3.f_82478_, (boolean)false, (boolean)true, (double)1.2, (KnockBacks)KnockBacks.toss);
        }),
        RUSH_ASSAULT("\u7a81\u88ad\u65a9", SkillType.COMBO, maid -> {
            Vec3 lookAngle = maid.m_20154_();
            Vec3 rushMotion = new Vec3(lookAngle.f_82479_ * 4.0, 0.0, lookAngle.f_82481_ * 4.0);
            maid.m_20256_(maid.m_20184_().m_82549_(rushMotion));
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            for (int i = 0; i < 3; ++i) {
                Vec3 offset = AttackManager.genRushOffset((LivingEntity)maid).m_82490_(0.4);
                float roll = -60 + i * 60;
                AttackManager.doSlash((LivingEntity)maid, (float)(roll + pitch), (Vec3)offset, (boolean)false, (i == 2 ? 1 : 0) != 0, (double)0.45, (KnockBacks)KnockBacks.cancel);
            }
        }),
        BLITZ_STRIKE("\u95ea\u7535\u7a81\u51fb", SkillType.SPECIAL, maid -> {
            Vec3 lookAngle = maid.m_20154_();
            Vec3 blitzMotion = new Vec3(lookAngle.f_82479_ * 4.0, 0.15, lookAngle.f_82481_ * 4.0);
            maid.m_20256_(maid.m_20184_().m_82549_(blitzMotion));
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            Drive.doSlash((LivingEntity)maid, (float)pitch, (int)12, (Vec3)Vec3.f_82478_, (boolean)true, (double)1.8, (float)3.0f);
            AttackManager.doSlash((LivingEntity)maid, (float)pitch, (Vec3)Vec3.f_82478_, (boolean)false, (boolean)true, (double)1.5, (KnockBacks)KnockBacks.smash);
        }),
        CHARGE_SLASH("\u51b2\u950b\u65a9", SkillType.COMBO, maid -> {
            Vec3 lookAngle = maid.m_20154_();
            Vec3 chargeMotion = new Vec3(lookAngle.f_82479_ * 4.0, 0.0, lookAngle.f_82481_ * 4.0);
            maid.m_20256_(maid.m_20184_().m_82549_(chargeMotion));
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            AttackManager.doSlash((LivingEntity)maid, (float)(-45.0f + pitch), (Vec3)Vec3.f_82478_, (boolean)false, (boolean)true, (double)1.4, (KnockBacks)KnockBacks.smash);
        }),
        SPRINT_COMBO("\u75be\u8dd1\u8fde\u65a9", SkillType.COMBO, maid -> {
            Vec3 lookAngle = maid.m_20154_();
            Vec3 sprintMotion = new Vec3(lookAngle.f_82479_ * 4.0, 0.0, lookAngle.f_82481_ * 4.0);
            maid.m_20256_(maid.m_20184_().m_82549_(sprintMotion));
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            for (int i = 0; i < 4; ++i) {
                float roll = i % 2 == 0 ? -30.0f : 30.0f;
                AttackManager.doSlash((LivingEntity)maid, (float)(roll + pitch), (Vec3)Vec3.f_82478_, (boolean)true, (i == 3 ? 1 : 0) != 0, (double)0.35, (KnockBacks)KnockBacks.cancel);
            }
        }),
        PIERCING_DASH("\u8d2f\u7a7f\u51b2\u523a", SkillType.SPECIAL, maid -> {
            Vec3 lookAngle = maid.m_20154_();
            Vec3 pierceMotion = new Vec3(lookAngle.f_82479_ * 4.0, 0.1, lookAngle.f_82481_ * 4.0);
            maid.m_20256_(maid.m_20184_().m_82549_(pierceMotion));
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            for (int i = 0; i < 3; ++i) {
                Drive.doSlash((LivingEntity)maid, (float)pitch, (int)8, (Vec3)Vec3.f_82478_, (boolean)true, (double)0.8, (float)2.8f);
            }
        }),
        BACKSTEP_SLASH("\u540e\u64a4\u65a9", SkillType.COMBO, maid -> {
            Vec3 lookAngle = maid.m_20154_();
            Vec3 backMotion = new Vec3(-lookAngle.f_82479_ * 4.0, 0.2, -lookAngle.f_82481_ * 4.0);
            maid.m_20256_(maid.m_20184_().m_82549_(backMotion));
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            AttackManager.doSlash((LivingEntity)maid, (float)pitch, (Vec3)Vec3.f_82478_, (boolean)false, (boolean)false, (double)0.9, (KnockBacks)KnockBacks.cancel);
            AttackManager.doSlash((LivingEntity)maid, (float)(180.0f + pitch), (Vec3)Vec3.f_82478_, (boolean)false, (boolean)true, (double)0.9, (KnockBacks)KnockBacks.cancel);
        }),
        SLIDE_SLASH("\u6ed1\u6b65\u65a9", SkillType.COMBO, maid -> {
            Vec3 lookAngle = maid.m_20154_();
            Vec3 rightVec = new Vec3(-lookAngle.f_82481_, 0.0, lookAngle.f_82479_).m_82541_();
            Vec3 slideMotion = rightVec.m_82490_((double)(RANDOM.nextBoolean() ? 1 : -1) * 4.0);
            maid.m_20256_(maid.m_20184_().m_82549_(slideMotion));
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            AttackManager.doSlash((LivingEntity)maid, (float)(90.0f + pitch), (Vec3)Vec3.f_82478_, (boolean)false, (boolean)true, (double)1.1, (KnockBacks)KnockBacks.cancel);
        }),
        DASH_DRIVE("\u51b2\u523a\u9a71\u52a8", SkillType.SPECIAL, maid -> {
            Vec3 lookAngle = maid.m_20154_();
            Vec3 dashMotion = new Vec3(lookAngle.f_82479_ * 4.0, 0.1, lookAngle.f_82481_ * 4.0);
            maid.m_20256_(maid.m_20184_().m_82549_(dashMotion));
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            Drive.doSlash((LivingEntity)maid, (float)pitch, (int)10, (Vec3)Vec3.f_82478_, (boolean)true, (double)1.3, (float)2.5f);
            Drive.doSlash((LivingEntity)maid, (float)(-90.0f + pitch), (int)10, (Vec3)Vec3.f_82478_, (boolean)true, (double)1.3, (float)2.5f);
        }),
        WHIRLWIND_DASH("\u65cb\u98ce\u51b2\u523a", SkillType.SPECIAL, maid -> {
            Vec3 lookAngle = maid.m_20154_();
            Vec3 whirlMotion = new Vec3(lookAngle.f_82479_ * 4.0, 0.15, lookAngle.f_82481_ * 4.0);
            maid.m_20256_(maid.m_20184_().m_82549_(whirlMotion));
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            for (int i = 0; i < 3; ++i) {
                float roll = i * 120;
                AttackManager.doSlash((LivingEntity)maid, (float)(roll + pitch), (Vec3)Vec3.f_82478_, (boolean)true, (i == 2 ? 1 : 0) != 0, (double)0.5, (KnockBacks)KnockBacks.cancel);
            }
        }),
        JUMP_SLASH("\u8df3\u8dc3\u65a9", SkillType.COMBO, maid -> {
            if (maid.m_20096_()) {
                Vec3 jumpMotion = new Vec3(0.0, JUMP_HEIGHT_MULTIPLIER, 0.0);
                maid.m_20256_(maid.m_20184_().m_82549_(jumpMotion));
            }
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            AttackManager.doSlash((LivingEntity)maid, (float)(90.0f + pitch), (Vec3)Vec3.f_82478_, (boolean)false, (boolean)true, (double)1.3, (KnockBacks)KnockBacks.smash);
        }),
        LEAP_STRIKE("\u8dc3\u51fb", SkillType.COMBO, maid -> {
            Vec3 lookAngle = maid.m_20154_();
            if (maid.m_20096_()) {
                Vec3 leapMotion = new Vec3(lookAngle.f_82479_ * 4.0 * 0.7, JUMP_HEIGHT_MULTIPLIER, lookAngle.f_82481_ * 4.0 * 0.7);
                maid.m_20256_(maid.m_20184_().m_82549_(leapMotion));
            }
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            AttackManager.doSlash((LivingEntity)maid, (float)(-45.0f + pitch), (Vec3)Vec3.f_82478_, (boolean)false, (boolean)true, (double)1.4, (KnockBacks)KnockBacks.toss);
        }),
        BOUNCE_ATTACK("\u5f39\u8df3\u653b\u51fb", SkillType.COMBO, maid -> {
            if (maid.m_20096_()) {
                Vec3 bounceMotion = new Vec3(0.0, JUMP_HEIGHT_MULTIPLIER * 0.6, 0.0);
                maid.m_20256_(maid.m_20184_().m_82549_(bounceMotion));
            }
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            for (int i = 0; i < 2; ++i) {
                float roll = i * 180;
                AttackManager.doSlash((LivingEntity)maid, (float)(roll + pitch), (Vec3)Vec3.f_82478_, (boolean)false, (i == 1 ? 1 : 0) != 0, (double)0.6, (KnockBacks)KnockBacks.cancel);
            }
        }),
        JUMP_DRIVE("\u8df3\u8dc3\u9a71\u52a8", SkillType.SPECIAL, maid -> {
            if (maid.m_20096_()) {
                Vec3 jumpMotion = new Vec3(0.0, JUMP_HEIGHT_MULTIPLIER * 0.8, 0.0);
                maid.m_20256_(maid.m_20184_().m_82549_(jumpMotion));
            }
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            Drive.doSlash((LivingEntity)maid, (float)(-20.0f + pitch), (int)10, (Vec3)Vec3.f_82478_, (boolean)true, (double)1.5, (float)2.5f);
        }),
        AERIAL_DASH("\u7a7a\u4e2d\u7a81\u8fdb", SkillType.AERIAL, maid -> {
            Vec3 lookAngle = maid.m_20154_();
            Vec3 airDashMotion = new Vec3(lookAngle.f_82479_ * 4.0 * 0.8, 0.1, lookAngle.f_82481_ * 4.0 * 0.8);
            maid.m_20256_(maid.m_20184_().m_82549_(airDashMotion));
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            AttackManager.doSlash((LivingEntity)maid, (float)pitch, (Vec3)Vec3.f_82478_, (boolean)false, (boolean)true, (double)1.2, (KnockBacks)KnockBacks.toss);
        }),
        DOUBLE_JUMP_SLASH("\u4e8c\u6bb5\u8df3\u65a9", SkillType.SPECIAL, maid -> {
            if (!maid.m_20096_()) {
                Vec3 doubleJumpMotion = new Vec3(0.0, JUMP_HEIGHT_MULTIPLIER * 0.7, 0.0);
                maid.m_20256_(maid.m_20184_().m_82549_(doubleJumpMotion));
            } else {
                Vec3 jumpMotion = new Vec3(0.0, JUMP_HEIGHT_MULTIPLIER, 0.0);
                maid.m_20256_(maid.m_20184_().m_82549_(jumpMotion));
            }
            float pitch = SlashBladeProvider.getPitchCorrection(maid);
            AttackManager.doSlash((LivingEntity)maid, (float)(-90.0f + pitch), (Vec3)Vec3.f_82478_, (boolean)false, (boolean)true, (double)1.5, (KnockBacks)KnockBacks.smash);
        });

        private final String displayName;
        private final SkillType type;
        private final Consumer<EntityMaid> executor;

        private DirectSkill(String displayName, SkillType type, Consumer<EntityMaid> executor) {
            this.displayName = displayName;
            this.type = type;
            this.executor = executor;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public SkillType getType() {
            return this.type;
        }

        public void execute(EntityMaid maid) {
            this.executor.accept(maid);
        }
    }

    public static enum SkillType {
        BASIC,
        COMBO,
        SPECIAL,
        AERIAL;

    }
}

