/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.spell.data;

import com.github.yimeng261.maidspell.api.IMaidSpellData;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.SpellCardWrapper;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class MaidYHSpellData
extends IMaidSpellData {
    private static final ConcurrentHashMap<UUID, MaidYHSpellData> DATA_MAP = new ConcurrentHashMap();
    private int castingTime = 0;
    private final int maxCastingTime = 400;
    private SpellCardWrapper activeSpellCard = null;

    private MaidYHSpellData(UUID uuid) {
    }

    @Override
    protected boolean canAddSpellBook(ItemStack spellBook) {
        return true;
    }

    public static MaidYHSpellData getOrCreate(UUID maidUUID) {
        return DATA_MAP.computeIfAbsent(maidUUID, MaidYHSpellData::new);
    }

    public static void remove(UUID maidUUID) {
        DATA_MAP.remove(maidUUID);
    }

    @Override
    public LivingEntity getTarget() {
        return this.target;
    }

    @Override
    public boolean isCasting() {
        return this.isCasting;
    }

    public void updateCasting() {
        if (this.isCasting) {
            ++this.castingTime;
        }
    }

    public boolean isSpellComplete() {
        return this.castingTime >= 400;
    }

    @Override
    public void resetCastingState() {
        this.isCasting = false;
        this.castingTime = 0;
    }

    public boolean isValidTarget() {
        return this.target != null && this.target.m_6084_();
    }

    public void activateSpellCard(SpellCardWrapper spellCard) {
        this.isCasting = true;
        this.activeSpellCard = spellCard;
        if (spellCard != null && spellCard.card != null) {
            spellCard.card.reset();
        }
    }

    @Nullable
    public SpellCardWrapper getActiveSpellCard() {
        return this.activeSpellCard;
    }

    public boolean hasActiveSpellCard() {
        return this.activeSpellCard != null;
    }

    public void deactivateSpellCard() {
        if (this.activeSpellCard != null && this.activeSpellCard.card != null) {
            this.activeSpellCard.card.reset();
        }
        this.activeSpellCard = null;
    }
}

