/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.network.message;

import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class SpellSyncClientHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<UUID, Map<String, String>> GLOBAL_MAID_SPELL_RECORD = new ConcurrentHashMap<UUID, Map<String, String>>();

    public static void handleSpellSync(UUID maidUUID, Map<String, String> spellMap) {
        if (spellMap.isEmpty()) {
            GLOBAL_MAID_SPELL_RECORD.remove(maidUUID);
        } else {
            GLOBAL_MAID_SPELL_RECORD.put(maidUUID, new HashMap<String, String>(spellMap));
        }
    }

    public static Map<UUID, Map<String, String>> getGlobalMaidSpellRecord() {
        return GLOBAL_MAID_SPELL_RECORD;
    }

    public static Map<String, String> getMaidSpells(UUID maidUUID) {
        Map<String, String> spells = GLOBAL_MAID_SPELL_RECORD.get(maidUUID);
        return spells != null ? Map.copyOf(spells) : new HashMap<String, String>();
    }

    public static String getMaidSpellForMod(UUID maidUUID, String modId) {
        Map<String, String> spells = GLOBAL_MAID_SPELL_RECORD.get(maidUUID);
        return spells != null ? spells.get(modId) : null;
    }

    public static boolean isMaidCasting(UUID maidUUID) {
        Map<String, String> spells = GLOBAL_MAID_SPELL_RECORD.get(maidUUID);
        return spells != null && !spells.isEmpty();
    }

    public static Set<UUID> getActiveMaidUUIDs() {
        return GLOBAL_MAID_SPELL_RECORD.keySet();
    }

    public static void clearGlobalSpellRecord() {
        GLOBAL_MAID_SPELL_RECORD.clear();
        LOGGER.info("[\u5ba2\u6237\u7aef\u5168\u5c40] \u5df2\u6e05\u7a7a\u5973\u4ec6\u6cd5\u672f\u8bb0\u5f55");
    }

    public static boolean hasSpellData() {
        return !GLOBAL_MAID_SPELL_RECORD.isEmpty();
    }

    public static int getMaidCount() {
        return GLOBAL_MAID_SPELL_RECORD.size();
    }

    public static int getTotalSpellCount() {
        return GLOBAL_MAID_SPELL_RECORD.values().stream().mapToInt(Map::size).sum();
    }
}

