/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.mixin.iss;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.MaidSpellMod;
import com.github.yimeng261.maidspell.spell.data.MaidIronsSpellData;
import io.netty.buffer.Unpooled;
import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.capabilities.magic.SyncedSpellData;
import io.redspace.ironsspellbooks.setup.Messages;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.util.Lazy;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SyncedSpellData.class}, remap=false)
public abstract class SyncedSpellDataMixin {
    @Shadow
    private LivingEntity livingEntity;
    @Unique
    private static final Lazy<Field> maidSpell$SYNCED_SPELL_DATA_FIELD = Lazy.of(SyncedSpellDataMixin::maidSpell$getSyncedSpellDataField);
    @Unique
    private static final Lazy<Boolean> maidSpell$isOldIronsSpellBooks = Lazy.of(SyncedSpellDataMixin::maidSpell$isOldIronsSpellBooks);
    @Unique
    private static final Lazy<Constructor<?>> maidSpell$ClientboundSyncEntityDataConstructor = Lazy.of(SyncedSpellDataMixin::maidSpell$getClientboundSyncEntityDataConstructor);
    @Unique
    private static final Lazy<Method> maidSpell$SyncedSpellDataWriteMethod = Lazy.of(SyncedSpellDataMixin::maidSpell$getSyncedSpellDataWriteMethod);
    @Unique
    private static final Lazy<Method> maidSpell$PacketDistributorSendToPlayersTrackingEntityMethod = Lazy.of(SyncedSpellDataMixin::maidSpell$getPacketDistributorSendToPlayersTrackingEntityMethod);
    @Unique
    private static final Lazy<Constructor<?>> maidSpell$SyncEntityDataPacketConstructor = Lazy.of(SyncedSpellDataMixin::maidSpell$getSyncEntityDataPacketConstructor);

    @Inject(method={"doSync"}, at={@At(value="TAIL")})
    public void afterDoSync(CallbackInfo ci) {
        EntityMaid maid;
        MaidIronsSpellData spellData;
        LivingEntity livingEntity;
        if (!(this.livingEntity instanceof IMagicEntity) && (livingEntity = this.livingEntity) instanceof EntityMaid && (spellData = MaidIronsSpellData.get((maid = (EntityMaid)livingEntity).m_20148_())) != null) {
            FriendlyByteBuf byteBuf = new FriendlyByteBuf(Unpooled.buffer());
            byteBuf.writeInt(maid.m_19879_());
            if (((Boolean)maidSpell$isOldIronsSpellBooks.get()).booleanValue()) {
                this.maidSpell$sendToPlayersTrackingEntityOld(byteBuf, this.livingEntity);
            } else {
                this.maidSpell$sendToPlayersTrackingEntity(byteBuf, this.livingEntity);
            }
        }
    }

    @Unique
    private void maidSpell$sendToPlayersTrackingEntityOld(FriendlyByteBuf byteBuf, LivingEntity livingEntity) {
        Field field = (Field)maidSpell$SYNCED_SPELL_DATA_FIELD.get();
        try {
            EntityDataSerializer writter = (EntityDataSerializer)field.get(null);
            writter.m_6856_(byteBuf, (Object)((SyncedSpellData)this));
            Messages.sendToPlayersTrackingEntity(((Constructor)maidSpell$ClientboundSyncEntityDataConstructor.get()).newInstance(byteBuf), (Entity)livingEntity);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Unique
    private void maidSpell$sendToPlayersTrackingEntity(FriendlyByteBuf byteBuf, LivingEntity livingEntity) {
        Method writeMethod = (Method)maidSpell$SyncedSpellDataWriteMethod.get();
        Method sendToPlayersTrackingEntityMethod = (Method)maidSpell$PacketDistributorSendToPlayersTrackingEntityMethod.get();
        try {
            writeMethod.invoke(null, byteBuf, (SyncedSpellData)this);
            sendToPlayersTrackingEntityMethod.invoke(null, livingEntity, ((Constructor)maidSpell$SyncEntityDataPacketConstructor.get()).newInstance(byteBuf));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Unique
    private static boolean maidSpell$isOldIronsSpellBooks() {
        try {
            Class.forName("io.redspace.ironsspellbooks.network.ClientboundSyncEntityData");
            return true;
        }
        catch (ClassNotFoundException e) {
            MaidSpellMod.LOGGER.warn("Could not find ClientboundSyncEntityData, use PacketDistributor", (Throwable)e);
            return false;
        }
    }

    @Unique
    private static Constructor<?> maidSpell$getClientboundSyncEntityDataConstructor() {
        try {
            Class<?> clazz = Class.forName("io.redspace.ironsspellbooks.network.ClientboundSyncEntityData");
            return clazz.getConstructor(FriendlyByteBuf.class);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @Unique
    private static Field maidSpell$getSyncedSpellDataField() {
        try {
            Field syncedSpellData = SyncedSpellData.class.getDeclaredField("SYNCED_SPELL_DATA");
            syncedSpellData.setAccessible(true);
            return syncedSpellData;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @Unique
    private static Method maidSpell$getSyncedSpellDataWriteMethod() {
        try {
            return SyncedSpellData.class.getMethod("write", FriendlyByteBuf.class, SyncedSpellData.class);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @Unique
    private static Method maidSpell$getPacketDistributorSendToPlayersTrackingEntityMethod() {
        try {
            return Class.forName("io.redspace.ironsspellbooks.setup.PacketDistributor").getMethod("sendToPlayersTrackingEntity", Entity.class, Object.class);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @Unique
    private static Constructor<?> maidSpell$getSyncEntityDataPacketConstructor() {
        try {
            Class<?> clazz = Class.forName("io.redspace.ironsspellbooks.network.casting.SyncEntityDataPacket");
            return clazz.getConstructor(FriendlyByteBuf.class);
        }
        catch (Exception ignored) {
            return null;
        }
    }
}

