/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.mixin;

import com.github.yimeng261.maidspell.MaidSpellMod;
import com.github.yimeng261.maidspell.dimension.accessor.MinecraftServerAccessor;
import com.github.yimeng261.maidspell.worldgen.accessor.ChunkGeneratorAccessor;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.util.thread.ReentrantBlockableEventLoop;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.storage.DerivedLevelData;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin
extends ReentrantBlockableEventLoop<Runnable>
implements MinecraftServerAccessor {
    @Shadow
    @Final
    private Map<ResourceKey<Level>, ServerLevel> f_129762_;
    @Shadow
    @Final
    private Executor f_129738_;
    @Shadow
    @Final
    protected LevelStorageSource.LevelStorageAccess f_129744_;
    @Final
    @Shadow
    private LayeredRegistryAccess<RegistryLayer> f_244176_;

    @Shadow
    public abstract RegistryAccess.Frozen m_206579_();

    public MinecraftServerMixin(String name) {
        super(name);
    }

    @Override
    public boolean maidspell$createWorld(ResourceKey<Level> key, ResourceLocation dimensionTypeKey) {
        try {
            MinecraftServer server = (MinecraftServer)this;
            if (this.f_129762_.containsKey(key)) {
                MaidSpellMod.LOGGER.debug("Dimension already exists: {}", (Object)key.m_135782_());
                return true;
            }
            RegistryAccess.Frozen registryAccess = server.m_206579_();
            Registry dimensionRegistry = registryAccess.m_175515_(Registries.f_256862_);
            ServerLevel overworld = this.f_129762_.get(Level.f_46428_);
            if (overworld == null) {
                MaidSpellMod.LOGGER.error("Overworld not found, cannot create dimension");
                return false;
            }
            ResourceLocation templateKey = new ResourceLocation("touhou_little_maid_spell", "the_retreat");
            LevelStem templateStem = (LevelStem)dimensionRegistry.m_7745_(templateKey);
            if (templateStem == null) {
                MaidSpellMod.LOGGER.error("Template LevelStem not found for: {}", (Object)templateKey);
                return false;
            }
            try {
                Registry structureSetRegistry = registryAccess.m_175515_(Registries.f_256998_);
                int structureSetCount = structureSetRegistry.m_13562_();
                MaidSpellMod.LOGGER.debug("Creating dimension with {} structure sets available", (Object)structureSetCount);
                ResourceLocation hiddenRetreatSetKey = new ResourceLocation("touhou_little_maid_spell", "hidden_retreat_set");
                boolean hasHiddenRetreat = structureSetRegistry.m_7804_(hiddenRetreatSetKey);
                MaidSpellMod.LOGGER.debug("Hidden retreat structure set exists: {}", (Object)hasHiddenRetreat);
            }
            catch (Exception e) {
                MaidSpellMod.LOGGER.warn("Failed to verify structure sets", (Throwable)e);
            }
            ServerLevelData overworldLevelData = (ServerLevelData)overworld.m_6106_();
            WorldData worldData = server.m_129910_();
            DerivedLevelData derivedLevelData = new DerivedLevelData(worldData, overworldLevelData);
            long seed = BiomeManager.m_47877_((long)((long)(6737151.0 * Math.random())));
            ChunkProgressListener progressListener = new ChunkProgressListener(){

                public void m_7647_(@NotNull ChunkPos pos) {
                }

                public void m_5511_(@NotNull ChunkPos pChunkPosition, @Nullable ChunkStatus pNewStatus) {
                }

                public void m_9662_() {
                }

                public void m_7646_() {
                }
            };
            ServerLevel newLevel = new ServerLevel(server, this.f_129738_, this.f_129744_, (ServerLevelData)derivedLevelData, key, templateStem, progressListener, overworld.m_46659_(), seed, (List)ImmutableList.of(), true, overworld.m_288231_());
            ChunkGenerator chunkGenerator = newLevel.m_7726_().m_8481_();
            if (chunkGenerator instanceof ChunkGeneratorAccessor) {
                ChunkGeneratorAccessor accessor = (ChunkGeneratorAccessor)chunkGenerator;
                accessor.maidspell$setDimensionKey(key);
                MaidSpellMod.LOGGER.debug("Set dimension key for ChunkGenerator: {}", (Object)key.m_135782_());
            }
            this.f_129762_.put(key, newLevel);
            server.m_6846_().m_184209_(newLevel);
            MinecraftForge.EVENT_BUS.post((Event)new LevelEvent.Load((LevelAccessor)newLevel));
            try {
                newLevel.m_8895_();
                newLevel.m_8643_(null, false, false);
            }
            catch (Exception e) {
                MaidSpellMod.LOGGER.warn("Failed to initialize dimension data storage for: {}", (Object)key.m_135782_(), (Object)e);
            }
            try {
                server.getClass().getMethod("markWorldsDirty", new Class[0]).invoke((Object)server, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            MaidSpellMod.LOGGER.info("Successfully created dimension: {}", (Object)key.m_135782_());
            return true;
        }
        catch (Exception e) {
            MaidSpellMod.LOGGER.error("Failed to create dimension: {}", (Object)key.m_135782_(), (Object)e);
            return false;
        }
    }

    @Override
    public void maidspell$removeWorld(ResourceKey<Level> key) {
        try {
            ServerLevel level = this.f_129762_.remove(key);
            if (level != null) {
                MaidSpellMod.LOGGER.info("Removed dimension: {}", (Object)key.m_135782_());
            }
        }
        catch (Exception e) {
            MaidSpellMod.LOGGER.error("Failed to remove dimension: {}", (Object)key.m_135782_(), (Object)e);
        }
    }
}

