/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.mixin;

import com.github.yimeng261.maidspell.MaidSpellMod;
import com.github.yimeng261.maidspell.worldgen.accessor.ChunkGeneratorAccessor;
import java.util.Optional;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkGenerator.class})
public abstract class ChunkGeneratorMixin
implements ChunkGeneratorAccessor {
    @Unique
    private static final ResourceLocation HIDDEN_RETREAT_ID = new ResourceLocation("touhou_little_maid_spell", "hidden_retreat");
    @Unique
    @Nullable
    private ResourceKey<Level> maidspell$dimensionKey = null;

    @Shadow
    public abstract BiomeSource m_62218_();

    @Override
    public void maidspell$setDimensionKey(ResourceKey<Level> dimensionKey) {
        this.maidspell$dimensionKey = dimensionKey;
    }

    @Override
    @Nullable
    public ResourceKey<Level> maidspell$getDimensionKey() {
        return this.maidspell$dimensionKey;
    }

    @Inject(method={"tryGenerateStructure"}, at={@At(value="HEAD")}, cancellable=true)
    private void onTryGenerateStructure(StructureSet.StructureSelectionEntry structureEntry, StructureManager structureManager, RegistryAccess registryAccess, RandomState randomState, StructureTemplateManager templateManager, long seed, ChunkAccess chunk, ChunkPos chunkPos, SectionPos sectionPos, CallbackInfoReturnable<Boolean> cir) {
        if (!this.maidspell$isRetreatDimension()) {
            return;
        }
        Optional structureKey = structureEntry.f_210026_().m_203543_();
        if (structureKey.isEmpty()) {
            return;
        }
        ResourceLocation structureId = ((ResourceKey)structureKey.get()).m_135782_();
        if (HIDDEN_RETREAT_ID.equals((Object)structureId)) {
            MaidSpellMod.LOGGER.debug("Allowing HiddenRetreat structure generation at chunk {}, {}", (Object)chunkPos.f_45578_, (Object)chunkPos.f_45579_);
            return;
        }
        MaidSpellMod.LOGGER.debug("Blocking structure {} generation in retreat dimension at chunk {}, {}", new Object[]{structureId, chunkPos.f_45578_, chunkPos.f_45579_});
        cir.setReturnValue((Object)false);
    }

    @Unique
    private boolean maidspell$isRetreatDimension() {
        try {
            if (this.maidspell$dimensionKey == null) {
                return false;
            }
            ResourceLocation dimensionLocation = this.maidspell$dimensionKey.m_135782_();
            return dimensionLocation.m_135827_().equals("touhou_little_maid_spell") && dimensionLocation.m_135815_().startsWith("the_retreat");
        }
        catch (Exception e) {
            MaidSpellMod.LOGGER.error("Error checking if dimension is retreat", (Throwable)e);
            return false;
        }
    }
}

