/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.item.common.WindSeekingBell;

import com.github.yimeng261.maidspell.Global;
import com.github.yimeng261.maidspell.item.common.WindSeekingBell.SearchCacheManager;
import com.github.yimeng261.maidspell.item.common.WindSeekingBell.SearchConfig;
import com.github.yimeng261.maidspell.item.common.WindSeekingBell.StripedLock;
import com.github.yimeng261.maidspell.worldgen.structure.HiddenRetreatStructure;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.structure.Structure;

public class StructureSearchEngine {
    private static final ResourceLocation HIDDEN_RETREAT_LOCATION = new ResourceLocation("touhou_little_maid_spell", "hidden_retreat");
    private static final ResourceKey<Structure> HIDDEN_RETREAT_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)HIDDEN_RETREAT_LOCATION);
    private static volatile HolderSet<Structure> cachedStructureSet = null;
    private static final Object STRUCTURE_SET_LOCK = new Object();
    private static final StripedLock STRUCTURE_CHECK_LOCK = new StripedLock(64);
    private static final ThreadPoolExecutor SEARCH_EXECUTOR = (ThreadPoolExecutor)Executors.newFixedThreadPool(SearchConfig.getRecommendedThreadPoolSize(), r -> {
        Thread t = new Thread(r, "WindSeekingBell-Search-" + System.currentTimeMillis());
        t.setDaemon(true);
        t.setPriority(4);
        return t;
    });
    private static final ThreadPoolExecutor VERIFICATION_EXECUTOR = (ThreadPoolExecutor)Executors.newFixedThreadPool(SearchConfig.getRecommendedVerificationThreadPoolSize(), r -> {
        Thread t = new Thread(r, "WindSeekingBell-Verify-" + System.currentTimeMillis());
        t.setDaemon(true);
        t.setPriority(4);
        return t;
    });
    private final SearchCacheManager cacheManager;

    public StructureSearchEngine(SearchCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public CompletableFuture<BlockPos> searchAsync(ServerLevel level, BlockPos playerPos) {
        SearchCacheManager.CacheCheckResult cacheResult = this.cacheManager.checkCache(level);
        if (cacheResult.hasCache) {
            if (cacheResult.isNegativeCache) {
                return CompletableFuture.completedFuture(null);
            }
            return CompletableFuture.completedFuture(cacheResult.structurePos);
        }
        String searchKey = this.cacheManager.generateDimensionKey(level);
        CompletableFuture<BlockPos> existingSearch = this.cacheManager.getOngoingSearch(searchKey);
        if (existingSearch != null) {
            return existingSearch;
        }
        Global.LOGGER.info("\u5f00\u59cb\u7ed3\u6784\u641c\u7d22 - \u7ef4\u5ea6: {}", (Object)level.m_46472_().m_135782_());
        CompletionStage searchFuture = CompletableFuture.supplyAsync(() -> {
            try {
                return this.searchParallel(level, playerPos);
            }
            catch (Exception e) {
                Global.LOGGER.error("Structure search failed for dimension: {}", (Object)level.m_46472_().m_135782_(), (Object)e);
                return null;
            }
        }, SEARCH_EXECUTOR).whenComplete((result, throwable) -> {
            this.cacheManager.removeSearch(searchKey);
            if (result != null) {
                Global.LOGGER.info("\u7ed3\u6784\u641c\u7d22\u5b8c\u6210 - \u627e\u5230\u4f4d\u7f6e: {}", result);
            } else {
                Global.LOGGER.warn("\u7ed3\u6784\u641c\u7d22\u5b8c\u6210 - \u672a\u627e\u5230\u7ed3\u6784");
            }
        });
        this.cacheManager.registerSearch(searchKey, (CompletableFuture<BlockPos>)searchFuture);
        return searchFuture;
    }

    private BlockPos searchParallel(ServerLevel level, BlockPos playerPos) {
        SearchCacheManager.CacheCheckResult cacheResult = this.cacheManager.checkCache(level);
        if (cacheResult.hasCache) {
            return cacheResult.structurePos;
        }
        ChunkPos playerChunk = new ChunkPos(playerPos);
        BlockPos result = this.parallelSquareSearch(level, playerChunk);
        this.cacheManager.updateCache(level, result);
        return result;
    }

    private BlockPos parallelSquareSearch(ServerLevel level, ChunkPos centerChunk) {
        int maxSectorLayer = 30;
        int totalSearchArea = 361201;
        AtomicInteger checkedChunks = new AtomicInteger(0);
        long searchStartTime = System.currentTimeMillis();
        for (int sectorLayer = 0; sectorLayer <= maxSectorLayer; ++sectorLayer) {
            BlockPos result = this.searchSectorLayerParallel(level, centerChunk, sectorLayer, checkedChunks, totalSearchArea);
            if (result == null) continue;
            long searchTime = System.currentTimeMillis() - searchStartTime;
            Global.LOGGER.info("\u627e\u5230\u7ed3\u6784 - \u4f4d\u7f6e: {}, \u8017\u65f6: {} ms", (Object)result, (Object)searchTime);
            return result;
        }
        long searchTime = System.currentTimeMillis() - searchStartTime;
        Global.LOGGER.warn("\u641c\u7d22\u5b8c\u6210\u4f46\u672a\u627e\u5230\u7ed3\u6784 - \u8017\u65f6: {} ms", (Object)searchTime);
        return null;
    }

    private BlockPos searchSectorLayerParallel(ServerLevel level, ChunkPos centerChunk, int sectorLayer, AtomicInteger checkedChunks, int totalSearchArea) {
        List<int[]> sectorCoords = this.generateSectorCoordinates(sectorLayer);
        ArrayList<CompletableFuture<BlockPos>> sectorTasks = new ArrayList<CompletableFuture<BlockPos>>();
        AtomicBoolean layerComplete = new AtomicBoolean(false);
        AtomicInteger completedSectors = new AtomicInteger(0);
        int totalSectors = sectorCoords.size();
        for (int[] coords : sectorCoords) {
            int sectorX = coords[0];
            int sectorZ = coords[1];
            int n = sectorTasks.size();
            CompletableFuture<BlockPos> sectorTask = CompletableFuture.supplyAsync(() -> {
                BlockPos result = this.searchSectorWithTermination(level, centerChunk, sectorX, sectorZ, layerComplete, checkedChunks, totalSearchArea, sectorIndex, totalSectors);
                if (result != null) {
                    completedSectors.incrementAndGet();
                }
                return result;
            }, SEARCH_EXECUTOR);
            sectorTasks.add(sectorTask);
        }
        try {
            BlockPos result = null;
            while (!sectorTasks.isEmpty() && result == null) {
                CompletableFuture<Object> anyCompleted = CompletableFuture.anyOf(sectorTasks.toArray(new CompletableFuture[0]));
                try {
                    anyCompleted.get(120L, TimeUnit.SECONDS);
                }
                catch (Exception sectorX) {
                    // empty catch block
                }
                ArrayList<CompletableFuture> remainingTasks = new ArrayList<CompletableFuture>();
                for (CompletableFuture completableFuture : sectorTasks) {
                    if (completableFuture.isDone()) {
                        try {
                            BlockPos taskResult = (BlockPos)completableFuture.get();
                            if (taskResult == null || result != null) continue;
                            result = taskResult;
                            layerComplete.set(true);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    remainingTasks.add(completableFuture);
                }
                sectorTasks = remainingTasks;
                if (result == null) continue;
                for (CompletableFuture completableFuture : sectorTasks) {
                    completableFuture.cancel(true);
                }
            }
            return result;
        }
        catch (Exception e) {
            layerComplete.set(true);
            sectorTasks.forEach(task -> task.cancel(true));
            return null;
        }
    }

    private List<int[]> generateSectorCoordinates(int layer) {
        ArrayList<int[]> coords = new ArrayList<int[]>();
        if (layer == 0) {
            coords.add(new int[]{0, 0});
            return coords;
        }
        int x = -layer;
        while (x <= layer) {
            coords.add(new int[]{x++, layer});
        }
        int z = layer - 1;
        while (z >= -layer) {
            coords.add(new int[]{layer, z--});
        }
        x = layer - 1;
        while (x >= -layer) {
            coords.add(new int[]{x--, -layer});
        }
        z = -layer + 1;
        while (z <= layer - 1) {
            coords.add(new int[]{-layer, z++});
        }
        return coords;
    }

    private BlockPos searchSectorWithTermination(ServerLevel level, ChunkPos centerChunk, int sectorX, int sectorZ, AtomicBoolean layerComplete, AtomicInteger checkedChunks, int totalSearchArea, int sectorIndex, int totalSectors) {
        if (layerComplete.get()) {
            return null;
        }
        return this.searchSectorComplete(level, centerChunk, sectorX, sectorZ, checkedChunks, totalSearchArea, sectorIndex, totalSectors);
    }

    private BlockPos searchSectorComplete(ServerLevel level, ChunkPos centerChunk, int sectorX, int sectorZ, AtomicInteger checkedChunks, int totalSearchArea, int sectorIndex, int totalSectors) {
        int sectorStartX = centerChunk.f_45578_ + sectorX * 10 - 5;
        int sectorEndX = sectorStartX + 10 - 1;
        int sectorStartZ = centerChunk.f_45579_ + sectorZ * 10 - 5;
        int sectorEndZ = sectorStartZ + 10 - 1;
        sectorStartX = Math.max(sectorStartX, centerChunk.f_45578_ - 300);
        sectorEndX = Math.min(sectorEndX, centerChunk.f_45578_ + 300);
        sectorStartZ = Math.max(sectorStartZ, centerChunk.f_45579_ - 300);
        sectorEndZ = Math.min(sectorEndZ, centerChunk.f_45579_ + 300);
        int sectorWidth = sectorEndX - sectorStartX + 1;
        int sectorHeight = sectorEndZ - sectorStartZ + 1;
        int sectorAreaChunks = sectorWidth * sectorHeight;
        BitSet sectorChecked = new BitSet(sectorAreaChunks);
        ChunkPos sectorCenter = new ChunkPos((sectorStartX + sectorEndX) / 2, (sectorStartZ + sectorEndZ) / 2);
        int sectorRadius = Math.max(sectorWidth, sectorHeight) / 2;
        for (int layer = 0; layer <= sectorRadius; ++layer) {
            BlockPos result = this.searchSectorLayer(level, sectorCenter, layer, sectorStartX, sectorEndX, sectorStartZ, sectorEndZ, sectorChecked);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private BlockPos searchSectorLayer(ServerLevel level, ChunkPos sectorCenter, int layer, int minX, int maxX, int minZ, int maxZ, BitSet sectorChecked) {
        int z;
        BlockPos result;
        ChunkPos candidate;
        int x;
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        int sectorWidth = maxX - minX + 1;
        int sectorHeight = maxZ - minZ + 1;
        if (layer == 0) {
            if (this.isInSectorBounds(sectorCenter, minX, maxX, minZ, maxZ) && this.isSectorChunkUnchecked(sectorCenter, minX, minZ, sectorChecked, sectorWidth, sectorHeight)) {
                this.setSectorChunkChecked(sectorCenter, minX, minZ, sectorChecked, sectorWidth, sectorHeight);
                return this.checkPotentialCenter(level, sectorCenter);
            }
            return null;
        }
        for (x = -layer; x <= layer; ++x) {
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            candidate = new ChunkPos(sectorCenter.f_45578_ + x, sectorCenter.f_45579_ + layer);
            if (!this.isInSectorBounds(candidate, minX, maxX, minZ, maxZ) || !this.isSectorChunkUnchecked(candidate, minX, minZ, sectorChecked, sectorWidth, sectorHeight)) continue;
            this.setSectorChunkChecked(candidate, minX, minZ, sectorChecked, sectorWidth, sectorHeight);
            result = this.checkPotentialCenter(level, candidate);
            if (result == null) continue;
            return result;
        }
        for (z = layer - 1; z >= -layer; --z) {
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            candidate = new ChunkPos(sectorCenter.f_45578_ + layer, sectorCenter.f_45579_ + z);
            if (!this.isInSectorBounds(candidate, minX, maxX, minZ, maxZ) || !this.isSectorChunkUnchecked(candidate, minX, minZ, sectorChecked, sectorWidth, sectorHeight)) continue;
            this.setSectorChunkChecked(candidate, minX, minZ, sectorChecked, sectorWidth, sectorHeight);
            result = this.checkPotentialCenter(level, candidate);
            if (result == null) continue;
            return result;
        }
        for (x = layer - 1; x >= -layer; --x) {
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            candidate = new ChunkPos(sectorCenter.f_45578_ + x, sectorCenter.f_45579_ - layer);
            if (!this.isInSectorBounds(candidate, minX, maxX, minZ, maxZ) || !this.isSectorChunkUnchecked(candidate, minX, minZ, sectorChecked, sectorWidth, sectorHeight)) continue;
            this.setSectorChunkChecked(candidate, minX, minZ, sectorChecked, sectorWidth, sectorHeight);
            result = this.checkPotentialCenter(level, candidate);
            if (result == null) continue;
            return result;
        }
        for (z = -layer + 1; z <= layer - 1; ++z) {
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            candidate = new ChunkPos(sectorCenter.f_45578_ - layer, sectorCenter.f_45579_ + z);
            if (!this.isInSectorBounds(candidate, minX, maxX, minZ, maxZ) || !this.isSectorChunkUnchecked(candidate, minX, minZ, sectorChecked, sectorWidth, sectorHeight)) continue;
            this.setSectorChunkChecked(candidate, minX, minZ, sectorChecked, sectorWidth, sectorHeight);
            result = this.checkPotentialCenter(level, candidate);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private boolean isInSectorBounds(ChunkPos pos, int minX, int maxX, int minZ, int maxZ) {
        return pos.f_45578_ >= minX && pos.f_45578_ <= maxX && pos.f_45579_ >= minZ && pos.f_45579_ <= maxZ;
    }

    private boolean isSectorChunkUnchecked(ChunkPos chunk, int sectorMinX, int sectorMinZ, BitSet sectorChecked, int sectorWidth, int sectorHeight) {
        int x = chunk.f_45578_ - sectorMinX;
        int z = chunk.f_45579_ - sectorMinZ;
        if (x < 0 || z < 0 || x >= sectorWidth || z >= sectorHeight) {
            return false;
        }
        int index = z * sectorWidth + x;
        int sectorAreaChunks = sectorWidth * sectorHeight;
        if (index < 0 || index >= sectorAreaChunks) {
            return false;
        }
        return !sectorChecked.get(index);
    }

    private void setSectorChunkChecked(ChunkPos chunk, int sectorMinX, int sectorMinZ, BitSet sectorChecked, int sectorWidth, int sectorHeight) {
        int x = chunk.f_45578_ - sectorMinX;
        int z = chunk.f_45579_ - sectorMinZ;
        if (x < 0 || z < 0 || x >= sectorWidth || z >= sectorHeight) {
            return;
        }
        int index = z * sectorWidth + x;
        int sectorAreaChunks = sectorWidth * sectorHeight;
        if (index >= 0 && index < sectorAreaChunks) {
            sectorChecked.set(index);
        }
    }

    private BlockPos checkPotentialCenter(ServerLevel level, ChunkPos centerChunk) {
        return this.verifyStructureExists(level, centerChunk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockPos verifyStructureExists(ServerLevel level, ChunkPos chunk) {
        try {
            BlockPos result;
            HolderSet<Structure> structureSet = StructureSearchEngine.getOrInitStructureSet(level);
            if (structureSet == null) {
                return null;
            }
            BlockPos chunkCenter = new BlockPos(chunk.m_45604_() + 8, 64, chunk.m_45605_() + 8);
            CompletableFuture<BlockPos> verificationFuture = CompletableFuture.supplyAsync(() -> STRUCTURE_CHECK_LOCK.executeWithLock(level, () -> {
                Pair structureResult = level.m_7726_().m_8481_().m_223037_(level, structureSet, chunkCenter, 2, false);
                return structureResult != null ? (BlockPos)structureResult.getFirst() : null;
            }), VERIFICATION_EXECUTOR);
            try {
                result = verificationFuture.get(600L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                verificationFuture.cancel(true);
                return null;
            }
            catch (Exception e) {
                return null;
            }
            if (result != null) {
                HiddenRetreatStructure.GENERATED_DIMENSIONS.add(level.m_7328_());
            }
            return result;
        }
        catch (Exception e) {
            Object object = STRUCTURE_SET_LOCK;
            synchronized (object) {
                cachedStructureSet = null;
            }
            Global.LOGGER.error("\u7ed3\u6784\u9a8c\u8bc1\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HolderSet<Structure> getOrInitStructureSet(ServerLevel level) {
        if (cachedStructureSet == null) {
            Object object = STRUCTURE_SET_LOCK;
            synchronized (object) {
                if (cachedStructureSet == null) {
                    try {
                        Registry structureRegistry = level.m_9598_().m_175515_(Registries.f_256944_);
                        Holder.Reference structureHolder = structureRegistry.m_246971_(HIDDEN_RETREAT_KEY);
                        cachedStructureSet = HolderSet.m_205809_((Holder[])new Holder[]{structureHolder});
                    }
                    catch (Exception e) {
                        Global.LOGGER.error("\u521d\u59cb\u5316\u7ed3\u6784\u96c6\u5931\u8d25", (Throwable)e);
                        return null;
                    }
                }
            }
        }
        return cachedStructureSet;
    }
}

