/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.item.bauble.woundRimeBlade;

import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.Config;
import com.github.yimeng261.maidspell.item.MaidSpellItems;
import com.github.yimeng261.maidspell.spell.manager.BaubleStateManager;
import com.github.yimeng261.maidspell.utils.TrueDamageUtil;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import oshi.util.tuples.Pair;

@Mod.EventBusSubscriber(modid="touhou_little_maid_spell")
public class WoundRimeBladeBauble
implements IMaidBauble {
    private static final ConcurrentHashMap<UUID, ConcurrentHashMap<LivingEntity, Pair<Float, Integer>>> maidWoundRimeBladeMap = new ConcurrentHashMap();

    public WoundRimeBladeBauble() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void onTakeOff(EntityMaid maid, ItemStack baubleItem) {
        maidWoundRimeBladeMap.remove(maid.m_20148_());
    }

    public static void updateWoundRimeMap(EntityMaid maid, LivingEntity entity, float damage) {
        if (!BaubleStateManager.hasBauble(maid, MaidSpellItems.WOUND_RIME_BLADE)) {
            return;
        }
        if (maidWoundRimeBladeMap.containsKey(maid.m_20148_())) {
            Pair<Float, Integer> record;
            float recordHealth;
            if (entity instanceof Player || entity instanceof EntityMaid) {
                return;
            }
            ConcurrentHashMap<LivingEntity, Pair<Float, Integer>> map = maidWoundRimeBladeMap.get(maid.m_20148_());
            float nowHealth = entity.m_21223_();
            if (nowHealth > (recordHealth = ((Float)(record = map.getOrDefault(entity, (Pair<Float, Integer>)new Pair((Object)Float.valueOf(nowHealth), (Object)Config.woundRimeBladeRecordTimes))).getA()).floatValue())) {
                TrueDamageUtil.setNewHealth(entity, recordHealth, (LivingEntity)maid);
            }
            float newHealth = Math.min(recordHealth, nowHealth) - damage;
            map.put(entity, (Pair<Float, Integer>)new Pair((Object)Float.valueOf(newHealth), (Object)((Integer)record.getB() + Config.woundRimeBladeRecordTimes)));
        }
    }

    public static boolean handleWoundRimeMap(LivingEntity entity, float health) {
        AtomicBoolean shouldCancel = new AtomicBoolean(false);
        maidWoundRimeBladeMap.forEach((uuid, map) -> {
            if (!map.containsKey(entity)) {
                return;
            }
            map.computeIfPresent(entity, (k, record) -> new Pair((Object)Float.valueOf(health), (Object)((Integer)record.getB() - 1)));
            shouldCancel.set(true);
        });
        return shouldCancel.get();
    }

    public void onTick(EntityMaid maid, ItemStack baubleItem) {
        ConcurrentHashMap map = maidWoundRimeBladeMap.computeIfAbsent(maid.m_20148_(), k -> new ConcurrentHashMap());
        map.forEach((entity, record) -> {
            if (!entity.m_6084_() || (Integer)record.getB() == 0) {
                map.remove(entity);
            }
        });
    }
}

