/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.item.bauble.spellCore;

import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

public class SpellEnhancementBauble
implements IMaidBauble {
    private static final ArrayList<AttributeConfig> ATTRIBUTES = new ArrayList();
    private static final HashMap<UUID, HashMap<String, Double>> playerAttributeValues = new HashMap();
    private static final Logger LOGGER = LogUtils.getLogger();

    private static void initializeAttributes() {
        ForgeRegistries.ATTRIBUTES.forEach(attribute -> {
            if (attribute.m_22087_().startsWith("attribute.irons_spellbooks.")) {
                double defaultValue = attribute.m_22082_();
                ATTRIBUTES.add(new AttributeConfig((Attribute)attribute, defaultValue, attribute.m_22087_().replace("attribute.irons_spellbooks.", "")));
            }
        });
    }

    public void onTick(EntityMaid maid, ItemStack baubleItem) {
        if (maid.m_9236_().f_46443_ || maid.f_19797_ % 40 != 0) {
            return;
        }
        LivingEntity owner = maid.m_269323_();
        if (owner instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)owner;
            this.updateMaidEnhancements(maid, player);
        }
    }

    private void updateMaidEnhancements(EntityMaid maid, ServerPlayer player) {
        for (AttributeConfig config : ATTRIBUTES) {
            double playerValue = player.m_21133_(config.attribute);
            HashMap attributeValues = playerAttributeValues.computeIfAbsent(player.m_20148_(), k -> new HashMap());
            if (attributeValues.get(config.attributeName) != null && (Double)attributeValues.get(config.attributeName) == playerValue) continue;
            attributeValues.put(config.attributeName, playerValue);
            double bonus = Math.max(0.0, playerValue - config.defaultValue);
            AttributeInstance maidAttr = maid.m_21051_(config.attribute);
            UUID uuid = new UUID("touhou_little_maid_spell".hashCode(), config.attribute.m_22087_().hashCode());
            AttributeModifier modifier = new AttributeModifier(uuid, "yimeng" + config.attributeName, bonus, AttributeModifier.Operation.ADDITION);
            if (maidAttr == null) {
                return;
            }
            maidAttr.m_22120_(uuid);
            maidAttr.m_22118_(modifier);
        }
    }

    static {
        if (ModList.get().isLoaded("irons_spellbooks")) {
            SpellEnhancementBauble.initializeAttributes();
        }
    }

    private static class AttributeConfig {
        final Attribute attribute;
        final double defaultValue;
        String attributeName;

        AttributeConfig(Attribute attribute, double defaultValue, String attributeName) {
            this.attribute = attribute;
            this.defaultValue = defaultValue;
            this.attributeName = attributeName;
        }
    }
}

