/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.item.bauble.soulBook;

import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.Config;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;
import oshi.util.tuples.Pair;

@Mod.EventBusSubscriber(modid="touhou_little_maid_spell")
public class SoulBookBauble
implements IMaidBauble {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Map<UUID, Integer> lastHurtTimeMap = new HashMap<UUID, Integer>();
    public static final Map<UUID, Integer> maidSoulBookCount = new HashMap<UUID, Integer>();

    public static Pair<Boolean, Float> damageCalc(EntityMaid maid, float originalDamage) {
        UUID maidId = maid.m_20148_();
        int currentTime = maid.f_19797_;
        int lastHurtTime = lastHurtTimeMap.computeIfAbsent(maidId, uuid -> maid.f_19797_);
        int timeDiff = currentTime - lastHurtTime;
        float damageThreshold = Math.min(originalDamage, maid.m_21233_() * (float)Config.soulBookDamageThresholdPercent);
        return new Pair((Object)(timeDiff > Config.soulBookDamageIntervalThreshold ? 1 : 0), (Object)Float.valueOf(damageThreshold));
    }

    public void onPutOn(EntityMaid maid, ItemStack baubleItem) {
        UUID id = maid.m_21805_();
        int count = maidSoulBookCount.getOrDefault(id, 0);
        maidSoulBookCount.put(id, ++count);
    }

    public void onTakeOff(EntityMaid maid, ItemStack baubleItem) {
        UUID maidId = maid.m_20148_();
        lastHurtTimeMap.remove(maidId);
        UUID id = maid.m_21805_();
        int count = maidSoulBookCount.getOrDefault(id, 0);
        maidSoulBookCount.put(id, Math.max(0, count - 1));
    }
}

