/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.dimension;

import com.github.yimeng261.maidspell.MaidSpellMod;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class RetreatDimensionData
extends SavedData {
    private static final String DATA_NAME = "touhou_little_maid_spell_retreat_dimensions";
    private final Map<UUID, DimensionInfo> playerDimensions = new HashMap<UUID, DimensionInfo>();

    public static RetreatDimensionData get(MinecraftServer server) {
        DimensionDataStorage storage = server.m_129783_().m_8895_();
        return (RetreatDimensionData)storage.m_164861_(RetreatDimensionData::load, RetreatDimensionData::new, DATA_NAME);
    }

    public static RetreatDimensionData load(CompoundTag tag) {
        RetreatDimensionData data = new RetreatDimensionData();
        if (tag.m_128425_("PlayerDimensions", 9)) {
            ListTag list = tag.m_128437_("PlayerDimensions", 10);
            for (Tag element : list) {
                CompoundTag dimensionTag = (CompoundTag)element;
                DimensionInfo info = DimensionInfo.load(dimensionTag);
                data.playerDimensions.put(info.playerUUID, info);
            }
        }
        MaidSpellMod.LOGGER.info("Loaded {} retreat dimension records", (Object)data.playerDimensions.size());
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag list = new ListTag();
        for (DimensionInfo info : this.playerDimensions.values()) {
            list.add((Object)info.save());
        }
        tag.m_128365_("PlayerDimensions", (Tag)list);
        MaidSpellMod.LOGGER.debug("Saved {} retreat dimension records", (Object)this.playerDimensions.size());
        return tag;
    }

    public void registerDimension(UUID playerUUID) {
        if (!this.playerDimensions.containsKey(playerUUID)) {
            this.playerDimensions.put(playerUUID, new DimensionInfo(playerUUID));
            this.m_77762_();
            MaidSpellMod.LOGGER.info("Registered new retreat dimension for player: " + String.valueOf(playerUUID));
        } else {
            this.updateAccessTime(playerUUID);
        }
    }

    public void updateAccessTime(UUID playerUUID) {
        DimensionInfo info = this.playerDimensions.get(playerUUID);
        if (info != null) {
            info.updateAccessTime();
            this.m_77762_();
        }
    }

    public boolean hasDimension(UUID playerUUID) {
        return this.playerDimensions.containsKey(playerUUID);
    }

    public DimensionInfo getDimensionInfo(UUID playerUUID) {
        return this.playerDimensions.get(playerUUID);
    }

    public void removeDimension(UUID playerUUID) {
        if (this.playerDimensions.remove(playerUUID) != null) {
            this.m_77762_();
            MaidSpellMod.LOGGER.info("Removed retreat dimension record for player: " + String.valueOf(playerUUID));
        }
    }

    public Map<UUID, DimensionInfo> getAllDimensions() {
        return new HashMap<UUID, DimensionInfo>(this.playerDimensions);
    }

    public void cleanupOldDimensions(long maxInactiveTime) {
        long currentTime = System.currentTimeMillis();
        this.playerDimensions.entrySet().removeIf(entry -> {
            boolean shouldRemove;
            DimensionInfo info = (DimensionInfo)entry.getValue();
            boolean bl = shouldRemove = currentTime - info.lastAccessTime > maxInactiveTime;
            if (shouldRemove) {
                MaidSpellMod.LOGGER.info("Cleaned up inactive retreat dimension for player: " + String.valueOf(entry.getKey()));
            }
            return shouldRemove;
        });
        if (!this.playerDimensions.isEmpty()) {
            this.m_77762_();
        }
    }

    public static class DimensionInfo {
        public final UUID playerUUID;
        public long createdTime;
        public long lastAccessTime;

        public DimensionInfo(UUID playerUUID) {
            this.playerUUID = playerUUID;
            this.lastAccessTime = this.createdTime = System.currentTimeMillis();
        }

        public DimensionInfo(UUID playerUUID, long createdTime, long lastAccessTime) {
            this.playerUUID = playerUUID;
            this.createdTime = createdTime;
            this.lastAccessTime = lastAccessTime;
        }

        public void updateAccessTime() {
            this.lastAccessTime = System.currentTimeMillis();
        }

        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            tag.m_128362_("PlayerUUID", this.playerUUID);
            tag.m_128356_("CreatedTime", this.createdTime);
            tag.m_128356_("LastAccessTime", this.lastAccessTime);
            return tag;
        }

        public static DimensionInfo load(CompoundTag tag) {
            UUID playerUUID = tag.m_128342_("PlayerUUID");
            long createdTime = tag.m_128454_("CreatedTime");
            long lastAccessTime = tag.m_128454_("LastAccessTime");
            return new DimensionInfo(playerUUID, createdTime, lastAccessTime);
        }
    }
}

