/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.dimension;

import com.github.yimeng261.maidspell.MaidSpellMod;
import com.github.yimeng261.maidspell.dimension.RetreatDimensionData;
import com.github.yimeng261.maidspell.dimension.TheRetreatDimension;
import com.github.yimeng261.maidspell.dimension.accessor.MinecraftServerAccessor;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="touhou_little_maid_spell")
public class PlayerRetreatManager {
    private static final Map<UUID, ServerLevel> playerRetreats = new HashMap<UUID, ServerLevel>();

    public static ServerLevel createPlayerRetreat(MinecraftServer server, UUID playerUUID) {
        if (playerRetreats.containsKey(playerUUID)) {
            return playerRetreats.get(playerUUID);
        }
        try {
            ServerLevel newLevel;
            ResourceKey<Level> dimensionKey = TheRetreatDimension.getPlayerRetreatDimension(playerUUID);
            ServerLevel existingLevel = server.m_129880_(dimensionKey);
            if (existingLevel != null) {
                playerRetreats.put(playerUUID, existingLevel);
                RetreatDimensionData data = RetreatDimensionData.get(server);
                data.registerDimension(playerUUID);
                data.updateAccessTime(playerUUID);
                return existingLevel;
            }
            ResourceLocation templateDimension = new ResourceLocation("touhou_little_maid_spell", "the_retreat");
            boolean success = ((MinecraftServerAccessor)server).maidspell$createWorld(dimensionKey, templateDimension);
            if (success && (newLevel = server.m_129880_(dimensionKey)) != null) {
                playerRetreats.put(playerUUID, newLevel);
                RetreatDimensionData data = RetreatDimensionData.get(server);
                data.registerDimension(playerUUID);
                MaidSpellMod.LOGGER.info("Successfully created retreat dimension for player: " + String.valueOf(playerUUID));
                return newLevel;
            }
            MaidSpellMod.LOGGER.error("Failed to create retreat dimension for player: " + String.valueOf(playerUUID));
            return null;
        }
        catch (Exception e) {
            MaidSpellMod.LOGGER.error("Failed to create retreat dimension for player: " + String.valueOf(playerUUID), (Throwable)e);
            return null;
        }
    }

    public static ServerLevel getOrCreatePlayerRetreat(MinecraftServer server, UUID playerUUID) {
        ResourceKey<Level> dimensionKey = TheRetreatDimension.getPlayerRetreatDimension(playerUUID);
        ServerLevel cached = playerRetreats.get(playerUUID);
        if (cached != null && !cached.m_5776_()) {
            RetreatDimensionData data = RetreatDimensionData.get(server);
            data.updateAccessTime(playerUUID);
            return cached;
        }
        ServerLevel existing = server.m_129880_(dimensionKey);
        if (existing != null) {
            playerRetreats.put(playerUUID, existing);
            RetreatDimensionData data = RetreatDimensionData.get(server);
            data.updateAccessTime(playerUUID);
            return existing;
        }
        return PlayerRetreatManager.createPlayerRetreat(server, playerUUID);
    }

    public static void clearCache() {
        playerRetreats.clear();
        MaidSpellMod.LOGGER.info("Cleared player retreat cache");
    }

    public static void removePlayerRetreat(MinecraftServer server, UUID playerUUID) {
        ResourceKey<Level> dimensionKey = TheRetreatDimension.getPlayerRetreatDimension(playerUUID);
        playerRetreats.remove(playerUUID);
        RetreatDimensionData data = RetreatDimensionData.get(server);
        data.removeDimension(playerUUID);
        ((MinecraftServerAccessor)server).maidspell$removeWorld(dimensionKey);
        MaidSpellMod.LOGGER.info("Removed retreat dimension for player: " + String.valueOf(playerUUID));
    }

    @SubscribeEvent
    public static void onServerAboutToStart(ServerAboutToStartEvent event) {
        PlayerRetreatManager.clearCache();
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        MinecraftServer server = event.getServer();
        RetreatDimensionData data = RetreatDimensionData.get(server);
        for (UUID playerUUID : data.getAllDimensions().keySet()) {
            ResourceKey<Level> dimensionKey = TheRetreatDimension.getPlayerRetreatDimension(playerUUID);
            ServerLevel existingLevel = server.m_129880_(dimensionKey);
            if (existingLevel != null) {
                playerRetreats.put(playerUUID, existingLevel);
                MaidSpellMod.LOGGER.info("Loaded existing retreat dimension for player: {}", (Object)playerUUID);
                continue;
            }
            MaidSpellMod.LOGGER.info("Recreating retreat dimension for player: {}", (Object)playerUUID);
            ServerLevel recreatedLevel = PlayerRetreatManager.createPlayerRetreat(server, playerUUID);
            if (recreatedLevel != null) {
                MaidSpellMod.LOGGER.info("Successfully recreated retreat dimension for player: {}", (Object)playerUUID);
                continue;
            }
            MaidSpellMod.LOGGER.error("Failed to recreate retreat dimension for player: {}", (Object)playerUUID);
        }
        MaidSpellMod.LOGGER.info("Loaded {} retreat dimensions from save data", (Object)playerRetreats.size());
    }
}

