/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.debug;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.spell.data.MaidIronsSpellData;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.logging.LogUtils;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import org.slf4j.Logger;

@Mod.EventBusSubscriber
public class MaidSpellCommand {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final SuggestionProvider<CommandSourceStack> SPELL_SUGGESTIONS = (context, builder) -> {
        Collection spellIds = ((IForgeRegistry)SpellRegistry.REGISTRY.get()).getValues().stream().filter(spell -> spell != SpellRegistry.none()).map(AbstractSpell::getSpellId).collect(Collectors.toList());
        return SharedSuggestionProvider.m_82970_((Iterable)spellIds, (SuggestionsBuilder)builder);
    };

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"maidspell").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"spell", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SPELL_SUGGESTIONS).executes(context -> MaidSpellCommand.executeSpell((CommandContext<CommandSourceStack>)context, 1))).then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1, (int)10)).executes(context -> MaidSpellCommand.executeSpell((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"level")))))));
    }

    private static int executeSpell(CommandContext<CommandSourceStack> context, int level) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91461_(context, (String)"targets");
        ResourceLocation spellId = ResourceLocationArgument.m_107011_(context, (String)"spell");
        AbstractSpell spell = SpellRegistry.getSpell((ResourceLocation)spellId);
        if (spell == null || spell == SpellRegistry.none()) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("\u672a\u627e\u5230\u6cd5\u672f: " + String.valueOf(spellId))));
            return 0;
        }
        int successCount = 0;
        int failCount = 0;
        for (Entity entity : targets) {
            if (!(entity instanceof EntityMaid)) {
                ++failCount;
                continue;
            }
            EntityMaid maid = (EntityMaid)entity;
            try {
                MaidSpellCommand.castSpellOnMaid(maid, spell, level);
                ++successCount;
                LOGGER.debug("\u5973\u4ec6 {} \u65bd\u653e\u4e86\u6cd5\u672f {} (\u7b49\u7ea7 {})", new Object[]{maid.m_20148_(), spellId, level});
            }
            catch (Exception e) {
                LOGGER.error("\u5973\u4ec6 {} \u65bd\u653e\u6cd5\u672f {} \u5931\u8d25: {}", new Object[]{maid.m_20148_(), spellId, e.getMessage()});
                ++failCount;
            }
        }
        if (successCount > 0) {
            int success = successCount;
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)String.format("\u6210\u529f\u8ba9 %d \u4e2a\u5973\u4ec6\u65bd\u653e %s (\u7b49\u7ea7 %d)", success, spellId, level)), true);
        }
        if (failCount > 0) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)String.format("%d \u4e2a\u76ee\u6807\u4e0d\u662f\u5973\u4ec6\u6216\u65bd\u6cd5\u5931\u8d25", failCount)));
        }
        return successCount;
    }

    private static void castSpellOnMaid(EntityMaid maid, AbstractSpell spell, int level) {
        MaidIronsSpellData data = MaidIronsSpellData.getOrCreate(maid);
        LivingEntity target = maid.m_5448_();
        if (target != null) {
            data.setTarget(target);
        }
        SpellData spellData = new SpellData(spell, level);
        MagicData magicData = data.getMagicData();
        if (!spell.checkPreCastConditions(maid.m_9236_(), level, (LivingEntity)maid, magicData)) {
            LOGGER.debug("\u6cd5\u672f {} \u524d\u7f6e\u6761\u4ef6\u68c0\u67e5\u5931\u8d25", (Object)spell.getSpellId());
        }
        int effectiveCastTime = spell.getEffectiveCastTime(level, (LivingEntity)maid);
        CastSource castSource = CastSource.COMMAND;
        magicData.initiateCast(spell, level, effectiveCastTime, castSource, "command");
        spell.onServerPreCast(maid.m_9236_(), level, (LivingEntity)maid, magicData);
        data.setCurrentCastingSpell(spellData);
        data.setCachedCastSource(castSource);
        data.setCasting(true);
        if (spell.getCastType() == CastType.INSTANT || effectiveCastTime <= 0) {
            spell.onCast(maid.m_9236_(), level, (LivingEntity)maid, castSource, magicData);
            spell.onServerCastComplete(maid.m_9236_(), level, (LivingEntity)maid, magicData, false);
            data.resetCastingState();
        }
    }
}

