/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.client.event;

import com.github.tartaricacid.touhoulittlemaid.api.event.client.MaidContainerGuiEvent;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.AbstractMaidContainerGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.backpack.IBackpackContainerScreen;
import com.github.yimeng261.maidspell.client.gui.EnderPocketScreen;
import com.github.yimeng261.maidspell.item.MaidSpellItems;
import com.github.yimeng261.maidspell.item.bauble.enderPocket.EnderPocketService;
import com.github.yimeng261.maidspell.network.NetworkHandler;
import com.github.yimeng261.maidspell.network.message.EnderPocketMessage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="touhou_little_maid_spell", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class MaidBackpackEnderPocketIntegration {
    private static final ResourceLocation ENDER_POCKET_TEXTURE = new ResourceLocation("touhou_little_maid_spell", "textures/gui/ender_pocket.png");
    private static final int PANEL_WIDTH = 90;
    private static final int PANEL_HEIGHT = 153;
    private static final int TOGGLE_BUTTON_SIZE = 20;
    private static List<EnderPocketService.EnderPocketMaidInfo> currentMaidInfos = new ArrayList<EnderPocketService.EnderPocketMaidInfo>();
    private static final int PANEL_OFFSET_X = -91;
    private static final int PANEL_OFFSET_Y = 30;
    private static final int TASK_LIST_OFFSET_X = -93;
    private static final Minecraft mc = Minecraft.m_91087_();
    private static long lastRequestTime = 0L;
    private static final long REQUEST_COOLDOWN = 1000L;
    private static boolean dataRequested = false;
    private static Screen lastScreen = null;
    private static boolean isEnderPocketPanelEnabled = true;

    private static int calculatePanelX(int guiLeft, AbstractMaidContainerGui<?> gui) {
        int baseOffset = -91;
        if (gui.isTaskListOpen()) {
            baseOffset -= 93;
        }
        return guiLeft + baseOffset;
    }

    private static int calculatePanelY(int guiTop) {
        return guiTop + 30;
    }

    @SubscribeEvent
    public static void onMaidGuiInit(MaidContainerGuiEvent.Init event) {
        if (event.getGui() instanceof IBackpackContainerScreen) {
            MaidBackpackEnderPocketIntegration.requestEnderPocketDataThrottled();
            MaidBackpackEnderPocketIntegration.addEnderPocketToggleButton(event);
            if (isEnderPocketPanelEnabled) {
                MaidBackpackEnderPocketIntegration.addMaidButtons(event);
            }
        }
    }

    private static void addEnderPocketToggleButton(MaidContainerGuiEvent.Init event) {
        int panelX = MaidBackpackEnderPocketIntegration.calculatePanelX(event.getLeftPos(), event.getGui());
        int panelY = MaidBackpackEnderPocketIntegration.calculatePanelY(event.getTopPos());
        int buttonX = panelX + 90 - 20 - 2;
        int buttonY = panelY + 153 + 4;
        EnderPocketToggleButton toggleButton = new EnderPocketToggleButton(buttonX, buttonY, 20, 20, isEnderPocketPanelEnabled){

            public void m_5691_() {
                isEnderPocketPanelEnabled = this.isStateTriggered = !this.isStateTriggered;
                if (MaidBackpackEnderPocketIntegration.mc.f_91080_ != null) {
                    MaidBackpackEnderPocketIntegration.mc.f_91080_.m_6575_(mc, mc.m_91268_().m_85445_(), mc.m_91268_().m_85446_());
                }
            }
        };
        event.addButton("ender_pocket_toggle", (AbstractWidget)toggleButton);
    }

    private static void addMaidButtons(MaidContainerGuiEvent.Init event) {
        int panelX = MaidBackpackEnderPocketIntegration.calculatePanelX(event.getLeftPos(), event.getGui());
        int panelY = MaidBackpackEnderPocketIntegration.calculatePanelY(event.getTopPos());
        int buttonWidth = 78;
        int buttonHeight = 16;
        int startY = panelY + 16;
        for (int i = 0; i < Math.min(currentMaidInfos.size(), 8); ++i) {
            EnderPocketService.EnderPocketMaidInfo maidInfo = currentMaidInfos.get(i);
            int buttonX = panelX + 6;
            int buttonY = startY + i * buttonHeight;
            EnderPocketScreen.TransparentButton maidButton = new EnderPocketScreen.TransparentButton(buttonX, buttonY, buttonWidth, buttonHeight, (Component)Component.m_237113_((String)maidInfo.maidName()), button -> MaidBackpackEnderPocketIntegration.handleMaidButtonClick(maidInfo.maidEntityId(), event.getGui()));
            event.addButton("maid_button_" + i, (AbstractWidget)maidButton);
        }
    }

    @SubscribeEvent
    public static void onMaidGuiRender(MaidContainerGuiEvent.Render event) {
        if (event.getGui() instanceof IBackpackContainerScreen) {
            if (isEnderPocketPanelEnabled) {
                MaidBackpackEnderPocketIntegration.renderEnderPocketPanel(event.getGraphics(), event.getLeftPos(), event.getTopPos(), event.getMouseX(), event.getMouseY(), event.getGui());
            }
            MaidBackpackEnderPocketIntegration.renderToggleButton(event.getGraphics(), event.getLeftPos(), event.getTopPos(), event.getGui());
        }
    }

    private static void renderToggleButton(GuiGraphics graphics, int guiLeft, int guiTop, AbstractMaidContainerGui<?> gui) {
    }

    @SubscribeEvent
    public static void onMaidGuiTooltip(MaidContainerGuiEvent.Tooltip event) {
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Screen currentScreen = MaidBackpackEnderPocketIntegration.mc.f_91080_;
            if (lastScreen instanceof IBackpackContainerScreen && !(currentScreen instanceof IBackpackContainerScreen)) {
                MaidBackpackEnderPocketIntegration.clearCache();
            }
            lastScreen = currentScreen;
        }
    }

    private static void requestEnderPocketDataThrottled() {
        long currentTime = System.currentTimeMillis();
        if (dataRequested && currentTime - lastRequestTime < 1000L) {
            return;
        }
        if (currentMaidInfos.isEmpty() || currentTime - lastRequestTime >= 1000L) {
            MaidBackpackEnderPocketIntegration.requestEnderPocketData();
            lastRequestTime = currentTime;
            dataRequested = true;
        }
    }

    private static void requestEnderPocketData() {
        NetworkHandler.CHANNEL.sendToServer((Object)EnderPocketMessage.requestMaidListFromBackpack());
    }

    private static void renderEnderPocketPanel(GuiGraphics graphics, int guiLeft, int guiTop, int mouseX, int mouseY, AbstractMaidContainerGui<?> gui) {
        int panelX = MaidBackpackEnderPocketIntegration.calculatePanelX(guiLeft, gui);
        int panelY = MaidBackpackEnderPocketIntegration.calculatePanelY(guiTop);
        RenderSystem.enableBlend();
        graphics.m_280218_(ENDER_POCKET_TEXTURE, panelX, panelY, 0, 0, 90, 153);
        MutableComponent title = Component.m_237115_((String)"gui.maidspell.ender_pocket.title");
        graphics.m_280653_(MaidBackpackEnderPocketIntegration.mc.f_91062_, (Component)title, panelX + 45, panelY + 6, 0x404040);
        if (!currentMaidInfos.isEmpty()) {
            MaidBackpackEnderPocketIntegration.renderMaidButtons(graphics, panelX, panelY, mouseX, mouseY, gui);
        }
        RenderSystem.disableBlend();
    }

    private static void renderMaidButtons(GuiGraphics graphics, int panelX, int panelY, int mouseX, int mouseY, AbstractMaidContainerGui<?> gui) {
        int buttonWidth = 78;
        int buttonHeight = 16;
        int startY = panelY + 16;
        int currentMaidId = gui.getMaid().m_19879_();
        for (int i = 0; i < Math.min(currentMaidInfos.size(), 8); ++i) {
            boolean isCurrentMaid;
            EnderPocketService.EnderPocketMaidInfo maidInfo = currentMaidInfos.get(i);
            int buttonX = panelX + 6;
            int buttonY = startY + i * buttonHeight;
            boolean isHovered = mouseX >= buttonX && mouseX < buttonX + buttonWidth && mouseY >= buttonY && mouseY < buttonY + buttonHeight;
            boolean bl = isCurrentMaid = maidInfo.maidEntityId() == currentMaidId;
            if (isCurrentMaid) {
                graphics.m_280509_(buttonX, buttonY, buttonX + buttonWidth, buttonY + buttonHeight, -2130706688);
                graphics.m_280637_(buttonX, buttonY, buttonWidth, buttonHeight, -256);
            } else if (isHovered) {
                graphics.m_280509_(buttonX, buttonY, buttonX + buttonWidth, buttonY + buttonHeight, -2130706433);
                graphics.m_280637_(buttonX, buttonY, buttonWidth, buttonHeight, -1);
            }
            MutableComponent maidName = Component.m_237113_((String)maidInfo.maidName());
            Minecraft mc = Minecraft.m_91087_();
            int textColor = isCurrentMaid ? 0xFFFF00 : 0xFFFFFF;
            graphics.m_280653_(mc.f_91062_, (Component)maidName, buttonX + buttonWidth / 2, buttonY + (buttonHeight - 8) / 2, textColor);
        }
    }

    private static void handleMaidButtonClick(int maidEntityId, AbstractMaidContainerGui<?> gui) {
        NetworkHandler.CHANNEL.sendToServer((Object)EnderPocketMessage.openMaidInventory(maidEntityId));
    }

    public static void updateEnderPocketData(List<EnderPocketService.EnderPocketMaidInfo> maidInfos) {
        if (maidInfos == null) {
            maidInfos = new ArrayList<EnderPocketService.EnderPocketMaidInfo>();
        }
        if (currentMaidInfos.size() == maidInfos.size()) {
            boolean dataChanged = false;
            for (int i = 0; i < maidInfos.size(); ++i) {
                if (currentMaidInfos.get(i).maidEntityId() == maidInfos.get(i).maidEntityId() && currentMaidInfos.get(i).maidName().equals(maidInfos.get(i).maidName())) continue;
                dataChanged = true;
                break;
            }
            if (!dataChanged) {
                return;
            }
        }
        currentMaidInfos.clear();
        currentMaidInfos.addAll(maidInfos);
        dataRequested = true;
        lastRequestTime = System.currentTimeMillis();
    }

    public static void clearCache() {
        dataRequested = false;
        lastRequestTime = 0L;
    }

    public static void forceRefreshData() {
        dataRequested = false;
        lastRequestTime = 0L;
        MaidBackpackEnderPocketIntegration.requestEnderPocketData();
    }

    public static abstract class EnderPocketToggleButton
    extends AbstractButton {
        protected boolean isStateTriggered;
        private ItemStack enderPocketIcon = null;

        public EnderPocketToggleButton(int x, int y, int width, int height, boolean initialState) {
            super(x, y, width, height, (Component)Component.m_237119_());
            this.isStateTriggered = initialState;
        }

        private ItemStack getEnderPocketIcon() {
            if (this.enderPocketIcon == null) {
                this.enderPocketIcon = new ItemStack((ItemLike)MaidSpellItems.ENDER_POCKET.get());
            }
            return this.enderPocketIcon;
        }

        public void m_87963_(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            int borderColor;
            int bgColor = this.isStateTriggered ? (this.m_274382_() ? -1606353088 : -2144281296) : (this.m_274382_() ? -1602191232 : -2143272896);
            guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, bgColor);
            int n = borderColor = this.isStateTriggered ? -12517568 : -8355712;
            if (this.m_274382_()) {
                borderColor = -1;
            }
            guiGraphics.m_280637_(this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, borderColor);
            int iconX = this.m_252754_() + (this.f_93618_ - 16) / 2;
            int iconY = this.m_252907_() + (this.f_93619_ - 14) / 2;
            guiGraphics.m_280480_(this.getEnderPocketIcon(), iconX, iconY);
        }

        protected void m_168797_(@Nonnull NarrationElementOutput output) {
            this.m_168802_(output);
        }

        public boolean isStateTriggered() {
            return this.isStateTriggered;
        }

        public void setStateTriggered(boolean state) {
            this.isStateTriggered = state;
        }
    }
}

