/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.client.animation;

import com.github.tartaricacid.touhoulittlemaid.api.animation.IMagicCastingState;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.capabilities.magic.SyncedSpellData;

public class MagicCastingAnimateState
implements IMagicCastingState {
    private IMagicCastingState.CastingPhase phase;
    private boolean cancelled;
    private SpellData castingSpell = SpellData.EMPTY;
    private AbstractSpell instantCastSpellType = SpellRegistry.none();
    private boolean clientIsCasting = false;

    public MagicCastingAnimateState(IMagicCastingState.CastingPhase phase) {
        this(phase, false);
    }

    public MagicCastingAnimateState(IMagicCastingState.CastingPhase phase, boolean cancelled) {
        this.phase = phase;
        this.cancelled = cancelled;
    }

    public IMagicCastingState.CastingPhase getCurrentPhase() {
        return this.phase;
    }

    public void setCurrentPhase(IMagicCastingState.CastingPhase phase) {
        this.phase = phase;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public AbstractSpell getInstantCastSpellType() {
        return this.instantCastSpellType;
    }

    public void clearInstantCastSpellType() {
        this.instantCastSpellType = SpellRegistry.none();
        this.phase = IMagicCastingState.CastingPhase.NONE;
    }

    public SpellData getCastingSpell() {
        return this.castingSpell;
    }

    public void updateState(EntityMaid maid, SyncedSpellData syncedSpellData) {
        if (!maid.m_9236_().f_46443_) {
            return;
        }
        boolean oldIsCasting = this.clientIsCasting;
        SpellData lastCastingSpell = this.castingSpell;
        this.castingSpell = new SpellData(SpellRegistry.getSpell((String)syncedSpellData.getCastingSpellId()), syncedSpellData.getCastingSpellLevel());
        this.clientIsCasting = syncedSpellData.isCasting();
        if (this.castingSpell.getSpell() == SpellRegistry.none() && lastCastingSpell.getSpell() == SpellRegistry.none()) {
            if (this.phase != IMagicCastingState.CastingPhase.INSTANT) {
                this.phase = IMagicCastingState.CastingPhase.NONE;
            }
            return;
        }
        if (!this.clientIsCasting && oldIsCasting) {
            this.castingSpell = lastCastingSpell;
            this.phase = IMagicCastingState.CastingPhase.END;
            this.instantCastSpellType = lastCastingSpell.getSpell();
        } else if (this.clientIsCasting && !oldIsCasting) {
            this.phase = IMagicCastingState.CastingPhase.START;
            if (this.castingSpell.getSpell().getCastType() == CastType.INSTANT) {
                this.instantCastSpellType = this.castingSpell.getSpell();
                this.castingSpell = SpellData.EMPTY;
                this.phase = IMagicCastingState.CastingPhase.INSTANT;
            } else {
                this.instantCastSpellType = SpellRegistry.none();
            }
        } else if (this.clientIsCasting) {
            this.phase = IMagicCastingState.CastingPhase.CASTING;
        } else if (this.phase != IMagicCastingState.CastingPhase.END) {
            this.castingSpell = SpellData.EMPTY;
            this.phase = IMagicCastingState.CastingPhase.NONE;
            this.instantCastSpellType = SpellRegistry.none();
        }
    }
}

