/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.api;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.api.IMaidSpellData;
import com.github.yimeng261.maidspell.api.ISpellBookProvider;
import com.github.yimeng261.maidspell.network.NetworkHandler;
import com.github.yimeng261.maidspell.network.message.SpellSyncMessage;
import com.github.yimeng261.maidspell.spell.manager.SpellBookManager;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.network.PacketDistributor;
import org.slf4j.Logger;

public class SpellSyncAPI {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void syncMaidSpellsToAllClients(EntityMaid maid) {
        if (maid == null) {
            LOGGER.warn("\u5c1d\u8bd5\u540c\u6b65\u7a7a\u5973\u4ec6\u7684\u6cd5\u672f");
            return;
        }
        Map<String, String> spellMap = SpellSyncAPI.collectSpellsFromMaid(maid);
        SpellSyncMessage message = new SpellSyncMessage(maid.m_20148_(), spellMap);
        NetworkHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)message);
    }

    public static Map<String, String> collectSpellsFromMaid(EntityMaid maid) {
        HashMap<String, String> spellMap = new HashMap<String, String>();
        if (maid == null) {
            return spellMap;
        }
        for (String modId : SpellBookManager.getLoadedMods()) {
            ISpellBookProvider<?, ?> provider = SpellBookManager.getProvider(modId);
            String spellName = SpellSyncAPI.collectSpellFromProvider(provider, maid, modId);
            if (spellName == null || spellName.isEmpty()) continue;
            spellMap.put(modId, spellName);
        }
        return spellMap;
    }

    private static String collectSpellFromProvider(ISpellBookProvider<?, ?> provider, EntityMaid maid, String modId) {
        try {
            IMaidSpellData maidSpellData;
            String currentSpellId;
            Object spellData = provider.getData(maid);
            if (spellData == null) {
                return null;
            }
            if (spellData instanceof IMaidSpellData && (currentSpellId = (maidSpellData = (IMaidSpellData)spellData).getCurrentSpellId()) != null && !currentSpellId.isEmpty()) {
                return currentSpellId;
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4ece\u63d0\u4f9b\u8005\u6536\u96c6\u6cd5\u672f\u65f6\u51fa\u9519 (\u6a21\u7ec4: {}): {}", (Object)modId, (Object)e.getMessage());
        }
        return null;
    }
}

