/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.api;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.api.IMaidSpellData;
import com.github.yimeng261.maidspell.api.SpellSyncAPI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public abstract class ISpellBookProvider<T extends IMaidSpellData, S> {
    protected final Function<UUID, T> dataFactory;
    protected final Class<S> spellClass;

    protected ISpellBookProvider(Function<UUID, T> dataFactory, Class<S> spellClass) {
        this.dataFactory = dataFactory;
        this.spellClass = spellClass;
    }

    protected List<S> collectSpellFromAvailableSpellBooks(EntityMaid maid) {
        ArrayList<S> spells = new ArrayList<S>();
        for (ItemStack spellBook : ((IMaidSpellData)this.getData(maid)).getSpellBooks()) {
            spells.addAll(this.collectSpellFromSingleSpellBook(spellBook, maid));
        }
        return spells;
    }

    protected abstract List<S> collectSpellFromSingleSpellBook(ItemStack var1, EntityMaid var2);

    protected T getData(EntityMaid maid) {
        if (maid == null) {
            return null;
        }
        return (T)((IMaidSpellData)this.dataFactory.apply(maid.m_20148_()));
    }

    public void handleItemStack(EntityMaid maid, ItemStack spellBook, boolean isAddOperation) {
        if (maid.m_9236_().f_46443_) {
            return;
        }
        if (isAddOperation) {
            if (this.isSpellBook(spellBook)) {
                ((IMaidSpellData)this.getData(maid)).addSpellBook(spellBook, maid);
            }
        } else {
            ((IMaidSpellData)this.getData(maid)).removeSpellBook(spellBook);
        }
    }

    public void clearSpellItems(EntityMaid maid) {
        ((IMaidSpellData)this.getData(maid)).clearSpellBooks();
        this.stopCasting(maid);
    }

    public abstract boolean isSpellBook(ItemStack var1);

    public void castSpell(EntityMaid entityMaid) {
        T spellData = this.getData(entityMaid);
        if (((IMaidSpellData)spellData).getSpellBooks().isEmpty() || ((IMaidSpellData)spellData).isCasting()) {
            return;
        }
        this.initiateCasting(entityMaid);
        SpellSyncAPI.syncMaidSpellsToAllClients(entityMaid);
    }

    public void updateCooldown(EntityMaid maid) {
        ((IMaidSpellData)this.getData(maid)).updateCooldowns();
    }

    public void setTarget(EntityMaid maid, LivingEntity target) {
        T data = this.getData(maid);
        if (data != null) {
            ((IMaidSpellData)data).setTarget(target);
        }
    }

    public LivingEntity getTarget(EntityMaid maid) {
        T data = this.getData(maid);
        return data != null ? ((IMaidSpellData)data).getTarget() : null;
    }

    public boolean isCasting(EntityMaid maid) {
        T data = this.getData(maid);
        return data != null && ((IMaidSpellData)data).isCasting();
    }

    protected abstract void initiateCasting(EntityMaid var1);

    public abstract void processContinuousCasting(EntityMaid var1);

    public abstract void stopCasting(EntityMaid var1);
}

