/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.api;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.Global;
import com.github.yimeng261.maidspell.item.MaidSpellItems;
import com.github.yimeng261.maidspell.spell.manager.BaubleStateManager;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;

public abstract class IMaidSpellData {
    protected static final Logger LOGGER = LogUtils.getLogger();
    protected final Map<String, Integer> spellCooldowns = new HashMap<String, Integer>();
    protected LivingEntity target;
    protected final Set<ItemStack> spellBooks = new HashSet<ItemStack>();
    protected final Set<Class<?>> spellBookKinds = new HashSet();
    protected boolean isCasting = false;
    protected String currentSpellId = null;

    public LivingEntity getTarget() {
        return this.target;
    }

    public void setTarget(LivingEntity target) {
        this.target = target;
    }

    public String getCurrentSpellId() {
        return this.currentSpellId;
    }

    public void setCurrentSpellId(String spellId) {
        this.currentSpellId = spellId;
    }

    public static IMaidSpellData getOrCreate(UUID maidUUID) {
        Global.LOGGER.error("should complete getOrCreate method");
        return null;
    }

    public ItemStack getSpellBook() {
        return this.spellBooks.isEmpty() ? ItemStack.f_41583_ : this.spellBooks.iterator().next();
    }

    public Set<ItemStack> getSpellBooks() {
        return this.spellBooks;
    }

    public void addSpellBook(ItemStack spellBook, EntityMaid maid) {
        if (spellBook == null || spellBook.m_41619_()) {
            return;
        }
        if (!BaubleStateManager.hasBauble(maid, MaidSpellItems.SPELL_OVERLIMIT_CORE) && !this.canAddSpellBook(spellBook)) {
            return;
        }
        this.spellBooks.add(spellBook);
        this.spellBookKinds.add(spellBook.m_41720_().getClass());
    }

    protected boolean canAddSpellBook(ItemStack spellBook) {
        Class<?> spellBookClass = spellBook.m_41720_().getClass();
        for (Class<?> spellBookKind : this.spellBookKinds) {
            if (!spellBookKind.isAssignableFrom(spellBookClass) && !spellBookClass.isAssignableFrom(spellBookKind)) continue;
            return false;
        }
        return true;
    }

    public void removeSpellBook(ItemStack spellBook) {
        for (ItemStack spellBookItem : this.spellBooks) {
            if (!ItemStack.m_150942_((ItemStack)spellBookItem, (ItemStack)spellBook)) continue;
            this.spellBooks.remove(spellBookItem);
            this.spellBookKinds.remove(spellBook.m_41720_().getClass());
            return;
        }
    }

    public void clearSpellBooks() {
        this.spellBooks.clear();
        this.spellBookKinds.clear();
    }

    public boolean hasSpellBook(ItemStack spellBook) {
        return this.spellBooks.contains(spellBook);
    }

    public boolean isCasting() {
        return this.isCasting;
    }

    public void setCasting(boolean casting) {
        this.isCasting = casting;
    }

    public void resetCastingState() {
        this.isCasting = false;
        this.target = null;
    }

    public boolean isSpellOnCooldown(String spellId) {
        if (spellId == null) {
            return true;
        }
        int remainingCooldown = this.spellCooldowns.getOrDefault(spellId, 0);
        return remainingCooldown > 0;
    }

    public void setSpellCooldown(String spellId, int cooldownTicks, EntityMaid maid) {
        CoolDown coolDown = new CoolDown(cooldownTicks, maid);
        if (spellId != null) {
            Global.commonCoolDownCalc.forEach(func -> func.apply(coolDown));
            Global.baubleCoolDownCalc.forEach((item, func) -> {
                if (BaubleStateManager.hasBauble(maid, item)) {
                    func.apply(coolDown);
                }
            });
            this.spellCooldowns.put(spellId, coolDown.cooldownticks);
        }
    }

    public int getSpellCooldown(String spellId) {
        return this.spellCooldowns.getOrDefault(spellId, 0);
    }

    public void updateCooldowns() {
        this.spellCooldowns.replaceAll((spellId, cooldown) -> Math.max(0, cooldown - 20));
        this.spellCooldowns.entrySet().removeIf(entry -> (Integer)entry.getValue() <= 0);
    }

    public static class CoolDown {
        public int cooldownticks;
        public EntityMaid maid;

        public CoolDown(int cooldownTicks, EntityMaid maid) {
            this.cooldownticks = cooldownTicks;
            this.maid = maid;
        }
    }
}

