/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell;

import com.github.yimeng261.maidspell.Config;
import com.github.yimeng261.maidspell.entity.MaidSpellEntities;
import com.github.yimeng261.maidspell.event.MaidSpellEventHandler;
import com.github.yimeng261.maidspell.item.MaidSpellCreativeTab;
import com.github.yimeng261.maidspell.item.MaidSpellItems;
import com.github.yimeng261.maidspell.item.bauble.blueNote.contianer.MaidSpellContainers;
import com.github.yimeng261.maidspell.network.NetworkHandler;
import com.github.yimeng261.maidspell.sound.MaidSpellSounds;
import com.github.yimeng261.maidspell.worldgen.MaidSpellStructurePieceTypes;
import com.github.yimeng261.maidspell.worldgen.MaidSpellStructures;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="touhou_little_maid_spell")
public class MaidSpellMod {
    public static final String MOD_ID = "touhou_little_maid_spell";
    public static final String MOD_NAME = "Touhou Little Maid: Spell";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Touhou Little Maid: Spell");

    public MaidSpellMod() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        modBus.addListener(this::setup);
        forgeBus.register((Object)this);
        ForgeChunkManager.setForcedChunkLoadingCallback((String)MOD_ID, (level, ticketHelper) -> {});
        LOGGER.info("ForgeChunkManager \u56de\u8c03\u5df2\u6ce8\u518c");
        forgeBus.register(MaidSpellEventHandler.class);
        MaidSpellItems.register(modBus);
        MaidSpellCreativeTab.register(modBus);
        MaidSpellContainers.register(modBus);
        MaidSpellSounds.SOUNDS.register(modBus);
        MaidSpellEntities.register(modBus);
        MaidSpellStructures.STRUCTURE_TYPES.register(modBus);
        MaidSpellStructurePieceTypes.STRUCTURE_PIECE_TYPES.register(modBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            NetworkHandler.registerMessages();
            if (this.checkDependencies()) {
                LOGGER.info("Dependencies verified - initialization complete");
            }
        });
    }

    private boolean checkDependencies() {
        return this.checkModLoaded("touhou_little_maid");
    }

    private boolean checkModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }
}

