/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.tileentities;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.orientation.BlockOrientation;
import appeng.api.orientation.RelativeSide;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalBlockPos;
import appeng.blockentity.grid.AENetworkInvBlockEntity;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.decorative.solid.BuddingCertusQuartzBlock;
import appeng.util.Platform;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import appeng.util.inv.filter.AEItemDefinitionFilter;
import appeng.util.inv.filter.IAEItemFilter;
import com.glodblock.github.extendedae.common.EPPItemAndBlock;
import com.glodblock.github.extendedae.xmod.jade.JadeDataProvider;
import com.glodblock.github.glodium.util.GlodUtil;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TileCrystalFixer
extends AENetworkInvBlockEntity
implements IGridTickable,
JadeDataProvider {
    private int progress = 0;
    private final AppEngInternalInventory inv = new AppEngInternalInventory((InternalInventoryHost)this, 1);

    public TileCrystalFixer(BlockPos pos, BlockState blockState) {
        super(GlodUtil.getTileType(TileCrystalFixer.class, TileCrystalFixer::new, (Block)EPPItemAndBlock.CRYSTAL_FIXER), pos, blockState);
        this.getMainNode().setFlags(new GridFlags[0]).setIdlePowerUsage(0.0).addService(IGridTickable.class, (IGridNodeService)this);
        this.inv.setFilter((IAEItemFilter)new AEItemDefinitionFilter(AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED));
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(2, 10, false, false);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.doWork(ticksSinceLastCall)) {
            return TickRateModulation.FASTER;
        }
        return TickRateModulation.SLOWER;
    }

    private boolean needGrowth(BlockState blockState) {
        return blockState.m_60713_(AEBlocks.DAMAGED_BUDDING_QUARTZ.block()) || blockState.m_60713_(AEBlocks.CHIPPED_BUDDING_QUARTZ.block()) || blockState.m_60713_(AEBlocks.QUARTZ_BLOCK.block());
    }

    private boolean doWork(int ticksSinceLastCall) {
        if (this.m_58904_() == null || !this.checkFuel()) {
            return false;
        }
        BlockPos blockPos = this.m_58899_().m_121955_(this.getFront().m_122436_());
        BlockState blockState = this.m_58904_().m_8055_(blockPos);
        RandomSource random = this.m_58904_().m_213780_();
        if (this.needGrowth(blockState)) {
            if (this.userPower(ticksSinceLastCall * 50) > 0L) {
                this.progress += random.m_188503_(5);
                this.consumeFuel(random);
            }
            if (this.progress >= 100) {
                if (blockState.m_60713_(AEBlocks.QUARTZ_BLOCK.block())) {
                    this.m_58904_().m_46597_(blockPos, ((BuddingCertusQuartzBlock)AEBlocks.DAMAGED_BUDDING_QUARTZ.block()).m_49966_());
                } else if (blockState.m_60713_(AEBlocks.DAMAGED_BUDDING_QUARTZ.block())) {
                    this.m_58904_().m_46597_(blockPos, ((BuddingCertusQuartzBlock)AEBlocks.CHIPPED_BUDDING_QUARTZ.block()).m_49966_());
                } else if (blockState.m_60713_(AEBlocks.CHIPPED_BUDDING_QUARTZ.block())) {
                    this.m_58904_().m_46597_(blockPos, ((BuddingCertusQuartzBlock)AEBlocks.FLAWED_BUDDING_QUARTZ.block()).m_49966_());
                }
                this.progress = 0;
            }
            return true;
        }
        this.progress = 0;
        return false;
    }

    private boolean checkFuel() {
        return !this.inv.getStackInSlot(0).m_41619_();
    }

    private void consumeFuel(RandomSource random) {
        if (random.m_188503_(10) < 1) {
            this.inv.extractItem(0, 1, false);
        }
    }

    private long userPower(int value) {
        if (this.getGridNode() == null) {
            return 0L;
        }
        IGrid grid = this.getGridNode().getGrid();
        if (grid != null) {
            return (long)grid.getEnergyService().extractAEPower((double)value, Actionable.MODULATE, PowerMultiplier.CONFIG);
        }
        return 0L;
    }

    protected boolean readFromStream(FriendlyByteBuf data) {
        boolean changed = super.readFromStream(data);
        this.inv.setItemDirect(0, data.m_130267_());
        return changed;
    }

    protected void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        data.m_130055_(this.inv.getStackInSlot(0));
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.COVERED;
    }

    public Set<Direction> getGridConnectableSides(BlockOrientation orientation) {
        return EnumSet.of(orientation.getSide(RelativeSide.BACK));
    }

    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        data.m_128405_("progress", this.progress);
    }

    public void loadTag(CompoundTag data) {
        super.loadTag(data);
        this.progress = data.m_128451_("progress");
    }

    public InternalInventory getInternalInventory() {
        return this.inv;
    }

    public void onChangeInventory(InternalInventory inv, int slot) {
        this.markForUpdate();
    }

    public void refuel(Player player) {
        if (!Platform.hasPermissions((DimensionalBlockPos)new DimensionalBlockPos((BlockEntity)this), (Player)player)) {
            return;
        }
        Inventory playerInv = player.m_150109_();
        ItemStack held = playerInv.m_36056_();
        if (held.m_41619_()) {
            ItemStack stuff = this.inv.extractItem(0, Integer.MAX_VALUE, false);
            if (!stuff.m_41619_()) {
                playerInv.m_150079_(stuff);
            }
        } else {
            ItemStack notAdded = this.inv.insertItem(0, held, false);
            playerInv.m_6836_(playerInv.f_35977_, notAdded);
        }
    }

    @Override
    public String jadeID() {
        return "crystal_fixer";
    }

    @Override
    public void collectJadeInfo(CompoundTag tag) {
        tag.m_128405_("progress", this.progress);
    }
}

